/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.INavigationContext;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.common.TypecastingObject;
import org.eclipse.riena.navigation.listener.INavigationNodeListenerable;
import org.eclipse.riena.navigation.ui.controllers.NavigationUIFilterApplier;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.resource.IIconManager;
import org.eclipse.riena.ui.core.resource.IconManagerAccessor;
import org.eclipse.riena.ui.core.resource.IconSize;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.riena.ui.ridgets.controller.IController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NavigationNodeController<N extends INavigationNode<?>>
extends TypecastingObject
implements INavigationNodeController,
IController {
    private N navigationNode;
    private Map<String, IRidget> ridgets = new HashMap<String, IRidget>();
    private NavigationUIFilterApplier<N> nodeListener;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();

    public NavigationNodeController() {
        this(null);
    }

    public NavigationNodeController(N navigationNode) {
        this.nodeListener = new NavigationUIFilterApplier();
        if (navigationNode != null) {
            this.setNavigationNode(navigationNode);
        }
    }

    public N getNavigationNode() {
        return this.navigationNode;
    }

    public void setNavigationNode(N navigationNode) {
        if (this.getNavigationNode() instanceof INavigationNodeListenerable) {
            ((INavigationNodeListenerable)this.getNavigationNode()).removeListener(this.nodeListener);
        }
        this.navigationNode = navigationNode;
        navigationNode.setNavigationNodeController((INavigationNodeController)this);
        if (this.getNavigationNode() instanceof INavigationNodeListenerable) {
            ((INavigationNodeListenerable)this.getNavigationNode()).addListener(this.nodeListener);
        }
    }

    public boolean allowsActivate(INavigationNode<?> pNode, INavigationContext context) {
        return true;
    }

    public boolean allowsDeactivate(INavigationNode<?> pNode, INavigationContext context) {
        return true;
    }

    public void afterBind() {
        this.updateNavigationNodeMarkers();
    }

    public boolean isActivated() {
        return this.getNavigationNode() != null && this.getNavigationNode().isActivated();
    }

    public boolean isEnabled() {
        return this.getNavigationNode() != null && this.getNavigationNode().isEnabled();
    }

    public boolean isVisible() {
        return this.getNavigationNode() != null && this.getNavigationNode().isVisible();
    }

    public boolean isDeactivated() {
        return this.getNavigationNode() == null || this.getNavigationNode().isDeactivated();
    }

    public boolean isCreated() {
        return this.getNavigationNode() == null || this.getNavigationNode().isCreated();
    }

    public boolean allowsDispose(INavigationNode<?> node, INavigationContext context) {
        return true;
    }

    public void addRidget(String id, IRidget ridget) {
        ridget.addPropertyChangeListener("marker", this.propertyChangeListener);
        this.ridgets.put(id, ridget);
    }

    public IRidget getRidget(String id) {
        return this.ridgets.get(id);
    }

    public Collection<? extends IRidget> getRidgets() {
        return this.ridgets.values();
    }

    private void addRidgetMarkers(IRidget ridget, List<IMarker> combinedMarkers) {
        if (ridget instanceof IMarkableRidget && ((IMarkableRidget)ridget).isVisible()) {
            this.addRidgetMarkers((IMarkableRidget)ridget, combinedMarkers);
        } else if (ridget instanceof IRidgetContainer) {
            this.addRidgetMarkers((IRidgetContainer)ridget, combinedMarkers);
        }
    }

    private void addRidgetMarkers(IMarkableRidget ridget, List<IMarker> combinedMarkers) {
        combinedMarkers.addAll(ridget.getMarkers());
    }

    private void addRidgetMarkers(IRidgetContainer ridgetContainer, List<IMarker> combinedMarkers) {
        for (IRidget ridget : ridgetContainer.getRidgets()) {
            this.addRidgetMarkers(ridget, combinedMarkers);
        }
    }

    protected void updateNavigationNodeMarkers() {
        this.getNavigationNode().removeAllMarkers();
        for (IMarker marker : this.getRidgetMarkers()) {
            MandatoryMarker mandatoryMarker;
            if (marker instanceof ErrorMarker) {
                this.getNavigationNode().addMarker(marker);
                continue;
            }
            if (!(marker instanceof MandatoryMarker) || (mandatoryMarker = (MandatoryMarker)marker).isDisabled()) continue;
            this.getNavigationNode().addMarker(marker);
        }
    }

    private List<IMarker> getRidgetMarkers() {
        ArrayList<IMarker> combinedMarkers = new ArrayList<IMarker>();
        this.addRidgetMarkers((IRidgetContainer)this, combinedMarkers);
        return combinedMarkers;
    }

    protected void updateIcon(IWindowRidget windowRidget) {
        IIconManager iconManager;
        if (windowRidget == null) {
            return;
        }
        String nodeIcon = this.getNavigationNode().getIcon();
        if (nodeIcon != null && !(iconManager = IconManagerAccessor.fetchIconManager()).hasExtension(nodeIcon)) {
            nodeIcon = iconManager.getIconID(nodeIcon, IconSize.A);
        }
        windowRidget.setIcon(nodeIcon);
    }

    public void setBlocked(boolean blocked) {
        if (this.getNavigationNode() != null) {
            this.getNavigationNode().setBlocked(blocked);
        }
    }

    public boolean isBlocked() {
        return this.getNavigationNode() != null && this.getNavigationNode().isBlocked();
    }

    public NavigationNodeController<?> getParentController() {
        if (this.getNavigationNode() != null && this.getNavigationNode().getParent() == null) {
            return null;
        }
        return (NavigationNodeController)this.navigationNode.getParent().getNavigationNodeController();
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            NavigationNodeController.this.updateNavigationNodeMarkers();
        }
    }
}

