/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.riena.core.util.VariableManagerUtil;
import org.eclipse.riena.navigation.IAssemblerProvider;
import org.eclipse.riena.navigation.IForEachExtension;
import org.eclipse.riena.navigation.IGenericNavigationAssembler;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleGroupNodeExtension;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.IModuleNodeExtension;
import org.eclipse.riena.navigation.INavigationAssembler;
import org.eclipse.riena.navigation.INavigationAssemblyExtension;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INodeExtension;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubApplicationNodeExtension;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ISubModuleNodeExtension;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ExtensionPointFailure;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.model.ThreadLocalMapResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericNavigationAssembler
implements IGenericNavigationAssembler {
    public static final String VAR_NAVIGATION_NODEID = "riena.navigation.nodeid";
    public static final String VAR_NAVIGATION_NODECONTEXT = "riena.navigation.nodecontext";
    public static final String VAR_NAVIGATION_PARAMETER = "riena.navigation.parameter";
    private static final String VARIABLE_START = "${";
    private static final char VARIABLE_ARG = ':';
    private static final char VARIABLE_END = '}';
    private INavigationAssemblyExtension assembly;
    private IAssemblerProvider assemblerProvider;
    private Set<String> acceptedTargetIds = null;

    @Override
    public INavigationAssemblyExtension getAssembly() {
        return this.assembly;
    }

    @Override
    public void setAssembly(INavigationAssemblyExtension nodeDefinition) {
        this.assembly = nodeDefinition;
    }

    @Override
    public void setAssemblerProvider(IAssemblerProvider assemblyProvider) {
        this.assemblerProvider = assemblyProvider;
    }

    public IAssemblerProvider getAssemblerProvider() {
        return this.assemblerProvider;
    }

    @Override
    public INavigationNode<?> buildNode(NavigationNodeId targetId, NavigationArgument navigationArgument) {
        if (this.assembly != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            ISubApplicationNodeExtension subapplicationDefinition = this.assembly.getSubApplicationNode();
            if (subapplicationDefinition != null) {
                return this.build(subapplicationDefinition, targetId, navigationArgument, context);
            }
            IModuleGroupNodeExtension groupDefinition = this.assembly.getModuleGroupNode();
            if (groupDefinition != null) {
                return this.build(groupDefinition, targetId, navigationArgument, context);
            }
            IModuleNodeExtension moduleDefinition = this.assembly.getModuleNode();
            if (moduleDefinition != null) {
                return this.build(moduleDefinition, targetId, navigationArgument, context);
            }
            ISubModuleNodeExtension submoduleDefinition = this.assembly.getSubModuleNode();
            if (submoduleDefinition != null) {
                return this.build(submoduleDefinition, targetId, navigationArgument, context);
            }
        }
        throw new ExtensionPointFailure("'subapplication', 'modulegroup', 'module' or 'submodule' element expected. ID=" + targetId.getTypeId());
    }

    @Override
    public boolean acceptsToBuildNode(NavigationNodeId nodeId, NavigationArgument argument) {
        return this.getAcceptedTargetIds().contains(nodeId.getTypeId());
    }

    public Collection<String> getAcceptedTargetIds() {
        if (this.acceptedTargetIds == null) {
            this.acceptedTargetIds = new HashSet<String>();
            this.initializeAcceptedTargetIds();
            this.acceptedTargetIds = Collections.unmodifiableSet(this.acceptedTargetIds);
        }
        return new HashSet<String>(this.acceptedTargetIds);
    }

    protected ISubApplicationNode build(ISubApplicationNodeExtension subapplicationDefinition, NavigationNodeId targetId, NavigationArgument navigationArgument, Map<String, Object> context) {
        Assert.isNotNull((Object)subapplicationDefinition, (String)"Error building subapplication. Subapplication cannot be null");
        Assert.isNotNull((Object)subapplicationDefinition.getViewId(), (String)("Error building subapplication. Attribute 'view' cannot be null for subapplication = " + subapplicationDefinition.getTypeId()));
        SubApplicationNode subapplication = new SubApplicationNode(this.createNavigationNodeIdFromTemplate(targetId, subapplicationDefinition, navigationArgument), subapplicationDefinition.getLabel());
        subapplication.setIcon(subapplicationDefinition.getIcon());
        this.updateContext(subapplication, navigationArgument);
        Map<IConfigurationElement, Object> elementMap = this.createElementMap(subapplicationDefinition);
        IConfigurationElement[] iConfigurationElementArray = subapplicationDefinition.getConfigurationElement().getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (elementMap.get(element) != null) {
                INavigationAssembler assembler;
                INavigationAssemblyExtension assemblyref;
                if (elementMap.get(element) instanceof IModuleGroupNodeExtension) {
                    subapplication.addChild(this.build((IModuleGroupNodeExtension)elementMap.get(element), targetId, navigationArgument, this.copy(context)));
                } else if (elementMap.get(element) instanceof INavigationAssemblyExtension && (assemblyref = (INavigationAssemblyExtension)elementMap.get(element)) != null && (assembler = this.getAssemblerProvider().getNavigationAssembler(assemblyref.getRef())) != null && assembler.getAssembly().getModuleGroupNode() != null) {
                    subapplication.addChild(this.build(assembler.getAssembly().getModuleGroupNode(), targetId, navigationArgument, this.copy(context)));
                }
            }
            ++n2;
        }
        return subapplication;
    }

    protected IModuleGroupNode build(IModuleGroupNodeExtension groupDefinition, NavigationNodeId targetId, NavigationArgument navigationArgument, Map<String, Object> context) {
        ModuleGroupNode moduleGroup = new ModuleGroupNode(this.createNavigationNodeIdFromTemplate(targetId, groupDefinition, navigationArgument));
        this.updateContext(moduleGroup, navigationArgument);
        Map<IConfigurationElement, Object> elementMap = this.createElementMap(groupDefinition);
        IConfigurationElement[] iConfigurationElementArray = groupDefinition.getConfigurationElement().getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (elementMap.get(element) != null) {
                INavigationAssembler assembler;
                INavigationAssemblyExtension assemblyref;
                if (elementMap.get(element) instanceof IModuleNodeExtension) {
                    moduleGroup.addChild(this.build((IModuleNodeExtension)elementMap.get(element), targetId, navigationArgument, this.copy(context)));
                } else if (elementMap.get(element) instanceof INavigationAssemblyExtension && (assemblyref = (INavigationAssemblyExtension)elementMap.get(element)) != null && (assembler = this.getAssemblerProvider().getNavigationAssembler(assemblyref.getRef())) != null && assembler.getAssembly().getModuleNode() != null) {
                    moduleGroup.addChild(this.build(assembler.getAssembly().getModuleNode(), targetId, navigationArgument, this.copy(context)));
                }
            }
            ++n2;
        }
        return moduleGroup;
    }

    protected IModuleNode build(IModuleNodeExtension moduleDefinition, NavigationNodeId targetId, NavigationArgument navigationArgument, Map<String, Object> context) {
        ModuleNode module = null;
        Map<String, Object> mapping = this.createMapping(targetId, navigationArgument);
        try {
            this.startVariableResolver(mapping);
            module = new ModuleNode(this.createNavigationNodeIdFromTemplate(targetId, moduleDefinition, navigationArgument), moduleDefinition.getLabel());
            module.setIcon(moduleDefinition.getIcon());
            module.setClosable(!moduleDefinition.isUnclosable());
            this.updateContext(module, navigationArgument);
            Map<IConfigurationElement, Object> elementMap = this.createElementMap(moduleDefinition);
            IConfigurationElement[] iConfigurationElementArray = moduleDefinition.getConfigurationElement().getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (elementMap.get(element) != null) {
                    INavigationAssembler assembler;
                    INavigationAssemblyExtension assemblyref;
                    if (elementMap.get(element) instanceof ISubModuleNodeExtension) {
                        module.addChild(this.build((ISubModuleNodeExtension)elementMap.get(element), targetId, navigationArgument, this.copy(context)));
                    } else if (elementMap.get(element) instanceof INavigationAssemblyExtension && (assemblyref = (INavigationAssemblyExtension)elementMap.get(element)) != null && (assembler = this.getAssemblerProvider().getNavigationAssembler(assemblyref.getRef())) != null && assembler.getAssembly().getSubModuleNode() != null) {
                        module.addChild(this.build(assembler.getAssembly().getSubModuleNode(), targetId, navigationArgument, this.copy(context)));
                    }
                }
                ++n2;
            }
        }
        finally {
            this.cleanupVariableResolver();
        }
        return module;
    }

    protected ISubModuleNode build(ISubModuleNodeExtension submoduleDefinition, NavigationNodeId targetId, NavigationArgument navigationArgument, Map<String, Object> context) {
        SubModuleNode submodule = null;
        Map<String, Object> mapping = this.createMapping(targetId, navigationArgument);
        mapping.put(VAR_NAVIGATION_NODECONTEXT, context);
        try {
            this.startVariableResolver(mapping);
            submodule = new SubModuleNode(this.createNavigationNodeIdFromTemplate(targetId, submoduleDefinition, navigationArgument), submoduleDefinition.getLabel());
            submodule.setIcon(submoduleDefinition.getIcon());
            this.updateContext(submodule, navigationArgument);
            Map<IConfigurationElement, Object> elementMap = this.createElementMap(submoduleDefinition);
            IConfigurationElement[] iConfigurationElementArray = submoduleDefinition.getConfigurationElement().getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (elementMap.get(element) != null) {
                    if (elementMap.get(element) instanceof ISubModuleNodeExtension) {
                        submodule.addChild(this.build((ISubModuleNodeExtension)elementMap.get(element), targetId, navigationArgument, this.copy(context)));
                    } else if (elementMap.get(element) instanceof INavigationAssemblyExtension) {
                        INavigationAssembler assembler;
                        INavigationAssemblyExtension assemblyref = (INavigationAssemblyExtension)elementMap.get(element);
                        if (assemblyref != null && (assembler = this.getAssemblerProvider().getNavigationAssembler(assemblyref.getRef())) != null && assembler.getAssembly().getSubModuleNode() != null) {
                            submodule.addChild(this.build(assembler.getAssembly().getSubModuleNode(), targetId, navigationArgument, this.copy(context)));
                        }
                    } else if (elementMap.get(element) instanceof IForEachExtension) {
                        this.processForeachLoop(targetId, navigationArgument, context, submodule, (IForEachExtension)elementMap.get(element));
                    }
                }
                ++n2;
            }
        }
        finally {
            this.cleanupVariableResolver();
        }
        return submodule;
    }

    private void processForeachLoop(NavigationNodeId targetId, NavigationArgument navigationArgument, Map<String, Object> context, ISubModuleNode submodule, IForEachExtension foreach) {
        String loopVar = foreach.getElement();
        String in = foreach.getIn();
        String variable = this.getVariable(in);
        String argument = this.getArgument(in);
        if (variable != null) {
            try {
                Object bean = this.resolveCoreVariable(variable, navigationArgument);
                if (bean != null) {
                    Object obj = bean;
                    if (argument != null) {
                        obj = new PropertyUtilsBean().getNestedProperty(bean, argument);
                    }
                    if (obj != null) {
                        if (obj instanceof Collection) {
                            for (Object each : (Collection)obj) {
                                Map<String, Object> nodecontext = this.copy(context);
                                nodecontext.put(loopVar, each);
                                ISubModuleNodeExtension[] iSubModuleNodeExtensionArray = foreach.getSubModuleNodes();
                                int n = iSubModuleNodeExtensionArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ISubModuleNodeExtension nestedSubmoduleDefinition = iSubModuleNodeExtensionArray[n2];
                                    submodule.addChild(this.build(nestedSubmoduleDefinition, targetId, navigationArgument, nodecontext));
                                    ++n2;
                                }
                            }
                        } else if (obj.getClass().isArray()) {
                            Object[] objectArray = (Object[])obj;
                            int n = objectArray.length;
                            int n3 = 0;
                            while (n3 < n) {
                                Object each = objectArray[n3];
                                Map<String, Object> nodecontext = this.copy(context);
                                nodecontext.put(loopVar, each);
                                ISubModuleNodeExtension[] iSubModuleNodeExtensionArray = foreach.getSubModuleNodes();
                                int n4 = iSubModuleNodeExtensionArray.length;
                                int n5 = 0;
                                while (n5 < n4) {
                                    ISubModuleNodeExtension nestedSubmoduleDefinition = iSubModuleNodeExtensionArray[n5];
                                    submodule.addChild(this.build(nestedSubmoduleDefinition, targetId, navigationArgument, nodecontext));
                                    ++n5;
                                }
                                ++n3;
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected Map<String, Object> copy(Map<String, Object> context) {
        return new HashMap<String, Object>(context);
    }

    private void initializeAcceptedTargetIds() {
        if (this.assembly != null) {
            ISubModuleNodeExtension submoduleDefinition;
            IModuleNodeExtension moduleDefinition;
            IModuleGroupNodeExtension groupDefinition;
            ISubApplicationNodeExtension subapplicationDefinition = this.assembly.getSubApplicationNode();
            if (subapplicationDefinition != null) {
                this.resolveTargetIds(subapplicationDefinition);
            }
            if ((groupDefinition = this.assembly.getModuleGroupNode()) != null) {
                this.resolveTargetIds(groupDefinition);
            }
            if ((moduleDefinition = this.assembly.getModuleNode()) != null) {
                this.resolveTargetIds(moduleDefinition);
            }
            if ((submoduleDefinition = this.assembly.getSubModuleNode()) != null) {
                this.resolveTargetIds(submoduleDefinition);
            }
        }
    }

    private void resolveTargetIds(ISubApplicationNodeExtension subapplicationDefinition) {
        this.updateAcceptedTargetIds(subapplicationDefinition);
        IModuleGroupNodeExtension[] iModuleGroupNodeExtensionArray = subapplicationDefinition.getModuleGroupNodes();
        int n = iModuleGroupNodeExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleGroupNodeExtension groupDefinition = iModuleGroupNodeExtensionArray[n2];
            this.resolveTargetIds(groupDefinition);
            ++n2;
        }
    }

    private void resolveTargetIds(IModuleGroupNodeExtension groupDefinition) {
        this.updateAcceptedTargetIds(groupDefinition);
        IModuleNodeExtension[] iModuleNodeExtensionArray = groupDefinition.getModuleNodes();
        int n = iModuleNodeExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleNodeExtension moduleDefinition = iModuleNodeExtensionArray[n2];
            this.resolveTargetIds(moduleDefinition);
            ++n2;
        }
    }

    private void resolveTargetIds(IModuleNodeExtension moduleDefinition) {
        this.updateAcceptedTargetIds(moduleDefinition);
        ISubModuleNodeExtension[] iSubModuleNodeExtensionArray = moduleDefinition.getSubModuleNodes();
        int n = iSubModuleNodeExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISubModuleNodeExtension submoduleDefinition = iSubModuleNodeExtensionArray[n2];
            this.resolveTargetIds(submoduleDefinition);
            ++n2;
        }
    }

    private void resolveTargetIds(ISubModuleNodeExtension submoduleDefinition) {
        this.updateAcceptedTargetIds(submoduleDefinition);
        ISubModuleNodeExtension[] iSubModuleNodeExtensionArray = submoduleDefinition.getSubModuleNodes();
        int n = iSubModuleNodeExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISubModuleNodeExtension nestedDefinition = iSubModuleNodeExtensionArray[n2];
            this.resolveTargetIds(nestedDefinition);
            ++n2;
        }
    }

    private void updateAcceptedTargetIds(INodeExtension nodeDefinition) {
        if (nodeDefinition.getTypeId() != null) {
            this.acceptedTargetIds.add(nodeDefinition.getTypeId());
        }
    }

    protected void updateContext(INavigationNode<?> node, NavigationArgument navigationArgument) {
        if (navigationArgument != null) {
            node.setContext(VAR_NAVIGATION_PARAMETER, navigationArgument.getParameter());
        }
    }

    protected NavigationNodeId createNavigationNodeIdFromTemplate(NavigationNodeId template, INodeExtension nodeExtendion, NavigationArgument navigationArgument) {
        String typeId = nodeExtendion.getTypeId();
        String instanceId = nodeExtendion.getInstanceId() == null ? template.getInstanceId() : nodeExtendion.getInstanceId();
        return new NavigationNodeId(typeId, instanceId);
    }

    protected String resolveVariables(String string) {
        try {
            return VariableManagerUtil.substitute((String)string);
        }
        catch (CoreException ex) {
            ex.printStackTrace();
            return string;
        }
    }

    protected Map<String, Object> createMapping(NavigationNodeId targetId, NavigationArgument navigationArgument) {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put(VAR_NAVIGATION_NODEID, targetId);
        if (navigationArgument != null) {
            mapping.put(VAR_NAVIGATION_PARAMETER, navigationArgument.getParameter());
        }
        return mapping;
    }

    protected void startVariableResolver(Map<String, Object> mapping) {
        ThreadLocalMapResolver.configure(mapping);
    }

    protected void cleanupVariableResolver() {
        ThreadLocalMapResolver.cleanup();
    }

    private Map<IConfigurationElement, Object> createElementMap(INodeExtension nodeDefinition) {
        IForEachExtension foreachDefinition;
        HashMap<IConfigurationElement, Object> elementMap = new HashMap<IConfigurationElement, Object>();
        Object[] objectArray = nodeDefinition.getChildNodes();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            INodeExtension childNodeDefinition = objectArray[n2];
            elementMap.put(childNodeDefinition.getConfigurationElement(), childNodeDefinition);
            ++n2;
        }
        objectArray = nodeDefinition.getAssemblies();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object assemblyref = objectArray[n2];
            elementMap.put(assemblyref.getConfigurationElement(), assemblyref);
            ++n2;
        }
        if (nodeDefinition instanceof ISubModuleNodeExtension && (foreachDefinition = ((ISubModuleNodeExtension)nodeDefinition).getForeach()) != null) {
            elementMap.put(foreachDefinition.getConfigurationElement(), foreachDefinition);
        }
        return elementMap;
    }

    private String getVariable(String variableDef) {
        int variableArgumentSeparator;
        int start = 0;
        if (variableDef.startsWith(VARIABLE_START)) {
            start += VARIABLE_START.length();
        }
        if ((variableArgumentSeparator = variableDef.indexOf(58)) > 0) {
            return variableDef.substring(start, variableArgumentSeparator);
        }
        int end = variableDef.length();
        if (variableDef.charAt(end - 1) == '}') {
            --end;
        }
        return variableDef.substring(start, end);
    }

    private String getArgument(String variableDef) {
        int variableArgumentSeparator;
        int end = variableDef.length();
        if (variableDef.charAt(end - 1) == '}') {
            --end;
        }
        if ((variableArgumentSeparator = variableDef.indexOf(58)) > 0) {
            return variableDef.substring(variableArgumentSeparator + 1, end);
        }
        return null;
    }

    protected Object resolveCoreVariable(String variable, NavigationArgument navigationArgument) {
        if (VAR_NAVIGATION_PARAMETER.equals(variable)) {
            return navigationArgument.getParameter();
        }
        return null;
    }
}

