/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.EventHandler;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.ActionObserver;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;

public class ActionRidget
extends AbstractSWTRidget
implements IActionRidget {
    private static final String EMPTY_STRING = "";
    private Button button;
    private String text;
    private String icon;
    private ActionObserver actionObserver = new ActionObserver();
    private boolean textAlreadyInitialized = false;
    private boolean useRidgetIcon = false;

    protected void checkUIControl(Object uiControl) {
        ActionRidget.assertType(uiControl, Button.class);
    }

    protected void bindUIControl() {
        Button control = this.getUIControl();
        if (control != null) {
            this.button = control;
            this.initText();
            this.button.addSelectionListener((SelectionListener)this.actionObserver);
            this.updateUIText();
            this.updateUIIcon();
        }
    }

    private void initText() {
        if (this.text == null && !this.textAlreadyInitialized && this.getUIControl() != null && !this.getUIControl().isDisposed()) {
            this.text = this.getUIControl().getText();
            if (this.text == null) {
                this.text = EMPTY_STRING;
            }
            this.textAlreadyInitialized = true;
        }
    }

    protected void unbindUIControl() {
        if (this.button != null) {
            this.button.removeSelectionListener((SelectionListener)this.actionObserver);
            this.button = null;
        }
    }

    public Button getUIControl() {
        return (Button)super.getUIControl();
    }

    public final void addListener(IActionListener listener) {
        this.actionObserver.addListener(listener);
    }

    public final void addListener(Object target, String action) {
        this.addListener(EventHandler.create(IActionListener.class, target, action));
    }

    public final void removeListener(IActionListener listener) {
        this.actionObserver.removeListener(listener);
    }

    public boolean isDisableMandatoryMarker() {
        return true;
    }

    public String getIcon() {
        return this.icon;
    }

    public final String getText() {
        return this.text;
    }

    public void setIcon(String icon) {
        boolean oldUseRidgetIcon = this.useRidgetIcon;
        this.useRidgetIcon = true;
        String oldIcon = this.icon;
        this.icon = icon;
        if (this.hasChanged(oldIcon, icon) || !oldUseRidgetIcon) {
            this.updateUIIcon();
        }
    }

    public final void setText(String newText) {
        this.text = newText;
        this.updateUIText();
    }

    private void updateUIText() {
        if (this.button != null) {
            this.button.setText(this.text);
        }
    }

    private void updateUIIcon() {
        Button control = this.getUIControl();
        if (control != null) {
            Image image = null;
            if (this.icon != null) {
                image = this.getManagedImage(this.icon);
            }
            if (image != null || this.useRidgetIcon) {
                control.setImage(image);
            }
        }
    }
}

