/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.NumericString;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.ridgets.INumericTextRidget;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;

public class NumericTextRidget
extends TextRidget
implements INumericTextRidget {
    protected static final char DECIMAL_SEPARATOR = new DecimalFormatSymbols().getDecimalSeparator();
    protected static final char GROUPING_SEPARATOR = new DecimalFormatSymbols().getGroupingSeparator();
    private static final char MINUS_SIGN = new DecimalFormatSymbols().getMinusSign();
    private static final char ZERO = '0';
    private static final String MINUS_ZERO = String.valueOf(String.valueOf(MINUS_SIGN)) + '0';
    private static final String MINUS_DEC = String.valueOf(String.valueOf(MINUS_SIGN)) + DECIMAL_SEPARATOR;
    private final NumericVerifyListener verifyListener = new NumericVerifyListener();
    private final NumericModifyListener modifyListener = new NumericModifyListener();
    private final KeyListener keyListener = new NumericKeyListener();
    private final FocusListener focusListener = new NumericFocusListener();
    private boolean isSigned = true;
    private boolean isGrouping = true;
    private boolean isMarkNegative = true;
    private NegativeMarker negativeMarker;
    private int maxLength = -1;
    private int precision = -1;

    public static String group(String input, boolean isGrouping, boolean isDecimal) {
        String result = input;
        int decIndex = input.indexOf(DECIMAL_SEPARATOR);
        if (isGrouping) {
            String left = decIndex == -1 ? input : input.substring(0, decIndex);
            String right = decIndex == -1 ? "" : input.substring(decIndex);
            result = String.valueOf(NumericTextRidget.group(left)) + right;
        }
        if (decIndex == -1 && isDecimal) {
            result = String.valueOf(result) + DECIMAL_SEPARATOR;
        }
        return result;
    }

    public static String ungroup(String input) {
        StringBuilder result = new StringBuilder(input.length());
        int i = 0;
        while (i < input.length()) {
            char ch = input.charAt(i);
            if (ch != GROUPING_SEPARATOR) {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    public static String removeLeadingZeroes(String input) {
        if (String.valueOf(MINUS_SIGN).equals(input) || MINUS_ZERO.equals(input) || String.valueOf('0').equals(input)) {
            return String.valueOf('0');
        }
        StringBuilder result = new StringBuilder(input.length());
        int start = 0;
        if (input.indexOf(MINUS_SIGN) == 0) {
            result.append(MINUS_SIGN);
            ++start;
        }
        if (start < input.length() && '0' == input.charAt(start)) {
            int newStart = start + 1;
            while (newStart < input.length() && '0' == input.charAt(newStart)) {
                ++newStart;
            }
            if (newStart == input.length()) {
                result.append('0');
                if (MINUS_ZERO.equals(result.toString())) {
                    result.delete(0, 1);
                }
            } else {
                result.append(input.substring(newStart));
            }
        } else {
            result.append(input.substring(start));
        }
        return result.toString();
    }

    private static String group(String input) {
        int numLength = input.length();
        boolean isNegative = input.indexOf(MINUS_SIGN) == 0;
        int groupSize = 3;
        int delta = isNegative ? -2 : -1;
        int groupCount = (numLength + delta) / groupSize;
        char[] result = new char[numLength + groupCount];
        Arrays.fill(result, '#');
        int availableChars = groupSize + 1;
        int i = result.length - 1;
        while (i > 0) {
            if (--availableChars == 0) {
                result[i] = GROUPING_SEPARATOR;
                availableChars = groupSize + 1;
            }
            --i;
        }
        i = 0;
        int j = 0;
        while (i < result.length) {
            if ('#' == result[i]) {
                result[i] = input.charAt(j);
                ++j;
            }
            ++i;
        }
        return String.valueOf(result);
    }

    public NumericTextRidget() {
        super("0");
        this.addPropertyChangeListener("text", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                NumericTextRidget.this.updateMarkNegative();
            }
        });
    }

    protected void checkNumber(String number) {
        if (!"".equals(number)) {
            try {
                new BigInteger(NumericTextRidget.ungroup(number));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("Not a valid number: " + number);
            }
        }
    }

    protected void checkUIControl(Object uiControl) {
        int style;
        super.checkUIControl(uiControl);
        AbstractSWTRidget.assertType(uiControl, Text.class);
        if (uiControl != null && ((style = ((Text)uiControl).getStyle()) & 4) == 0) {
            throw new BindingException("Text widget must be SWT.SINGLE");
        }
    }

    protected final synchronized void addListeners(Text control) {
        control.addVerifyListener((VerifyListener)this.verifyListener);
        control.addModifyListener((ModifyListener)this.modifyListener);
        control.addKeyListener(this.keyListener);
        control.addFocusListener(this.focusListener);
        super.addListeners(control);
    }

    protected synchronized int getPrecision() {
        return this.precision;
    }

    protected synchronized int getMaxLength() {
        return this.maxLength;
    }

    protected boolean isNegative(String text) {
        BigInteger value = new BigInteger(text);
        return value.compareTo(BigInteger.ZERO) < 0;
    }

    protected final synchronized void removeListeners(Text control) {
        control.removeFocusListener(this.focusListener);
        control.removeKeyListener(this.keyListener);
        control.removeModifyListener((ModifyListener)this.modifyListener);
        control.removeVerifyListener((VerifyListener)this.verifyListener);
        super.removeListeners(control);
    }

    protected synchronized void setPrecision(int precision) {
        String newText;
        this.precision = precision;
        String oldText = this.getText();
        if (!oldText.equals(newText = this.formatFraction(oldText))) {
            this.setText(newText);
        }
    }

    protected synchronized void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public synchronized boolean isGrouping() {
        return this.isGrouping;
    }

    public synchronized boolean isMarkNegative() {
        return this.isMarkNegative;
    }

    public synchronized boolean isSigned() {
        return this.isSigned;
    }

    public synchronized void setGrouping(boolean useGrouping) {
        if (this.isGrouping != useGrouping) {
            this.isGrouping = useGrouping;
            this.updateGrouping();
        }
    }

    public synchronized void setMarkNegative(boolean mustBeMarked) {
        if (this.isMarkNegative != mustBeMarked) {
            this.isMarkNegative = mustBeMarked;
            this.updateMarkNegative();
        }
    }

    public final synchronized void setSigned(boolean signed) {
        if (this.isSigned != signed) {
            boolean oldValue = this.isSigned;
            this.isSigned = signed;
            this.firePropertyChange("signed", oldValue, this.isSigned);
        }
    }

    public final synchronized void setText(String text) {
        this.checkNumber(text);
        super.setText(NumericTextRidget.group(NumericTextRidget.ungroup(text), this.isGrouping, this.isDecimal()));
    }

    public synchronized String getText() {
        String result = super.getText();
        if (this.isDecimal()) {
            result = this.removeTrailingPadding(result);
        }
        return result;
    }

    public synchronized void updateFromModel() {
        super.updateFromModel();
        if (this.isDecimal()) {
            this.beautifyText(this.getUIControl());
        }
    }

    private void beautifyText(Text control) {
        if (control != null) {
            String text = control.getText();
            String newText = this.formatFraction(text);
            if (newText.length() > 0 && newText.charAt(0) == DECIMAL_SEPARATOR) {
                newText = "0" + newText;
            } else if (newText.startsWith(MINUS_DEC)) {
                boolean hasValue = false;
                int i = 0;
                while (!hasValue && i < newText.length()) {
                    char ch = newText.charAt(i);
                    hasValue = Character.isDigit(ch) && ch != '0';
                    ++i;
                }
                newText = hasValue ? String.valueOf(newText.substring(0, 1)) + "0" + newText.substring(1) : "0" + newText.substring(1);
            }
            if (!newText.equals(text)) {
                this.stopVerifyListener();
                this.stopModifyListener();
                control.setText(newText);
                control.setSelection(newText.length());
                this.startModifyListener();
                this.startVerifyListener();
            }
        }
    }

    private void startModifyListener() {
        this.modifyListener.setEnabled(true);
    }

    private void startVerifyListener() {
        this.verifyListener.setEnabled(true);
    }

    private synchronized String createPattern(String input) {
        String result;
        if (this.isDecimal()) {
            String decSep = DECIMAL_SEPARATOR == '.' ? "\\." : String.valueOf(DECIMAL_SEPARATOR);
            result = String.format("\\d{0,%d}%s\\d{0,%d}", this.getMaxLength(), decSep, this.getPrecision());
            if (this.isSigned) {
                result = String.valueOf(String.format("%c?", Character.valueOf(MINUS_SIGN))) + result;
            }
        } else {
            int length = input.length();
            if (this.isSigned) {
                int min = Math.max(0, length - 1);
                result = String.format("%c?\\d{%d,%d}", Character.valueOf(MINUS_SIGN), min, length);
            } else {
                result = String.format("\\d{%d}", length);
            }
        }
        return result;
    }

    private String formatFraction(String text) {
        String result = text;
        int decSep = text.indexOf(DECIMAL_SEPARATOR);
        if (decSep != -1) {
            int prec;
            int fractionDigits = text.substring(decSep).length() - 1;
            if (fractionDigits < (prec = this.getPrecision())) {
                int pad = Math.max(0, this.getPrecision() - fractionDigits);
                if (pad > 0) {
                    char[] zeroes = new char[pad];
                    Arrays.fill(zeroes, '0');
                    result = String.valueOf(text) + String.valueOf(zeroes);
                }
            } else if (fractionDigits > prec) {
                int diff = fractionDigits - prec;
                result = text.substring(0, text.length() - diff);
            }
        }
        return result;
    }

    private boolean isDecimal() {
        return this.getPrecision() != -1;
    }

    private String removeTrailingPadding(String text) {
        String result = text;
        int decSep = text.indexOf(DECIMAL_SEPARATOR);
        if (decSep != -1) {
            int index = text.length() - 1;
            char ch = result.charAt(index);
            while (index >= decSep && ch == DECIMAL_SEPARATOR | ch == '0') {
                result = result.substring(0, index);
                if (--index < decSep) continue;
                ch = result.charAt(index);
            }
        }
        return result;
    }

    private void stopModifyListener() {
        this.modifyListener.setEnabled(false);
    }

    private void stopVerifyListener() {
        this.verifyListener.setEnabled(false);
    }

    private void updateGrouping() {
        this.setText(this.getText());
    }

    private void updateMarkNegative() {
        String text = NumericTextRidget.ungroup(this.getText());
        boolean needMarker = false;
        if (this.isMarkNegative()) {
            try {
                needMarker = this.isNegative(text);
            }
            catch (NumberFormatException numberFormatException) {
                needMarker = false;
            }
        }
        if (needMarker) {
            if (this.negativeMarker == null) {
                this.negativeMarker = new NegativeMarker();
            }
            this.addMarker((IMarker)this.negativeMarker);
        } else if (this.negativeMarker != null) {
            this.removeMarker((IMarker)this.negativeMarker);
        }
    }

    private final class NumericFocusListener
    extends FocusAdapter {
        private NumericFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            if (NumericTextRidget.this.isDecimal()) {
                Text control = (Text)e.widget;
                NumericTextRidget.this.beautifyText(control);
            }
        }
    }

    private final class NumericKeyListener
    extends KeyAdapter {
        private boolean shiftDown = false;

        private NumericKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (131072 == e.keyCode) {
                this.shiftDown = false;
            }
        }

        public void keyPressed(KeyEvent e) {
            String newText;
            Text control = (Text)e.widget;
            String text = control.getText();
            if (131072 == e.keyCode) {
                this.shiftDown = true;
            } else if (0x1000003 == e.keyCode && control.getSelectionCount() == 0) {
                int index = control.getCaretPosition() - 1;
                if (index > 1 && GROUPING_SEPARATOR == text.charAt(index) && !this.shiftDown) {
                    e.doit = false;
                    control.setSelection(index - 1);
                }
            } else if (0x1000004 == e.keyCode && control.getSelectionCount() == 0) {
                int index = control.getCaretPosition() + 1;
                if (index < text.length() - 1 && GROUPING_SEPARATOR == text.charAt(index) && !this.shiftDown) {
                    e.doit = false;
                    control.setSelection(index + 1);
                }
            } else if (DECIMAL_SEPARATOR == e.character) {
                e.doit = false;
                int index = control.getCaretPosition();
                if (index < text.length() && text.charAt(index) == DECIMAL_SEPARATOR) {
                    control.setSelection(index + 1);
                } else {
                    NumericTextRidget.this.flash();
                }
            } else if (MINUS_SIGN == e.character) {
                e.doit = false;
                if (NumericTextRidget.this.isSigned()) {
                    Event event = new Event();
                    event.type = 25;
                    event.character = MINUS_SIGN;
                    event.start = 0;
                    event.end = 0;
                    event.widget = control;
                    event.text = String.valueOf(MINUS_SIGN);
                    control.notifyListeners(25, event);
                    if (event.doit) {
                        int caret = control.getCaretPosition() + 1;
                        NumericTextRidget.this.stopVerifyListener();
                        control.setText(String.valueOf(MINUS_SIGN) + text);
                        control.setSelection(caret);
                        NumericTextRidget.this.startVerifyListener();
                    } else {
                        NumericTextRidget.this.flash();
                    }
                } else {
                    NumericTextRidget.this.flash();
                }
            } else if ('\r' == e.character && NumericTextRidget.this.isDecimal() && !(newText = NumericTextRidget.this.formatFraction(text)).equals(text)) {
                NumericTextRidget.this.stopVerifyListener();
                control.setText(newText);
                control.setSelection(newText.length());
                NumericTextRidget.this.startVerifyListener();
            }
        }
    }

    private final class NumericModifyListener
    implements ModifyListener {
        private boolean isEnabled = true;

        private NumericModifyListener() {
        }

        public synchronized void setEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public synchronized void modifyText(ModifyEvent e) {
            String newText;
            if (!this.isEnabled || !NumericTextRidget.this.isEnabled()) {
                return;
            }
            Text control = (Text)e.widget;
            String oldText = control.getText();
            if (!oldText.equals(newText = NumericTextRidget.group(NumericTextRidget.removeLeadingZeroes(NumericTextRidget.ungroup(oldText)), NumericTextRidget.this.isGrouping(), NumericTextRidget.this.isDecimal()))) {
                NumericTextRidget.this.stopVerifyListener();
                int posFromRight = oldText.length() - control.getCaretPosition();
                control.setText(newText);
                int caretPos = newText.length() - posFromRight;
                control.setSelection(caretPos);
                NumericTextRidget.this.startVerifyListener();
            }
        }
    }

    private final class NumericVerifyListener
    implements VerifyListener {
        private boolean isEnabled = true;

        private NumericVerifyListener() {
        }

        public synchronized void setEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public synchronized void verifyText(VerifyEvent e) {
            if (!e.doit || !this.isEnabled) {
                return;
            }
            Text control = (Text)e.widget;
            String oldText = control.getText();
            String newText = null;
            int newCursorPos = -1;
            boolean applyText = false;
            if (Character.isDigit(e.character) || MINUS_SIGN == e.character) {
                boolean preserveDecSep;
                boolean bl = preserveDecSep = oldText.substring(e.start, e.end).indexOf(DECIMAL_SEPARATOR) != -1;
                if (preserveDecSep) {
                    newText = oldText.charAt(e.start) == DECIMAL_SEPARATOR && oldText.length() > e.end - e.start ? String.valueOf(oldText.substring(0, e.start)) + DECIMAL_SEPARATOR + e.character + oldText.substring(e.end) : String.valueOf(oldText.substring(0, e.start)) + e.character + DECIMAL_SEPARATOR + oldText.substring(e.end);
                    applyText = true;
                } else {
                    newText = String.valueOf(oldText.substring(0, e.start)) + e.character + oldText.substring(e.end);
                }
            } else if ('\b' == e.character || 127 == e.keyCode) {
                NumericString ns = new NumericString(oldText, NumericTextRidget.this.isGrouping());
                newCursorPos = ns.delete(e.start, e.end, e.character);
                newText = ns.toString();
                applyText = true;
            }
            boolean doFlash = true;
            if (newText != null) {
                String newTextNoGroup = NumericTextRidget.ungroup(newText);
                String regex = NumericTextRidget.this.createPattern(newTextNoGroup);
                e.doit = Pattern.matches(regex, newTextNoGroup);
                boolean bl = doFlash = !e.doit;
                if (e.doit && applyText) {
                    e.doit = false;
                    NumericTextRidget.this.stopVerifyListener();
                    this.setTextAndCursor(control, newTextNoGroup, newCursorPos, e);
                    NumericTextRidget.this.startVerifyListener();
                }
            } else {
                e.doit = false;
            }
            if (doFlash) {
                NumericTextRidget.this.flash();
            }
        }

        private void setTextAndCursor(Text control, String text, int cursorPos, VerifyEvent e) {
            String oldText = control.getText();
            int oldCursorPos = control.getCaretPosition();
            control.setText(text);
            if (oldCursorPos != 0 && text.length() == 1 && text.charAt(0) == DECIMAL_SEPARATOR) {
                control.setSelection(0);
            } else if (text.length() == 2 && text.charAt(1) == DECIMAL_SEPARATOR) {
                control.setSelection(1);
            } else if (cursorPos > -1) {
                control.setSelection(cursorPos);
            } else {
                int posFromRight = oldText.length() - e.end;
                control.setSelection(control.getText().length() - posFromRight);
            }
        }
    }
}

