/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.riena.ui.ridgets.AbstractCompositeRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineNumberRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineUIProcessRidget;
import org.eclipse.riena.ui.swt.Statusline;
import org.eclipse.riena.ui.swt.StatuslineMessage;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.ImageUtil;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.graphics.Image;

public class StatuslineRidget
extends AbstractCompositeRidget
implements IStatuslineRidget {
    private static final String LONG_EMPTY_STRING = "            ";
    private static Image missingImage;
    private String message = "            ";
    private String icon;
    private Image image;
    private IStatuslineNumberRidget statuslineNumberRidget;
    private IStatuslineUIProcessRidget statuslineUIProcessRidget;

    public Statusline getUIControl() {
        return (Statusline)super.getUIControl();
    }

    public void setUIControl(Object uiControl) {
        super.setUIControl(uiControl);
        this.bindUIControl();
    }

    protected void bindUIControl() {
        this.updateUIIcon();
    }

    public final StatuslineMessage getStatuslineMessage() {
        return this.getUIControl().getMessageComposite();
    }

    public void clear() {
        this.setMessage(LONG_EMPTY_STRING);
        this.icon = null;
        this.image = null;
        this.updateUIIcon();
    }

    public void error(String message) {
        this.setImage(LnfManager.getLnf().getImage("statusline.errorIcon"));
        this.setMessage(message);
    }

    public String getIcon() {
        return this.icon;
    }

    public String getMessage() {
        return this.message;
    }

    public IStatuslineNumberRidget getStatuslineNumberRidget() {
        return this.statuslineNumberRidget;
    }

    public void setStatuslineNumberRidget(IStatuslineNumberRidget statuslineNumberRidget) {
        this.statuslineNumberRidget = statuslineNumberRidget;
        this.addRidget("statuslineNumberRidget", (IRidget)statuslineNumberRidget);
    }

    public void setStatuslineUIProcessRidget(IStatuslineUIProcessRidget statuslineUIProcessRidget) {
        this.addRidget("statuslineUIProcessRidget", (IRidget)statuslineUIProcessRidget);
        this.statuslineUIProcessRidget = statuslineUIProcessRidget;
    }

    public IStatuslineUIProcessRidget getStatuslineUIProcessRidget() {
        return this.statuslineUIProcessRidget;
    }

    public void hidePopups() {
    }

    public void info(String message) {
        this.setImage(LnfManager.getLnf().getImage("statusline.infoIcon"));
        this.setMessage(message);
    }

    public void setIcon(String icon) {
        this.icon = icon;
        this.image = null;
        this.updateUIIcon();
    }

    private void setImage(Image image) {
        this.image = image;
        this.icon = null;
        this.updateUIIcon();
    }

    public void setMessage(String message) {
        if (message != null && !message.equals(this.message)) {
            this.message = message;
            this.getStatuslineMessage().setMessage(this.message);
        }
    }

    public void warning(String message) {
        this.setImage(LnfManager.getLnf().getImage("statusline.warningIcon"));
        this.setMessage(message);
    }

    public void configureRidgets() {
    }

    public String getID() {
        if (this.getUIControl() != null) {
            SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
            return locator.locateBindingProperty((Object)this.getUIControl());
        }
        return null;
    }

    protected Image getManagedImage(String key) {
        Image image = ImageUtil.getImage((String)key);
        if (image == null) {
            image = this.getMissingImage();
        }
        return image;
    }

    public final synchronized Image getMissingImage() {
        if (missingImage == null) {
            missingImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return missingImage;
    }

    private void updateUIIcon() {
        Statusline control = this.getUIControl();
        if (control != null) {
            Image imageToSet = null;
            imageToSet = this.icon != null ? this.getManagedImage(this.icon) : this.image;
            this.getStatuslineMessage().setImage(imageToSet);
        }
    }
}

