/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.navigation.Activator;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationContext;
import org.eclipse.riena.navigation.INavigationHistory;
import org.eclipse.riena.navigation.INavigationHistoryListener;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeProvider;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.NavigationHistoryEvent;
import org.eclipse.riena.navigation.model.NavigationNodeProviderAccessor;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationProcessor
implements INavigationProcessor,
INavigationHistory {
    private static final Logger LOGGER = Activator.getDefault().getLogger(NavigationProcessor.class);
    private static int maxStacksize = 20;
    private Stack<INavigationNode<?>> histBack = new Stack();
    private Stack<INavigationNode<?>> histForward = new Stack();
    private Map<INavigationNode<?>, INavigationNode<?>> navigationMap = new HashMap();
    private List<INavigationHistoryListener> navigationListener = new Vector<INavigationHistoryListener>();

    @Override
    public void activate(INavigationNode<?> toActivate) {
        if (toActivate != null) {
            if (toActivate.isActivated()) {
                this.buildHistory(toActivate);
            } else {
                List<INavigationNode<?>> toDeactivateList;
                if (!toActivate.isVisible() || !toActivate.isEnabled()) {
                    return;
                }
                List<INavigationNode<?>> toActivateList = this.getNodesToActivateOnActivation(toActivate);
                NavigationContext navigationContext = new NavigationContext(toActivateList, toDeactivateList = this.getNodesToDeactivateOnActivation(toActivate));
                if (this.allowsDeactivate(navigationContext) && this.allowsActivate(navigationContext)) {
                    this.deactivate(navigationContext);
                    this.buildHistory(toActivate);
                    this.activate(navigationContext);
                }
            }
        }
    }

    private void buildHistory(INavigationNode<?> toActivate) {
        if (!(toActivate instanceof ISubModuleNode) || toActivate.isDisposed()) {
            return;
        }
        if (this.histBack.isEmpty() || !this.histBack.peek().equals(toActivate)) {
            this.histBack.push(toActivate);
            if (this.histBack.size() > maxStacksize) {
                this.histBack.remove(this.histBack.firstElement());
            }
            this.fireBackHistoryChangedEvent();
        }
        if (!this.histForward.isEmpty() && this.histForward.peek().equals(toActivate)) {
            this.histForward.pop();
            this.fireForewardHistoryChangedEvent();
        }
    }

    @Override
    public void dispose(INavigationNode<?> toDispose) {
        INavigationNode<?> nodeToDispose = this.getNodeToDispose(toDispose);
        if (nodeToDispose != null && !nodeToDispose.isDisposed()) {
            List<INavigationNode<?>> toDeactivateList = this.getNodesToDeactivateOnDispose(nodeToDispose);
            List<INavigationNode<?>> toActivateList = this.getNodesToActivateOnDispose(nodeToDispose);
            NavigationContext navigationContext = new NavigationContext(toActivateList, toDeactivateList);
            if (this.allowsDeactivate(navigationContext) && this.allowsDispose(navigationContext) && this.allowsActivate(navigationContext)) {
                this.deactivate(navigationContext);
                this.dispose(navigationContext);
                this.activate(navigationContext);
            }
            this.cleanupHistory(nodeToDispose);
        }
    }

    @Override
    public void addMarker(INavigationNode<?> node, IMarker marker) {
        if (node != null) {
            INavigationNode<?> nodeToHide;
            if (node.isActivated() && (marker instanceof DisabledMarker || marker instanceof HiddenMarker) && (nodeToHide = this.getNodeToDispose(node)) != null) {
                List<INavigationNode<?>> toDeactivateList = this.getNodesToDeactivateOnDispose(nodeToHide);
                List<INavigationNode<?>> toActivateList = this.getNodesToActivateOnDispose(nodeToHide);
                NavigationContext navigationContext = new NavigationContext(toActivateList, toDeactivateList);
                if (this.allowsDeactivate(navigationContext) && this.allowsActivate(navigationContext)) {
                    this.deactivate(navigationContext);
                    this.activate(navigationContext);
                } else {
                    return;
                }
            }
            if (marker instanceof DisabledMarker || marker instanceof HiddenMarker) {
                node.setSelected(false);
            }
            LinkedList toMarkList = new LinkedList();
            toMarkList.add(node);
            LinkedList emptyList = new LinkedList();
            NavigationContext navigationContext = new NavigationContext(toMarkList, emptyList);
            this.addMarker(navigationContext, marker);
        }
    }

    private void addMarker(INavigationContext context, IMarker marker) {
        for (INavigationNode<?> node : context.getToActivate()) {
            node.addMarker(context, marker);
        }
    }

    private void cleanupHistory(INavigationNode<?> toDispose) {
        boolean bhc = false;
        while (this.histBack.contains(toDispose)) {
            this.histBack.remove(toDispose);
            bhc = true;
        }
        if (bhc) {
            this.fireBackHistoryChangedEvent();
        }
        boolean fhc = false;
        while (this.histForward.contains(toDispose)) {
            this.histForward.remove(toDispose);
            fhc = true;
        }
        if (fhc) {
            this.fireForewardHistoryChangedEvent();
        }
        if (this.navigationMap.containsKey(toDispose)) {
            this.navigationMap.remove(toDispose);
        }
    }

    @Override
    public void create(INavigationNode<?> sourceNode, NavigationNodeId targetId) {
        this.provideNode(sourceNode, targetId, null);
    }

    @Override
    public void navigate(INavigationNode<?> sourceNode, NavigationNodeId targetId, NavigationArgument navigation) {
        this.navigateSync(sourceNode, targetId, navigation);
    }

    private void navigateSync(INavigationNode<?> sourceNode, NavigationNodeId targetId, NavigationArgument navigation) {
        INavigationNode<?> targetNode = this.provideNode(sourceNode, targetId, navigation);
        if (targetNode == null) {
            return;
        }
        INavigationNode<?> activateNode = targetNode.findNode(targetId);
        if (activateNode != null) {
            this.navigationMap.put(activateNode, sourceNode);
            activateNode.activate();
        } else {
            this.navigationMap.put(targetNode, sourceNode);
            targetNode.activate();
        }
    }

    private INavigationNode<?> provideNode(INavigationNode<?> sourceNode, NavigationNodeId targetId, NavigationArgument argument) {
        return this.getNavigationNodeProvider().provideNode(sourceNode, targetId, argument);
    }

    protected INavigationNodeProvider getNavigationNodeProvider() {
        return NavigationNodeProviderAccessor.current().getNavigationNodeProvider();
    }

    private INavigationNode<?> getNodeToDispose(INavigationNode<?> toDispose) {
        int ind;
        INavigationNode<ISubModuleNode> parent;
        IModuleNode moduleNode = toDispose.getTypecastedAdapter(IModuleNode.class);
        if (moduleNode != null && (parent = moduleNode.getParent()) != null && (ind = parent.getIndexOfChild(moduleNode)) == 0) {
            return parent;
        }
        return toDispose;
    }

    private List<INavigationNode<?>> getNodesToDeactivateOnDispose(INavigationNode<?> toDispose) {
        LinkedList allToDispose = new LinkedList();
        this.addAllChildren(allToDispose, toDispose);
        return allToDispose;
    }

    private void addAllChildren(List<INavigationNode<?>> allToDispose, INavigationNode<?> toDispose) {
        for (Object nextChild : toDispose.getChildren()) {
            this.addAllChildren(allToDispose, (INavigationNode)nextChild);
        }
        allToDispose.add(toDispose);
    }

    private List<INavigationNode<?>> getNodesToActivateOnDispose(INavigationNode<?> toDispose) {
        if (toDispose.isActivated()) {
            INavigationNode<?> parentOfToDispose = toDispose.getParent();
            INavigationNode<?> brotherToActivate = null;
            if (parentOfToDispose != null) {
                List<?> childrenOfParentOfToDispose = parentOfToDispose.getChildren();
                List<INavigationNode<?>> activateableNode = this.getActivateableNodes(childrenOfParentOfToDispose);
                if (childrenOfParentOfToDispose.size() > 1) {
                    for (INavigationNode<?> nextChild : activateableNode) {
                        if (nextChild.equals(toDispose)) continue;
                        brotherToActivate = nextChild;
                        break;
                    }
                }
            }
            if (brotherToActivate != null) {
                return this.getNodesToActivateOnActivation(brotherToActivate);
            }
        }
        return new LinkedList();
    }

    private List<INavigationNode<?>> getActivateableNodes(List<?> nodes) {
        LinkedList activateableNodes = new LinkedList();
        for (Object node : nodes) {
            INavigationNode naviNode;
            if (!(node instanceof INavigationNode) || !(naviNode = (INavigationNode)node).isVisible() || !naviNode.isEnabled()) continue;
            activateableNodes.add(naviNode);
        }
        return activateableNodes;
    }

    private List<INavigationNode<?>> getNodesToActivateOnActivation(INavigationNode<?> toActivate) {
        LinkedList nodesToActivate = new LinkedList();
        this.addParentsToActivate(nodesToActivate, toActivate);
        this.addChildrenToActivate(nodesToActivate, toActivate);
        return nodesToActivate;
    }

    private void addParentsToActivate(List<INavigationNode<?>> nodesToActivate, INavigationNode<?> toActivate) {
        INavigationNode<?> parent = this.getActivationParent(toActivate);
        if (parent != null) {
            if (parent.isActivated()) {
                nodesToActivate.add(toActivate);
            } else {
                this.addParentsToActivate(nodesToActivate, parent);
                nodesToActivate.add(toActivate);
            }
        } else {
            nodesToActivate.add(toActivate);
        }
    }

    private INavigationNode<?> getActivationParent(INavigationNode<?> child) {
        ISubModuleNode subModuleNode = child.getTypecastedAdapter(ISubModuleNode.class);
        if (subModuleNode != null) {
            INavigationNode<?> parent = child.getParent();
            while (parent != null) {
                if (parent.getTypecastedAdapter(IModuleNode.class) != null) {
                    return parent;
                }
                parent = parent.getParent();
            }
        } else {
            return child.getParent();
        }
        return null;
    }

    private void addChildrenToActivate(List<INavigationNode<?>> nodesToActivate, INavigationNode<?> toActivate) {
        INavigationNode<?> childToActivate = this.getChildToActivate(toActivate);
        if (childToActivate != null) {
            nodesToActivate.add(childToActivate);
            this.addChildrenToActivate(nodesToActivate, childToActivate);
        }
    }

    private List<INavigationNode<?>> getNodesToDeactivateOnActivation(INavigationNode<?> toActivate) {
        LinkedList nodesToDeactivate = new LinkedList();
        INavigationNode<?> activeParent = this.getNextActiveParent(toActivate);
        if (activeParent != null) {
            INavigationNode<?> activeChild = this.getActiveChild(activeParent);
            if (activeChild != null) {
                this.addChildrenToDeactivate(nodesToDeactivate, activeChild);
            }
        } else {
            this.addChildrenToDeactivate(nodesToDeactivate, this.getTopParent(toActivate));
        }
        return nodesToDeactivate;
    }

    private void addChildrenToDeactivate(List<INavigationNode<?>> nodesToDeactivate, INavigationNode<?> toAdd) {
        INavigationNode<?> activeChild = this.getActiveChild(toAdd);
        if (activeChild != null) {
            this.addChildrenToDeactivate(nodesToDeactivate, activeChild);
            nodesToDeactivate.add(toAdd);
        } else {
            nodesToDeactivate.add(toAdd);
        }
    }

    private INavigationNode<?> getNextActiveParent(INavigationNode<?> node) {
        ISubModuleNode subModuleNode = node.getTypecastedAdapter(ISubModuleNode.class);
        if (subModuleNode != null) {
            return this.getNextActiveParent(subModuleNode.getParent());
        }
        if (node.isActivated()) {
            return node;
        }
        if (node.getParent() != null) {
            return this.getNextActiveParent(node.getParent());
        }
        return null;
    }

    private INavigationNode<?> getTopParent(INavigationNode<?> node) {
        if (node.getParent() != null) {
            return this.getTopParent(node.getParent());
        }
        return node;
    }

    private boolean allowsActivate(INavigationContext context) {
        for (INavigationNode<?> nextToActivate : context.getToActivate()) {
            if (nextToActivate.allowsActivate(context)) continue;
            return false;
        }
        return true;
    }

    private boolean allowsDispose(INavigationContext context) {
        for (INavigationNode<?> nextToDeactivate : context.getToDeactivate()) {
            if (nextToDeactivate.allowsDispose(context)) continue;
            return false;
        }
        return true;
    }

    private boolean allowsDeactivate(INavigationContext context) {
        for (INavigationNode<?> nextToDeactivate : context.getToDeactivate()) {
            if (nextToDeactivate.allowsDeactivate(context)) continue;
            return false;
        }
        return true;
    }

    private void activate(INavigationContext context) {
        for (INavigationNode<?> nextToActivate : context.getToActivate()) {
            nextToActivate.onBeforeActivate(context);
        }
        for (INavigationNode<?> nextToActivate : context.getToActivate()) {
            nextToActivate.activate(context);
            this.setAsSelectedChild(nextToActivate);
        }
        for (INavigationNode<?> nextToActivate : this.copyReverse(context.getToActivate())) {
            nextToActivate.onAfterActivate(context);
        }
    }

    private void deactivate(INavigationContext context) {
        ArrayList previouslyActivatedNodes = new ArrayList();
        for (INavigationNode<?> nextToDeactivate : this.copyReverse(context.getToDeactivate())) {
            if (!nextToDeactivate.isActivated()) continue;
            previouslyActivatedNodes.add(nextToDeactivate);
            nextToDeactivate.onBeforeDeactivate(context);
        }
        for (INavigationNode<?> nextToDeactivate : context.getToDeactivate()) {
            if (!previouslyActivatedNodes.contains(nextToDeactivate)) continue;
            nextToDeactivate.deactivate(context);
        }
        for (INavigationNode<?> nextToDeactivate : context.getToDeactivate()) {
            if (!previouslyActivatedNodes.contains(nextToDeactivate)) continue;
            nextToDeactivate.onAfterDeactivate(context);
        }
    }

    private void dispose(INavigationContext context) {
        for (INavigationNode<?> nextToDispose : this.copyReverse(context.getToDeactivate())) {
            nextToDispose.onBeforeDispose(context);
        }
        for (INavigationNode<?> nextToDispose : context.getToDeactivate()) {
            nextToDispose.dispose(context);
            INavigationNode<?> parent = nextToDispose.getParent();
            if (parent == null) continue;
            parent.removeChild(nextToDispose);
        }
        for (INavigationNode<?> nextToDispose : context.getToDeactivate()) {
            nextToDispose.onAfterDispose(context);
            this.cleanupHistory(nextToDispose);
        }
    }

    private INavigationNode<?> getChildToActivate(INavigationNode<?> pNode) {
        ISubModuleNode subModuleNode = pNode.getTypecastedAdapter(ISubModuleNode.class);
        if (subModuleNode != null) {
            return null;
        }
        IModuleNode moduleNode = pNode.getTypecastedAdapter(IModuleNode.class);
        if (moduleNode != null) {
            ISubModuleNode nextChild = this.getSelectedChild(moduleNode);
            if (nextChild != null) {
                ISubModuleNode nextTmp;
                while ((nextTmp = this.getSelectedChild(nextChild)) != null) {
                    nextChild = nextTmp;
                }
                return nextChild;
            }
            if (moduleNode.getChildren().size() > 0) {
                return moduleNode.getChild(0);
            }
            return null;
        }
        INavigationNode<?> nextSelectedChild = this.getSelectedChild(pNode);
        if (nextSelectedChild != null) {
            return nextSelectedChild;
        }
        for (INavigationNode next : pNode.getChildren()) {
            if (!next.isVisible() || !next.isEnabled()) continue;
            return next;
        }
        return null;
    }

    private INavigationNode<?> getActiveChild(INavigationNode<?> pNode) {
        INavigationNode<?> nextSelectedChild;
        ISubModuleNode subModuleNode = pNode.getTypecastedAdapter(ISubModuleNode.class);
        if (subModuleNode != null) {
            return null;
        }
        IModuleNode moduleNode = pNode.getTypecastedAdapter(IModuleNode.class);
        if (moduleNode != null) {
            ISubModuleNode nextChild = this.getSelectedChild(moduleNode);
            if (nextChild != null) {
                while (nextChild != null) {
                    if (nextChild.isActivated()) {
                        return nextChild;
                    }
                    if (this.getSelectedChild(nextChild) != null) {
                        nextChild = this.getSelectedChild(nextChild);
                        continue;
                    }
                    return null;
                }
            } else {
                return null;
            }
        }
        if ((nextSelectedChild = this.getSelectedChild(pNode)) != null && nextSelectedChild.isActivated()) {
            return nextSelectedChild;
        }
        return null;
    }

    private void setAsSelectedChild(INavigationNode<?> pNode) {
        ISubModuleNode subModuleNode = pNode.getTypecastedAdapter(ISubModuleNode.class);
        if (subModuleNode != null) {
            ISubModuleNode nextToSet = subModuleNode;
            while (nextToSet != null) {
                if (nextToSet.getParent() == null) continue;
                this.setSelectedChild(nextToSet.getParent(), nextToSet);
                nextToSet = nextToSet.getParent().getTypecastedAdapter(ISubModuleNode.class);
            }
            this.setSelectedChild(subModuleNode, null);
            return;
        }
        if (pNode.getParent() != null) {
            this.setSelectedChild(pNode.getParent(), pNode);
        }
    }

    private void setSelectedChild(INavigationNode<?> parent, INavigationNode<?> child) {
        for (INavigationNode next : parent.getChildren()) {
            if (next.equals(child)) {
                next.setSelected(true);
                continue;
            }
            next.setSelected(false);
        }
    }

    private INavigationNode<?> getSelectedChild(INavigationNode<?> pNavigationNode) {
        for (INavigationNode next : pNavigationNode.getChildren()) {
            if (!next.isSelected()) continue;
            return next;
        }
        return null;
    }

    private ISubModuleNode getSelectedChild(IModuleNode pModuleNode) {
        for (ISubModuleNode next : pModuleNode.getChildren()) {
            if (!next.isSelected()) continue;
            return next;
        }
        return null;
    }

    private ISubModuleNode getSelectedChild(ISubModuleNode pSubModuleNode) {
        for (ISubModuleNode next : pSubModuleNode.getChildren()) {
            if (!next.isSelected()) continue;
            return next;
        }
        return null;
    }

    private List<INavigationNode<?>> copyReverse(List<INavigationNode<?>> list) {
        List<INavigationNode<?>> listReverse = list.subList(0, list.size());
        Collections.reverse(listReverse);
        return listReverse;
    }

    @Override
    public void historyBack() {
        if (this.getHistoryBackSize() > 0) {
            INavigationNode<?> current = this.histBack.pop();
            this.fireBackHistoryChangedEvent();
            this.histForward.push(current);
            if (this.histForward.size() > maxStacksize) {
                this.histForward.remove(this.histForward.firstElement());
            }
            this.fireForewardHistoryChangedEvent();
            INavigationNode<?> node = this.histBack.peek();
            if (node != null) {
                this.activate(node);
            }
        }
    }

    private void fireBackHistoryChangedEvent() {
        if (this.navigationListener.size() == 0) {
            return;
        }
        NavigationHistoryEvent event = new NavigationHistoryEvent(this.histBack.subList(0, this.histBack.size() - 1));
        for (INavigationHistoryListener listener : this.navigationListener) {
            listener.backHistoryChanged(event);
        }
    }

    @Override
    public void historyForward() {
        if (this.getHistoryForwardSize() > 0) {
            INavigationNode<?> current = this.histForward.pop();
            this.fireForewardHistoryChangedEvent();
            if (current != null) {
                this.histBack.push(current);
                if (this.histBack.size() > maxStacksize) {
                    this.histBack.remove(this.histBack.firstElement());
                }
                this.activate(current);
                this.fireBackHistoryChangedEvent();
            }
        }
    }

    private void fireForewardHistoryChangedEvent() {
        if (this.navigationListener.size() == 0) {
            return;
        }
        NavigationHistoryEvent event = new NavigationHistoryEvent(this.histBack.subList(0, this.histForward.size()));
        for (INavigationHistoryListener listener : this.navigationListener) {
            listener.backHistoryChanged(event);
        }
    }

    @Override
    public int getHistoryBackSize() {
        return this.histBack.size() - 1;
    }

    @Override
    public int getHistoryForwardSize() {
        return this.histForward.size();
    }

    @Override
    public void navigateBack(INavigationNode<?> targetNode) {
        INavigationNode<?> sourceNode = null;
        INavigationNode<?> lookupNode = targetNode;
        while (sourceNode == null) {
            sourceNode = this.navigationMap.get(lookupNode);
            if (sourceNode != null || (lookupNode = lookupNode.getParent()) != null) continue;
            return;
        }
        this.navigate(targetNode, sourceNode.getNodeId(), null);
    }

    @Override
    public synchronized void addNavigationHistoryListener(INavigationHistoryListener listener) {
        if (!this.navigationListener.contains(listener)) {
            this.navigationListener.add(listener);
        }
    }

    @Override
    public synchronized void removeNavigationHistoryListener(INavigationHistoryListener listener) {
        this.navigationListener.remove(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NavigationContext
    implements INavigationContext {
        private List<INavigationNode<?>> toDeactivate;
        private List<INavigationNode<?>> toActivate;

        public NavigationContext(List<INavigationNode<?>> toActivate, List<INavigationNode<?>> toDeactivate) {
            this.toDeactivate = toDeactivate;
            this.toActivate = toActivate;
        }

        @Override
        public List<INavigationNode<?>> getToActivate() {
            return this.toActivate;
        }

        @Override
        public List<INavigationNode<?>> getToDeactivate() {
            return this.toDeactivate;
        }
    }
}

