/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.riena.internal.navigation.ui.swt.utils.RcpUtilities;
import org.eclipse.riena.navigation.ui.swt.views.AbstractControlledView;
import org.eclipse.riena.ui.ridgets.controller.AbstractWindowController;
import org.eclipse.riena.ui.swt.RienaDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DialogView
extends AbstractControlledView<AbstractWindowController> {
    private Composite parent;
    protected Dialog dialog;

    public DialogView(Composite parent) {
        this.initializeParent(parent);
    }

    protected ControlledRienaDialog createDialog() {
        return new ControlledRienaDialog(this.getParentShell());
    }

    protected void createAndBindController() {
        AbstractWindowController controller = this.createController();
        this.initialize(controller);
        this.bind(controller);
    }

    protected Control buildView(Composite parent) {
        this.addUIControl(this.dialog.getShell(), "windowRidget");
        return parent;
    }

    protected abstract AbstractWindowController createController();

    public void build() {
        if (this.dialog == null) {
            this.dialog = this.createDialog();
        }
        this.dialog.open();
    }

    private void initializeParent(Composite parent) {
        this.parent = parent == null ? RcpUtilities.getWorkbenchShell() : parent;
    }

    private Shell getParentShell() {
        if (this.parent != null) {
            return this.parent.getShell();
        }
        return null;
    }

    protected void onClose() {
    }

    private class ControlledRienaDialog
    extends RienaDialog {
        private boolean closing;

        private ControlledRienaDialog(Shell shell) {
            super(shell);
            this.closing = false;
        }

        public boolean close() {
            this.closing = true;
            DialogView.this.onClose();
            DialogView.this.unbind((AbstractWindowController)DialogView.this.getController());
            boolean result = super.close();
            this.closing = false;
            return result;
        }

        public void create() {
            super.create();
            DialogView.this.createAndBindController();
            this.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (!ControlledRienaDialog.this.closing) {
                        ControlledRienaDialog.this.close();
                    }
                }
            });
            this.getShell().pack();
        }

        protected Control createDialogArea(Composite parent) {
            return DialogView.this.buildView(parent);
        }
    }
}

