/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ShellBorderRenderer;
import org.eclipse.riena.navigation.ui.swt.views.GrabCornerListenerWithTracker;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class GrabCorner
extends Composite {
    public GrabCorner(Shell shell, int style) {
        super((Composite)shell, style);
        this.setBackground(LnfManager.getLnf().getColor("grabCorner.background"));
        this.setData("sizeexecutor", "grabcorner");
        this.setLayoutData();
        this.addPaintListener(new GrabPaintListener());
        new GrabCornerListenerWithTracker(this);
    }

    private void setLayoutData() {
        Point grabCornerSize = GrabCorner.getGrabCornerSize();
        int borderWidth = GrabCorner.getShellBorderWidth();
        FormData grabFormData = new FormData();
        grabFormData.width = grabCornerSize.y;
        grabFormData.height = grabCornerSize.x;
        grabFormData.bottom = new FormAttachment(100, -borderWidth);
        grabFormData.right = new FormAttachment(100, -borderWidth);
        this.setLayoutData(grabFormData);
    }

    public static Point getGrabCornerSize() {
        Point grabCornerSize = new Point(GrabCorner.getShellBorderWidth(), GrabCorner.getShellBorderWidth());
        Image grabCorner = GrabCorner.getGrabCornerImage();
        if (grabCorner != null && GrabCorner.isResizeable()) {
            ImageData imageData = grabCorner.getImageData();
            int width = grabCornerSize.x + imageData.width;
            int height = grabCornerSize.y + imageData.height;
            grabCornerSize = new Point(width, height);
        }
        return grabCornerSize;
    }

    public static boolean isResizeable() {
        return LnfManager.getLnf().getBooleanSetting("TitlelessShell.resizeable");
    }

    private static Image getGrabCornerImage() {
        return LnfManager.getLnf().getImage("TitlelessShell.grabCornerImage");
    }

    private static int getShellBorderWidth() {
        ShellBorderRenderer borderRenderer = (ShellBorderRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.borderRenderer");
        if (borderRenderer != null) {
            return borderRenderer.getBorderWidth();
        }
        return 0;
    }

    private static class GrabPaintListener
    implements PaintListener {
        private GrabPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            Image grabCornerImage = GrabCorner.getGrabCornerImage();
            gc.drawImage(grabCornerImage, 0, 0);
        }
    }
}

