/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.NavigationNode;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITreeRidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTModuleController
extends ModuleController {
    private ITreeRidget tree;
    private static final String PROPERTY_ENABLED = "enabled";
    private static final String PROPERTY_VISIBLE = "visible";

    public SWTModuleController(IModuleNode navigationNode) {
        super(navigationNode);
        this.addListeners();
    }

    private void addListeners() {
        NavigationTreeObserver navigationTreeObserver = new NavigationTreeObserver();
        navigationTreeObserver.addListener((ISubModuleNodeListener)new SubModuleListener());
        navigationTreeObserver.addListenerTo((IModuleNode)this.getNavigationNode());
    }

    public void setTree(ITreeRidget tree) {
        this.tree = tree;
    }

    public ITreeRidget getTree() {
        return this.tree;
    }

    public void afterBind() {
        super.afterBind();
        this.updateNavigationNodeMarkers();
        this.bindTree();
    }

    private void bindTree() {
        this.tree.setRootsVisible(false);
        Object[] roots = this.createTreeRootNodes();
        this.tree.bindToModel(roots, NavigationNode.class, "children", "parent", "label", PROPERTY_ENABLED, PROPERTY_VISIBLE);
        this.tree.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        this.tree.bindSingleSelectionToModel((IObservableValue)new DelegatingValue());
        this.selectActiveNode();
    }

    private void setSelectedNode(INavigationNode<?> node) {
        if (node.isActivated() && node != this.getNavigationNode()) {
            this.tree.setSelection(node);
        }
        for (INavigationNode child : node.getChildren()) {
            this.setSelectedNode(child);
        }
    }

    private void selectActiveNode() {
        this.setSelectedNode(this.getNavigationNode());
    }

    private IModuleNode[] createTreeRootNodes() {
        IModuleNode moduleNode = (IModuleNode)this.getNavigationNode();
        return new IModuleNode[]{moduleNode};
    }

    private static class DelegatingValue
    extends WritableValue {
        private DelegatingValue() {
        }

        public void doSetValue(Object value) {
            ISubModuleNode node = (ISubModuleNode)value;
            node.activate();
        }
    }

    private class SubModuleListener
    extends SubModuleNodeListener {
        private SubModuleListener() {
        }

        public void activated(ISubModuleNode source) {
            super.activated((INavigationNode)source);
            SWTModuleController.this.selectActiveNode();
        }
    }
}

