/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.util.InvocationTargetFailure;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ControllerUtils;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProviderAccessor;
import org.eclipse.riena.navigation.ui.swt.views.IComponentUpdateListener;
import org.eclipse.riena.navigation.ui.swt.views.INavigationNodeView;
import org.eclipse.riena.navigation.ui.swt.views.SWTModuleController;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.swt.uibinding.AbstractViewBindingDelegate;
import org.eclipse.riena.ui.ridgets.swt.uibinding.DefaultSwtBindingDelegate;
import org.eclipse.riena.ui.swt.EmbeddedTitleBar;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.workarea.IWorkareaDefinition;
import org.eclipse.riena.ui.workarea.WorkareaManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SubModuleView<C extends SubModuleController>
extends ViewPart
implements INavigationNodeView<SWTModuleController, SubModuleNode> {
    private static final Logger LOGGER = Activator.getDefault().getLogger(SubModuleView.class.getName());
    private AbstractViewBindingDelegate binding = this.createBinding();
    private SubModuleController currentController;
    private SubModuleNode rcpSubModuleNode;
    private EmbeddedTitleBar title;
    private Composite parentComposite;
    private Composite contentComposite;
    private Cursor cursorWait;
    private Cursor cursorArrow;

    protected AbstractViewBindingDelegate createBinding() {
        return new DefaultSwtBindingDelegate();
    }

    protected void addUIControl(Object uiControl) {
        this.binding.addUIControl(uiControl);
    }

    protected void addUIControl(Object uiControl, String propertyName) {
        this.binding.addUIControl(uiControl, propertyName);
    }

    protected ISubModuleNode getSubModuleNode(String pId, String pSecondary) {
        return SwtViewProviderAccessor.getViewProvider().getNavigationNode(pId, pSecondary, ISubModuleNode.class);
    }

    public SubModuleController getController() {
        if (this.getNavigationNode() != null && this.getNavigationNode().getNavigationNodeController() instanceof SubModuleController) {
            return (SubModuleController)this.getNavigationNode().getNavigationNodeController();
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        this.parentComposite = parent;
        this.observeRoot();
        C controller = this.createController((ISubModuleNode)this.getNavigationNode());
        if (controller != null) {
            this.setPartName(((ISubModuleNode)controller.getNavigationNode()).getLabel());
        }
        this.contentComposite = this.createContentComposite(parent);
        this.basicCreatePartControl(this.contentComposite);
        this.createViewFacade();
        this.doBinding();
    }

    protected Composite getParentComposite() {
        return this.parentComposite;
    }

    protected Composite getContentComposite() {
        return this.contentComposite;
    }

    private Composite createContentComposite(Composite parent) {
        Color bgColor = LnfManager.getLnf().getColor("SubModule.background");
        parent.setBackground(bgColor);
        parent.setLayout((Layout)new FormLayout());
        if (!this.isRCP()) {
            this.title = new EmbeddedTitleBar(parent, 0);
            this.addUIControl(this.title, "windowRidget");
            this.title.setWindowActive(true);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, -1);
            formData.left = new FormAttachment(0, -1);
            formData.bottom = new FormAttachment(0, this.title.getSize().y - 1);
            formData.right = new FormAttachment(100, 2);
            this.title.setLayoutData((Object)formData);
        }
        Composite composite = new Composite(parent, 0x20000000);
        composite.setBackground(bgColor);
        FormData formData = new FormData();
        formData.top = this.title != null ? new FormAttachment((Control)this.title, 0, 0) : new FormAttachment(0, -1);
        formData.left = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100);
        formData.right = new FormAttachment(100);
        composite.setLayoutData((Object)formData);
        this.cursorWait = this.createWaitCursor();
        this.cursorArrow = this.createArrowCursor();
        return composite;
    }

    protected Cursor createArrowCursor() {
        return this.getSite().getShell().getDisplay().getSystemCursor(0);
    }

    protected Cursor createWaitCursor() {
        return this.getSite().getShell().getDisplay().getSystemCursor(1);
    }

    private void observeRoot() {
        SubModuleNode node = this.getNavigationNode();
        while (node.getParent() != null) {
            node = node.getParent();
        }
        NavigationTreeObserver navigationTreeObserver = new NavigationTreeObserver();
        navigationTreeObserver.addListener((ISubModuleNodeListener)new SubModuleNodesListener());
        IApplicationNode appNode = (IApplicationNode)node.getTypecastedAdapter(IApplicationNode.class);
        if (appNode != null) {
            navigationTreeObserver.addListenerTo(appNode);
        }
    }

    protected void blockView(boolean block) {
        this.parentComposite.setCursor(block ? this.cursorWait : this.cursorArrow);
        this.contentComposite.setEnabled(!block);
    }

    protected abstract void basicCreatePartControl(Composite var1);

    public void setFocus() {
    }

    protected void createViewFacade() {
        if (this.getController() == null) {
            this.createController((ISubModuleNode)this.getNavigationNode());
        }
        if (this.getController() != null) {
            this.binding.injectRidgets((IController)this.getController());
        }
    }

    protected C createController(ISubModuleNode node) {
        Assert.isNotNull((Object)node, (String)"navigation node must not be null");
        Assert.isNotNull((Object)node.getNodeId(), (String)"navigation node id must not be null");
        Assert.isNotNull((Object)node.getNodeId().getTypeId(), (String)"navigation node type id must not be null");
        SubModuleController controller = null;
        IWorkareaDefinition def = WorkareaManager.getInstance().getDefinition((Object)node.getNodeId().getTypeId());
        if (def != null) {
            try {
                controller = (SubModuleController)def.createController();
            }
            catch (Exception ex) {
                String message = String.format("cannnot create controller for class %s", def.getControllerClass());
                LOGGER.log(1, message, (Throwable)ex);
                throw new InvocationTargetFailure(message, (Throwable)ex);
            }
        }
        if (controller != null) {
            controller.setNavigationNode(node);
        }
        return (C)controller;
    }

    private void doBinding() {
        this.bind(this.getNavigationNode());
    }

    @Override
    public void addUpdateListener(IComponentUpdateListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(SubModuleNode node) {
        if (this.currentController != this.getController()) {
            if (this.currentController != null) {
                if (((ISubModuleNode)this.currentController.getNavigationNode()).isDisposed()) {
                    return;
                }
                this.binding.unbind((IController)this.currentController);
            }
            if (this.getNavigationNode() != null && this.getController() == null) {
                this.createViewFacade();
            }
            if (this.getController() != null) {
                this.currentController = this.getController();
            }
            this.binding.bind((IController)this.currentController);
            this.currentController.afterBind();
            if (this.title != null) {
                this.title.setWindowActive(this.currentController.isActivated());
            }
        }
    }

    @Override
    public SubModuleNode getNavigationNode() {
        String secondaryId;
        String viewId = this.getViewSite().getId();
        SubModuleNode result = (SubModuleNode)this.getSubModuleNode(viewId, secondaryId = this.getViewSite().getSecondaryId());
        if (result == null) {
            result = this.getRCPSubModuleNode();
        }
        return result;
    }

    @Override
    public void unbind() {
        SubModuleController controller = this.getController();
        if (controller != null) {
            this.binding.unbind((IController)controller);
        }
    }

    private boolean isRCP() {
        this.getNavigationNode();
        return this.rcpSubModuleNode != null;
    }

    private SubModuleNode getRCPSubModuleNode() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.riena.navigation.assemblies");
        String viewId = this.getViewSite().getId();
        return this.getRCPSubModuleNode(viewId, elements);
    }

    private SubModuleNode getRCPSubModuleNode(String viewId, IConfigurationElement[] elements) {
        int i = 0;
        while (this.rcpSubModuleNode == null && i < elements.length) {
            IConfigurationElement element = elements[i];
            if ("submodule".equals(element.getName())) {
                String typeId;
                String view = element.getAttribute("view");
                if (viewId.equals(view) && (typeId = element.getAttribute("typeId")) != null) {
                    this.rcpSubModuleNode = new SubModuleNode(new NavigationNodeId(typeId), this.getPartName());
                }
            } else if (element.getChildren().length > 0) {
                this.rcpSubModuleNode = this.getRCPSubModuleNode(viewId, element.getChildren());
            }
            ++i;
        }
        return this.rcpSubModuleNode;
    }

    private final class SubModuleNodesListener
    extends SubModuleNodeListener {
        private SubModuleNodesListener() {
        }

        public void activated(ISubModuleNode source) {
            if (source.equals(SubModuleView.this.getNavigationNode())) {
                SubModuleView.this.doBinding();
            }
        }

        public void block(ISubModuleNode source, boolean block) {
            if (source.equals(SubModuleView.this.getNavigationNode())) {
                ControllerUtils.blockRidgets((Collection)SubModuleView.this.getController().getRidgets(), (boolean)block);
                SubModuleView.this.blockView(block);
            }
        }
    }
}

