/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.ControlEditTextSelectionRec;
import org.eclipse.swt.internal.carbon.ControlFontStyleRec;
import org.eclipse.swt.internal.carbon.HILayoutInfo;
import org.eclipse.swt.internal.carbon.HISideBinding;
import org.eclipse.swt.internal.carbon.HIThemeFrameDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.carbon.TXNTab;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    int txnObject;
    int frameHandle;
    int textLimit = LIMIT;
    int tabs = 8;
    ControlEditTextSelectionRec selection;
    char echoCharacter;
    boolean doubleClick;
    String hiddenText;
    String message;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\r";
    static final char PASSWORD = '\u2022';
    static final String[] AX_ATTRIBUTES = new String[]{"AXTitle", "AXValue", "AXNumberOfCharacters", "AXSelectedText", "AXSelectedTextRange", "AXStringForRange"};

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
        if ((style & 0x80) != 0) {
            int inAttributesToSet = (style & 0x100) != 0 ? 1 : 0;
            OS.HISearchFieldChangeAttributes(this.handle, inAttributesToSet, 0);
            if ((style & 0x100) != 0) {
                this.style |= 0x100;
            }
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        int charCount;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, charCount = this.getCharCount(), charCount, null)) == null) {
            return;
        }
        if (this.txnObject == 0) {
            this.setSelection(this.getCharCount());
            this.insertEditText(string);
        } else {
            this.setTXNText(Integer.MAX_VALUE, Integer.MAX_VALUE, string);
            OS.TXNSetSelection(this.txnObject, Integer.MAX_VALUE, Integer.MAX_VALUE);
            OS.TXNShowSelection(this.txnObject, false);
        }
        if (string.length() != 0) {
            this.sendModifyEvent(true);
        }
    }

    static int checkStyle(int style) {
        if ((style & 0x80) != 0) {
            style |= 0x804;
            style &= 0xFFBFFFFF;
        }
        if ((style & 4) != 0 && (style & 2) != 0) {
            style &= 0xFFFFFFFD;
        }
        if (((style = Text.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            style &= 0xFFFFFCBF;
        }
        if ((style & 0x40) != 0) {
            style |= 2;
            style &= 0xFFFFFEFF;
        }
        if ((style & 2) != 0) {
            style &= 0xFFBFFFFF;
        }
        if ((style & 6) != 0) {
            return style;
        }
        if ((style & 0x300) != 0) {
            return style | 2;
        }
        return style | 4;
    }

    int callPaintEventHandler(int control, int damageRgn, int visibleRgn, int theEvent, int nextHandler) {
        int result = super.callPaintEventHandler(control, damageRgn, visibleRgn, theEvent, nextHandler);
        if (this.frameHandle == control) {
            int[] context = new int[1];
            OS.GetEventParameter(theEvent, 1668183160, 1668183160, null, 4, null, context);
            OS.CGContextSaveGState(context[0]);
            int[] outMetric = new int[1];
            OS.GetThemeMetric(7, outMetric);
            CGRect rect = new CGRect();
            OS.HIViewGetBounds(this.frameHandle, rect);
            rect.x += (float)outMetric[0];
            rect.y += (float)outMetric[0];
            rect.width -= (float)(outMetric[0] * 2);
            rect.height -= (float)(outMetric[0] * 2);
            int state = OS.IsControlEnabled(control) ? (OS.IsControlActive(control) ? 1 : 0) : (OS.IsControlActive(control) ? 7 : 8);
            HIThemeFrameDrawInfo info = new HIThemeFrameDrawInfo();
            info.state = state;
            info.isFocused = this.hasFocus();
            info.kind = 0;
            OS.HIThemeDrawFrame(rect, info, context[0], 0);
            if ((this.style & 0x300) == 768) {
                OS.HIViewGetBounds(this.frameHandle, rect);
                rect.x = rect.width - (float)outMetric[0];
                rect.y = rect.height - (float)outMetric[0];
                OS.GetThemeMetric(5, outMetric);
                rect.x -= (float)outMetric[0];
                rect.y -= (float)outMetric[0];
                OS.GetThemeMetric(0, outMetric);
                rect.x -= (float)outMetric[0];
                rect.y -= (float)outMetric[0];
                rect.width = rect.height = (float)outMetric[0];
                OS.CGContextSetFillColor(context[0], new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                OS.CGContextFillRect(context[0], rect);
            }
            OS.CGContextRestoreGState(context[0]);
        }
        return result;
    }

    int callFocusEventHandler(int nextHandler, int theEvent) {
        short[] part = new short[1];
        if (this.txnObject == 0) {
            OS.GetEventParameter(theEvent, 1668313716, 1668313716, null, 2, null, part);
            if (part[0] == 0) {
                this.selection = new ControlEditTextSelectionRec();
                OS.GetControlData(this.handle, (short)0, 1936026725, 4, this.selection, null);
            }
        }
        int result = super.callFocusEventHandler(nextHandler, theEvent);
        if (this.isDisposed()) {
            return result;
        }
        if (this.frameHandle != 0) {
            OS.HIViewSetNeedsDisplay(this.frameHandle, true);
        }
        if (this.txnObject == 0 && part[0] != 0 && this.selection != null) {
            OS.SetControlData(this.handle, 0, 1936026725, 4, this.selection);
            this.selection = null;
        }
        return result;
    }

    public void clearSelection() {
        this.checkWidget();
        if (this.txnObject == 0) {
            Point selection = this.getSelection();
            this.setSelection(selection.x);
        } else {
            int[] oStartOffset = new int[1];
            int[] oEndOffset = new int[1];
            OS.TXNGetSelection(this.txnObject, oStartOffset, oEndOffset);
            OS.TXNSetSelection(this.txnObject, oStartOffset[0], oStartOffset[0]);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (this.txnObject == 0) {
            if ((this.style & 0x80) != 0) {
                int[] ptr1 = new int[1];
                OS.GetControlData(this.handle, (short)0, 1667658612, 4, ptr1, null);
                Point size1 = this.textExtent(ptr1[0], 0);
                if (ptr1[0] != 0) {
                    OS.CFRelease(ptr1[0]);
                }
                width = size1.x;
                height = size1.y;
                int[] metric = new int[1];
                OS.GetThemeMetric(4, metric);
                height += metric[0] * 2;
                OS.GetThemeMetric(5, metric);
                height += metric[0] * 2;
            } else {
                if ((this.style & 0x20000) != 0) {
                    OS.SetControlData(this.handle, 0, 1936157795, 1, new byte[]{1});
                }
                Rect rect = new Rect();
                OS.GetBestControlRect(this.handle, rect, null);
                if ((this.style & 0x20000) != 0) {
                    OS.SetControlData(this.handle, 0, 1936157795, 1, new byte[1]);
                }
                width = rect.right - rect.left;
                height = rect.bottom - rect.top;
            }
        } else {
            int[] oDataHandle = new int[1];
            OS.TXNGetData(this.txnObject, 0, Integer.MAX_VALUE, oDataHandle);
            if (oDataHandle[0] != 0) {
                int length = OS.GetHandleSize(oDataHandle[0]);
                int str = 0;
                if (length != 0) {
                    int[] ptr = new int[1];
                    OS.HLock(oDataHandle[0]);
                    OS.memmove(ptr, oDataHandle[0], 4);
                    str = OS.CFStringCreateWithCharacters(0, ptr[0], length / 2);
                    OS.HUnlock(oDataHandle[0]);
                }
                OS.DisposeHandle(oDataHandle[0]);
                Point size = this.textExtent(str, wHint != -1 && (this.style & 0x40) != 0 ? wHint : 0);
                if (str != 0) {
                    OS.CFRelease(str);
                }
                width = size.x;
                height = size.y;
            }
        }
        if (width <= 0) {
            width = 64;
        }
        if (height <= 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        width = trim.width;
        height = trim.height;
        return new Point(width, height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int[] size = new int[1];
        OS.GetThemeMetric(0, size);
        if (this.horizontalBar != null) {
            height += size[0];
        }
        if (this.verticalBar != null) {
            width += size[0];
        }
        Rect inset = this.inset();
        x -= inset.left;
        y -= inset.top;
        width += inset.left + inset.right;
        height += inset.top + inset.bottom;
        if (this.txnObject == 0) {
            inset = this.getInset();
            x -= inset.left;
            y -= inset.top;
            width += inset.left + inset.right;
            height += inset.top + inset.bottom;
        }
        if ((this.style & 0x80) != 0) {
            int[] left = new int[1];
            int[] right = new int[1];
            int[] outAttributes = new int[1];
            OS.HISearchFieldGetAttributes(this.handle, outAttributes);
            if ((outAttributes[0] & 2) != 0) {
                OS.GetThemeMetric(this.display.smallFonts ? 123 : 109, left);
            } else {
                OS.GetThemeMetric(this.display.smallFonts ? 120 : 76, left);
            }
            if ((outAttributes[0] & 1) != 0) {
                OS.GetThemeMetric(this.display.smallFonts ? 124 : 110, right);
            } else {
                OS.GetThemeMetric(this.display.smallFonts ? 121 : 77, right);
            }
            width += left[0] + right[0];
        }
        return new Rectangle(x, y, width, height);
    }

    public void copy() {
        this.checkWidget();
        if (this.txnObject == 0) {
            Point selection = this.getSelection();
            if (selection.x == selection.y) {
                return;
            }
            this.copyToClipboard(this.getEditText(selection.x, selection.y - 1));
        } else {
            OS.TXNCopy(this.txnObject);
        }
    }

    void createHandle() {
        int[] outControl = new int[1];
        if ((this.style & 2) != 0 || (this.style & 0x880) == 0) {
            if ((this.style & 0x300) != 0 || OS.VERSION >= 4176) {
                int options = 0;
                if ((this.style & 0x300) == 768) {
                    options |= 4;
                }
                if ((this.style & 0x100) != 0) {
                    options |= 2;
                }
                if ((this.style & 0x200) != 0) {
                    options |= 1;
                }
                if (options == 0) {
                    options |= 1;
                }
                OS.HIScrollViewCreate(options, outControl);
                if (outControl[0] == 0) {
                    this.error(2);
                }
                this.scrolledHandle = outControl[0];
                OS.HIViewSetVisible(this.scrolledHandle, true);
            }
            int iFrameOptions = 135168;
            if ((this.style & 0x20000) == 0 && (this.style & 4) != 0) {
                iFrameOptions |= 0x4000;
            }
            if ((this.style & 0x40) != 0) {
                iFrameOptions |= 0x800;
            }
            OS.HITextViewCreate(null, 0, iFrameOptions, outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            OS.HIViewSetVisible(this.handle, true);
            if ((this.style & 2) != 0 && (this.style & 0x800) != 0) {
                int features = 2;
                OS.CreateUserPaneControl(0, null, features, outControl);
                if (outControl[0] == 0) {
                    this.error(2);
                }
                this.frameHandle = outControl[0];
            }
            this.txnObject = OS.HITextViewGetTXNObject(this.handle);
            int ptr = OS.NewPtr(8);
            Rect rect = (this.style & 4) != 0 ? this.inset() : new Rect();
            OS.memmove(ptr, rect, 8);
            int[] tags = new int[]{1685217639, 1716745570, 1768910966, 1835102823, 1786082164};
            int just = 1;
            if ((this.style & 0x1000000) != 0) {
                just = 4;
            }
            if ((this.style & 0x20000) != 0) {
                just = 2;
            }
            int[] datas = new int[]{1, 1, (this.style & 8) != 0 ? 1 : 0, ptr, just};
            OS.TXNSetTXNObjectControls(this.txnObject, false, tags.length, tags, datas);
            OS.DisposePtr(ptr);
        } else {
            if ((this.style & 0x80) != 0) {
                int attributes = (this.style & 0x100) != 0 ? 1 : 0;
                OS.HISearchFieldCreate(null, attributes, 0, 0, outControl);
            } else {
                int window = OS.GetControlOwner(this.parent.handle);
                OS.CreateEditUnicodeTextControl(window, null, 0, (this.style & 0x400000) != 0, null, outControl);
            }
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            if ((this.style & 0x80) != 0 && this.display.smallFonts) {
                OS.SetControlData(this.handle, 0, 1936292453, 2, new short[]{1});
            }
            if ((this.style & 0x20000) == 0) {
                OS.SetControlData(this.handle, 0, 1936157795, 1, new byte[]{1});
            }
            if ((this.style & 8) != 0) {
                OS.SetControlData(this.handle, 0, 1819239275, 1, new byte[]{1});
            }
            if ((this.style & 0x1020000) != 0) {
                ControlFontStyleRec fontStyle = new ControlFontStyleRec();
                fontStyle.flags = (short)(fontStyle.flags | 0x40);
                if ((this.style & 0x1000000) != 0) {
                    fontStyle.just = 1;
                }
                if ((this.style & 0x20000) != 0) {
                    fontStyle.just = (short)-1;
                }
                OS.SetControlFontStyle(this.handle, fontStyle);
            }
            if ((this.style & 0x80) != 0) {
                OS.HIViewSetVisible(this.handle, true);
            }
        }
    }

    ScrollBar createScrollBar(int style) {
        return this.createStandardBar(style);
    }

    void createWidget() {
        super.createWidget();
        this.doubleClick = true;
        if ((this.style & 0x400000) != 0) {
            this.setEchoChar('\u2022');
        }
        this.message = "";
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        boolean cut = true;
        char[] oldText = null;
        Point oldSelection = this.getSelection();
        if ((this.hooks(25) || this.filters(25)) && oldSelection.x != oldSelection.y) {
            oldText = this.getEditText(oldSelection.x, oldSelection.y - 1);
            String newText = this.verifyText("", oldSelection.x, oldSelection.y, null);
            if (newText == null) {
                return;
            }
            if (newText.length() != 0) {
                this.copyToClipboard(oldText);
                if (this.txnObject == 0) {
                    this.insertEditText(newText);
                } else {
                    this.setTXNText(-1, -1, newText);
                    OS.TXNShowSelection(this.txnObject, false);
                }
                cut = false;
            }
        }
        if (cut) {
            if (this.txnObject == 0) {
                if (oldText == null) {
                    oldText = this.getEditText(oldSelection.x, oldSelection.y - 1);
                }
                this.copyToClipboard(oldText);
                this.insertEditText("");
            } else {
                OS.TXNCut(this.txnObject);
                if (OS.TXNDataSize(this.txnObject) / 2 == 0) {
                    this.setFontStyle(this.font);
                }
            }
        }
        Point newSelection = this.getSelection();
        if (!cut || !oldSelection.equals(newSelection)) {
            this.sendModifyEvent(true);
        }
    }

    Color defaultBackground() {
        return this.display.getSystemColor(25);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(24);
    }

    void deregister() {
        super.deregister();
        if (this.frameHandle != 0) {
            this.display.removeWidget(this.frameHandle);
        }
    }

    boolean dragDetect(int x, int y, boolean filter, boolean[] consume) {
        if (filter) {
            int position;
            Point selection = this.getSelection();
            if (selection.x != selection.y && selection.x <= (position = this.getPosition(x, y)) && position < selection.y && super.dragDetect(x, y, filter, consume)) {
                if (consume != null) {
                    consume[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(x, y, filter, consume);
    }

    int focusPart() {
        if ((this.style & 0x80) != 0) {
            return 5;
        }
        return super.focusPart();
    }

    String[] getAxAttributes() {
        return AX_ATTRIBUTES;
    }

    public int getBorderWidth() {
        this.checkWidget();
        if (this.hasBorder()) {
            int[] outMetric = new int[1];
            OS.GetThemeMetric(5, outMetric);
            return outMetric[0];
        }
        return 0;
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return (this.getTopPixel() + this.getCaretLocation().y) / this.getLineHeight();
    }

    public Point getCaretLocation() {
        this.checkWidget();
        if (this.txnObject == 0) {
            return new Point(0, 0);
        }
        CGPoint oPoint = new CGPoint();
        int[] oStartOffset = new int[1];
        int[] oEndOffset = new int[1];
        OS.TXNGetSelection(this.txnObject, oStartOffset, oEndOffset);
        OS.TXNOffsetToHIPoint(this.txnObject, oStartOffset[0], oPoint);
        Rect oViewRect = new Rect();
        OS.TXNGetViewRect(this.txnObject, oViewRect);
        return new Point((int)oPoint.x - oViewRect.left, (int)oPoint.y - oViewRect.top);
    }

    public int getCaretPosition() {
        this.checkWidget();
        if (this.txnObject == 0) {
            return this.getSelection().x;
        }
        int[] oStartOffset = new int[1];
        int[] oEndOffset = new int[1];
        OS.TXNGetSelection(this.txnObject, oStartOffset, oEndOffset);
        return oStartOffset[0];
    }

    public int getCharCount() {
        this.checkWidget();
        if (this.txnObject == 0) {
            int[] ptr = new int[1];
            int result = OS.GetControlData(this.handle, (short)0, 1667658612, 4, ptr, null);
            if (result != 0) {
                return 0;
            }
            int length = OS.CFStringGetLength(ptr[0]);
            OS.CFRelease(ptr[0]);
            return length;
        }
        return OS.TXNDataSize(this.txnObject) / 2;
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        return this.echoCharacter;
    }

    public boolean getEditable() {
        this.checkWidget();
        return (this.style & 8) == 0;
    }

    Rect getInset() {
        if ((this.style & 0x80) != 0) {
            return this.display.searchTextInset;
        }
        if (this.txnObject != 0) {
            return super.getInset();
        }
        return this.display.editTextInset;
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        int[] oLineTotal = new int[1];
        OS.TXNGetLineCount(this.txnObject, oLineTotal);
        return oLineTotal[0];
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return DELIMITER;
    }

    public int getLineHeight() {
        this.checkWidget();
        if (this.txnObject == 0) {
            return this.textExtent((char[])new char[]{' '}, (int)0).y;
        }
        int[] oLineWidth = new int[1];
        int[] oLineHeight = new int[1];
        OS.TXNGetLineMetrics(this.txnObject, 0, oLineWidth, oLineHeight);
        return OS.Fix2Long(oLineHeight[0]);
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    int getPosition(int x, int y) {
        if (this.txnObject == 0) {
            return -1;
        }
        int[] oOffset = new int[1];
        Rect oViewRect = new Rect();
        OS.TXNGetViewRect(this.txnObject, oViewRect);
        CGPoint iPoint = new CGPoint();
        iPoint.x = x + oViewRect.left;
        iPoint.y = y + oViewRect.top;
        return OS.TXNHIPointToOffset(this.txnObject, iPoint, oOffset) == 0 ? oOffset[0] : -1;
    }

    int getPosition(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.getPosition(point.x, point.y);
    }

    public Point getSelection() {
        this.checkWidget();
        if (this.txnObject == 0) {
            ControlEditTextSelectionRec selection;
            if (this.selection != null) {
                selection = this.selection;
            } else {
                selection = new ControlEditTextSelectionRec();
                OS.GetControlData(this.handle, (short)0, 1936026725, 4, selection, null);
            }
            return new Point(selection.selStart, selection.selEnd);
        }
        int[] oStartOffset = new int[1];
        int[] oEndOffset = new int[1];
        OS.TXNGetSelection(this.txnObject, oStartOffset, oEndOffset);
        return new Point(oStartOffset[0], oEndOffset[0]);
    }

    public int getSelectionCount() {
        this.checkWidget();
        if (this.txnObject == 0) {
            Point selection = this.getSelection();
            return selection.y - selection.x;
        }
        int[] oStartOffset = new int[1];
        int[] oEndOffset = new int[1];
        OS.TXNGetSelection(this.txnObject, oStartOffset, oEndOffset);
        return oEndOffset[0] - oStartOffset[0];
    }

    public String getSelectionText() {
        this.checkWidget();
        if (this.txnObject == 0) {
            Point selection = this.getSelection();
            if (selection.x == selection.y) {
                return "";
            }
            return new String(this.getEditText(selection.x, selection.y - 1));
        }
        return this.getTXNText(-1, -1);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    public String getText() {
        this.checkWidget();
        if (this.txnObject == 0) {
            return new String(this.getEditText(0, -1));
        }
        return this.getTXNText(0, Integer.MAX_VALUE);
    }

    public String getText(int start, int end) {
        this.checkWidget();
        if (this.txnObject == 0) {
            return new String(this.getEditText(start, end));
        }
        if (start > end || end < 0) {
            return "";
        }
        int length = OS.TXNDataSize(this.txnObject) / 2;
        start = Math.max(0, start);
        end = Math.min(end, length - 1);
        return this.getTXNText(start, end + 1);
    }

    char[] getEditText(int start, int end) {
        int[] ptr = new int[1];
        int[] actualSize = new int[1];
        int result = OS.GetControlData(this.handle, (short)0, 1667658612, 4, ptr, actualSize);
        if (result != 0) {
            return new char[0];
        }
        int length = OS.CFStringGetLength(ptr[0]);
        CFRange range = new CFRange();
        range.location = start = Math.min(Math.max(0, start), length);
        if (end == -1) {
            range.length = Math.max(0, length - start);
        } else {
            end = Math.min(Math.max(0, end), length - 1);
            range.length = Math.max(0, end - start + 1);
        }
        char[] buffer = new char[range.length];
        if (this.hiddenText != null) {
            this.hiddenText.getChars(range.location, range.location + range.length, buffer, 0);
        } else {
            OS.CFStringGetCharacters(ptr[0], range, buffer);
        }
        OS.CFRelease(ptr[0]);
        return buffer;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return this.getTopPixel() / this.getLineHeight();
    }

    public int getTopPixel() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        CGRect rect = new CGRect();
        OS.TXNGetHIRect(this.txnObject, 1, rect);
        int destY = (int)rect.y;
        OS.TXNGetHIRect(this.txnObject, 2, rect);
        return destY - (int)rect.y;
    }

    char[] getTXNChars(int iStartOffset, int iEndOffset) {
        int[] oDataHandle = new int[1];
        OS.TXNGetData(this.txnObject, iStartOffset, iEndOffset, oDataHandle);
        if (oDataHandle[0] == 0) {
            return new char[0];
        }
        int length = OS.GetHandleSize(oDataHandle[0]);
        if (length == 0) {
            return new char[0];
        }
        int[] ptr = new int[1];
        OS.HLock(oDataHandle[0]);
        OS.memmove(ptr, oDataHandle[0], 4);
        char[] buffer = new char[length / 2];
        OS.memmove(buffer, ptr[0], length);
        OS.HUnlock(oDataHandle[0]);
        OS.DisposeHandle(oDataHandle[0]);
        return buffer;
    }

    String getTXNText(int iStartOffset, int iEndOffset) {
        return new String(this.getTXNChars(iStartOffset, iEndOffset));
    }

    void hookEvents() {
        int controlTarget;
        int[] mask;
        super.hookEvents();
        if ((this.style & 0x80) != 0) {
            int searchProc = this.display.searchProc;
            mask = new int[]{1936877156, 1};
            controlTarget = OS.GetControlEventTarget(this.handle);
            OS.InstallEventHandler(controlTarget, searchProc, mask.length / 2, mask, this.handle, null);
        }
        if (this.frameHandle != 0) {
            int controlProc = this.display.controlProc;
            mask = new int[]{1668183148, 4};
            controlTarget = OS.GetControlEventTarget(this.frameHandle);
            OS.InstallEventHandler(controlTarget, controlProc, mask.length / 2, mask, this.frameHandle, null);
        }
    }

    Rect inset() {
        if ((this.style & 0x80) != 0) {
            return super.inset();
        }
        if ((this.style & 4) != 0 && (this.style & 0x800) == 0) {
            Rect rect = new Rect();
            rect.bottom = 1;
            rect.right = 1;
            rect.top = 1;
            rect.left = 1;
            return rect;
        }
        if ((this.style & 2) != 0 && (this.style & 0x800) != 0) {
            int[] outMetric = new int[1];
            OS.GetThemeMetric(7, outMetric);
            Rect rect = new Rect();
            rect.left = (short)(rect.left + outMetric[0]);
            rect.top = (short)(rect.top + outMetric[0]);
            rect.right = (short)(rect.right + outMetric[0]);
            rect.bottom = (short)(rect.bottom + outMetric[0]);
            OS.GetThemeMetric(5, outMetric);
            rect.left = (short)(rect.left + outMetric[0]);
            rect.top = (short)(rect.top + outMetric[0]);
            rect.right = (short)(rect.right + outMetric[0]);
            rect.bottom = (short)(rect.bottom + outMetric[0]);
            return rect;
        }
        return new Rect();
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.hooks(25) || this.filters(25)) {
            Point selection = this.getSelection();
            if ((string = this.verifyText(string, selection.x, selection.y, null)) == null) {
                return;
            }
        }
        if (this.txnObject == 0) {
            this.insertEditText(string);
        } else {
            this.setTXNText(-1, -1, string);
            OS.TXNShowSelection(this.txnObject, false);
        }
        if (string.length() != 0) {
            this.sendModifyEvent(true);
        }
    }

    void insertEditText(String string) {
        int length = string.length();
        Point selection = this.getSelection();
        if (this.hasFocus() && this.hiddenText == null) {
            int charCount;
            if (this.textLimit != LIMIT && (charCount = this.getCharCount()) - (selection.y - selection.x) + length > this.textLimit) {
                length = this.textLimit - charCount + (selection.y - selection.x);
            }
            char[] buffer = new char[length];
            string.getChars(0, buffer.length, buffer, 0);
            int ptr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
            if (ptr == 0) {
                this.error(13);
            }
            OS.SetControlData(this.handle, 0, 1768842086, 4, new int[]{ptr});
            OS.CFRelease(ptr);
        } else {
            int charCount;
            String oldText = this.getText();
            if (this.textLimit != LIMIT && (charCount = oldText.length()) - (selection.y - selection.x) + length > this.textLimit) {
                string = string.substring(0, this.textLimit - charCount + (selection.y - selection.x));
            }
            String newText = String.valueOf(oldText.substring(0, selection.x)) + string + oldText.substring(selection.y);
            this.setEditText(newText);
            this.setSelection(selection.x + string.length());
        }
    }

    int kEventAccessibleGetNamedAttribute(int nextHandler, int theEvent, int userData) {
        int code = -9874;
        if (this.txnObject != 0) {
            boolean ok;
            int[] valueRef;
            int status;
            int[] stringRef = new int[1];
            OS.GetEventParameter(theEvent, 1635020397, 1667658612, null, 4, null, stringRef);
            int length = 0;
            if (stringRef[0] != 0) {
                length = OS.CFStringGetLength(stringRef[0]);
            }
            char[] buffer = new char[length];
            CFRange range = new CFRange();
            range.length = length;
            OS.CFStringGetCharacters(stringRef[0], range, buffer);
            String attributeName = new String(buffer);
            if (attributeName.equals("AXRole") || attributeName.equals("AXRoleDescription")) {
                String roleText = (this.style & 2) != 0 ? "AXTextArea" : "AXTextField";
                buffer = new char[roleText.length()];
                roleText.getChars(0, buffer.length, buffer, 0);
                stringRef[0] = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
                if (stringRef[0] != 0) {
                    if (attributeName.equals("AXRole")) {
                        OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, stringRef);
                    } else {
                        int stringRef2 = OS.HICopyAccessibilityRoleDescription(stringRef[0], 0);
                        OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, new int[]{stringRef2});
                        OS.CFRelease(stringRef2);
                    }
                    OS.CFRelease(stringRef[0]);
                    code = 0;
                }
            } else if (OS.VERSION < 4176 && attributeName.equals("AXFocused")) {
                OS.SetEventParameter(theEvent, 1635022444, 1651470188, 4, new boolean[]{this.hasFocus()});
                code = 0;
            } else if (attributeName.equals("AXTitle")) {
                code = 0;
            } else if (attributeName.equals("AXValue")) {
                buffer = this.getTXNChars(0, Integer.MAX_VALUE);
                stringRef[0] = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
                if (stringRef[0] != 0) {
                    OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, stringRef);
                    OS.CFRelease(stringRef[0]);
                    code = 0;
                }
            } else if (attributeName.equals("AXNumberOfCharacters")) {
                OS.SetEventParameter(theEvent, 1635022444, 1819242087, 4, new int[]{this.getCharCount()});
                code = 0;
            } else if (attributeName.equals("AXSelectedText")) {
                Point sel = this.getSelection();
                buffer = this.getTXNChars(sel.x, sel.y);
                stringRef[0] = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
                if (stringRef[0] != 0) {
                    OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, stringRef);
                    OS.CFRelease(stringRef[0]);
                    code = 0;
                }
            } else if (attributeName.equals("AXSelectedTextRange")) {
                Point sel = this.getSelection();
                range = new CFRange();
                range.location = sel.x;
                range.length = sel.y - sel.x;
                int valueRef2 = OS.AXValueCreate(4, range);
                OS.SetEventParameter(theEvent, 1635022444, 1667658873, 4, new int[]{valueRef2});
                OS.CFRelease(valueRef2);
                code = 0;
            } else if (attributeName.equals("AXStringForRange") && (status = OS.GetEventParameter(theEvent, 1635020897, 1667658873, null, 4, null, valueRef = new int[1])) == 0 && (ok = OS.AXValueGetValue(valueRef[0], 4, range = new CFRange()))) {
                buffer = this.getTXNChars(range.location, range.location + range.length);
                stringRef[0] = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
                if (stringRef[0] != 0) {
                    OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, stringRef);
                    OS.CFRelease(stringRef[0]);
                    code = 0;
                }
            }
        }
        if (this.accessible != null) {
            code = this.accessible.internal_kEventAccessibleGetNamedAttribute(nextHandler, theEvent, code);
        }
        return code;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMouseDown(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (!this.doubleClick) {
            int[] clickCount = new int[1];
            OS.GetEventParameter(theEvent, 1667460724, 1835100014, null, 4, null, clickCount);
            if (clickCount[0] > 1) {
                return 0;
            }
        }
        return result;
    }

    int kEventSearchFieldCancelClicked(int nextHandler, int theEvent, int userData) {
        int result = super.kEventSearchFieldCancelClicked(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.setText("");
        Event event = new Event();
        event.detail = 256;
        this.postEvent(14, event);
        return result;
    }

    int kEventUnicodeKeyPressed(int nextHandler, int theEvent, int userData) {
        int[] keyCode;
        int result = super.kEventUnicodeKeyPressed(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter(theEvent, 1953721189, 1702261350, null, keyboardEvent.length * 4, null, keyboardEvent);
        int[] modifiers = new int[1];
        OS.GetEventParameter(keyboardEvent[0], 1802334052, 1835100014, null, 4, null, modifiers);
        if (modifiers[0] == 256) {
            keyCode = new int[1];
            OS.GetEventParameter(keyboardEvent[0], 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
            switch (keyCode[0]) {
                case 7: {
                    this.cut();
                    return 0;
                }
                case 8: {
                    this.copy();
                    return 0;
                }
                case 9: {
                    this.paste();
                    return 0;
                }
            }
        }
        if ((this.style & 4) != 0) {
            keyCode = new int[1];
            OS.GetEventParameter(keyboardEvent[0], 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
            switch (keyCode[0]) {
                case 36: 
                case 76: {
                    this.postEvent(14);
                    return 0;
                }
                case 48: {
                    return 0;
                }
            }
        }
        return result;
    }

    int kEventTextInputUpdateActiveInputArea(int nextHandler, int theEvent, int userData) {
        int[] length = new int[1];
        OS.GetEventParameter(theEvent, 1953723512, 1970567284, null, 0, length, null);
        int[] fixed_length = new int[1];
        OS.GetEventParameter(theEvent, 1953719928, 1819242087, null, 4, null, fixed_length);
        if (fixed_length[0] == -1 || fixed_length[0] == length[0]) {
            this.sendModifyEvent(false);
        }
        return -9874;
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        boolean paste = true;
        String oldText = null;
        if ((this.hooks(25) || this.filters(25)) && (oldText = this.getClipboardText()) != null) {
            Point selection = this.getSelection();
            String newText = this.verifyText(oldText, selection.x, selection.y, null);
            if (newText == null) {
                return;
            }
            if (!newText.equals(oldText)) {
                if (this.txnObject == 0) {
                    this.insertEditText(newText);
                } else {
                    this.setTXNText(-1, -1, newText);
                    OS.TXNShowSelection(this.txnObject, false);
                }
                paste = false;
            }
        }
        if (paste) {
            if (this.txnObject == 0) {
                if (oldText == null) {
                    oldText = this.getClipboardText();
                }
                this.insertEditText(oldText);
            } else if (this.textLimit != LIMIT) {
                if (oldText == null) {
                    oldText = this.getClipboardText();
                }
                this.setTXNText(-1, -1, oldText);
                OS.TXNShowSelection(this.txnObject, false);
            } else {
                OS.TXNPaste(this.txnObject);
            }
        }
        this.sendModifyEvent(true);
    }

    boolean pollTrackEvent() {
        return true;
    }

    void register() {
        super.register();
        if (this.frameHandle != 0) {
            this.display.addWidget(this.frameHandle, this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.txnObject = 0;
        this.message = null;
        this.hiddenText = null;
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void selectAll() {
        this.checkWidget();
        if (this.txnObject == 0) {
            this.setSelection(0, this.getCharCount());
        } else {
            OS.TXNSelectAll(this.txnObject);
        }
    }

    boolean sendKeyEvent(int type, Event event) {
        boolean result;
        String newText;
        if (!super.sendKeyEvent(type, event)) {
            return false;
        }
        if (type != 1) {
            return true;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        if ((event.stateMask & 0x400000) != 0) {
            return true;
        }
        String oldText = "";
        int charCount = this.getCharCount();
        Point selection = this.getSelection();
        int start = selection.x;
        int end = selection.y;
        switch (event.character) {
            case '\b': {
                if (start != end) break;
                if (start == 0) {
                    return true;
                }
                start = Math.max(0, start - 1);
                break;
            }
            case '\u007f': {
                if (start != end) break;
                if (start == charCount) {
                    return true;
                }
                end = Math.min(end + 1, charCount);
                break;
            }
            case '\r': {
                if ((this.style & 4) != 0) {
                    return true;
                }
                oldText = DELIMITER;
                break;
            }
            default: {
                if (event.character != '\t' && event.character < ' ') {
                    return true;
                }
                oldText = new String(new char[]{event.character});
            }
        }
        if ((newText = this.verifyText(oldText, start, end, event)) == null) {
            return false;
        }
        if (charCount - (end - start) + newText.length() > this.textLimit) {
            return false;
        }
        boolean bl = result = newText == oldText;
        if (newText != oldText || this.hiddenText != null) {
            if (this.txnObject == 0) {
                String text = new String(this.getEditText(0, -1));
                String leftText = text.substring(0, start);
                String rightText = text.substring(end, text.length());
                this.setEditText(String.valueOf(leftText) + newText + rightText);
                this.setSelection(new Point(start += newText.length(), start));
                result = false;
            } else {
                this.setTXNText(start, end, newText);
            }
        }
        this.sendModifyEvent(false);
        return result;
    }

    void sendModifyEvent(boolean send) {
        String string = "AXSelectedTextChanged";
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        int stringRef = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
        OS.AXNotificationHIObjectNotify(stringRef, this.handle, 0L);
        OS.CFRelease(stringRef);
        string = "AXValueChanged";
        buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        stringRef = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
        OS.AXNotificationHIObjectNotify(stringRef, this.handle, 0L);
        OS.CFRelease(stringRef);
        if (send) {
            this.sendEvent(24);
        } else {
            this.postEvent(24);
        }
    }

    void setBackground(float[] color) {
        if (this.txnObject == 0) {
            super.setBackground(color);
        } else {
            int colorspace = OS.CGColorSpaceCreateDeviceRGB();
            int colorRef = OS.CGColorCreate(colorspace, color);
            OS.HITextViewSetBackgroundColor(this.handle, colorRef);
            OS.CGColorRelease(colorRef);
            OS.CGColorSpaceRelease(colorspace);
        }
    }

    void setBackground(int control, float[] color) {
        if (this.handle == control) {
            ControlFontStyleRec fontStyle = new ControlFontStyleRec();
            OS.GetControlData(control, (short)0, 1718578804, 24, fontStyle, null);
            fontStyle.flags = (short)(fontStyle.flags | 0x10);
            OS.SetControlFontStyle(control, fontStyle);
            fontStyle.backColor_blue = (short)-1;
            fontStyle.backColor_green = (short)-1;
            fontStyle.backColor_red = (short)-1;
            OS.SetControlFontStyle(control, fontStyle);
        }
        super.setBackground(control, color);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        Rectangle bounds = null;
        if (this.txnObject == 0 && resize) {
            bounds = this.getBounds();
        }
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if (bounds != null && (result & 0x80) != 0) {
            Rect inset = this.getInset();
            int minWidth = inset.left + inset.right;
            if (bounds.width <= minWidth && width > minWidth) {
                if (this.hasFocus()) {
                    ControlEditTextSelectionRec selection = new ControlEditTextSelectionRec();
                    if (OS.GetControlData(this.handle, (short)0, 1936026725, 4, selection, null) == 0) {
                        OS.SetControlData(this.handle, 0, 1936026725, 4, selection);
                    }
                } else {
                    int[] ptr = new int[1];
                    if (OS.GetControlData(this.handle, (short)0, 1667658612, 4, ptr, null) == 0) {
                        OS.SetControlData(this.handle, 0, 1667658612, 4, ptr);
                    }
                    if (ptr[0] != 0) {
                        OS.CFRelease(ptr[0]);
                    }
                }
            }
        }
        if (this.scrolledHandle != 0 && (this.style & 0x300) == 0) {
            OS.HIScrollViewSetScrollBarAutoHide(this.scrolledHandle, true);
        }
        return result;
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
        this.doubleClick = doubleClick;
    }

    public void setEchoChar(char echo) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.txnObject == 0) {
            if ((this.style & 0x400000) == 0) {
                Point selection = this.getSelection();
                String text = this.getText();
                this.echoCharacter = echo;
                this.setEditText(text);
                this.setSelection(selection);
            }
        } else {
            OS.TXNEchoMode(this.txnObject, echo, 126, echo != '\u0000');
        }
        this.echoCharacter = echo;
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.style = editable ? (this.style &= 0xFFFFFFF7) : (this.style |= 8);
        if (this.txnObject == 0) {
            OS.SetControlData(this.handle, 0, 1819239275, 1, new byte[]{(byte)((this.style & 8) != 0 ? 1 : 0)});
        } else {
            OS.TXNSetTXNObjectControls(this.txnObject, false, 1, new int[]{1768910966}, new int[]{(this.style & 8) != 0 ? 1 : 0});
        }
    }

    void setForeground(float[] color) {
        if (this.txnObject == 0) {
            super.setForeground(color);
        } else {
            int ptr2 = OS.NewPtr(6);
            RGBColor rgb = color == null ? new RGBColor() : this.toRGBColor(color);
            OS.memmove(ptr2, rgb, 6);
            int[] attribs = new int[]{1802268530, 6, ptr2};
            int ptr1 = OS.NewPtr(attribs.length * 4);
            OS.memmove(ptr1, attribs, attribs.length * 4);
            boolean readOnly = (this.style & 8) != 0;
            int[] tag = new int[]{1768910966};
            if (readOnly) {
                OS.TXNSetTXNObjectControls(this.txnObject, false, 1, tag, new int[1]);
            }
            OS.TXNSetTypeAttributes(this.txnObject, attribs.length / 3, ptr1, 0, 0);
            if (readOnly) {
                OS.TXNSetTXNObjectControls(this.txnObject, false, 1, tag, new int[]{1});
            }
            OS.DisposePtr(ptr1);
            OS.DisposePtr(ptr2);
        }
    }

    void setFontStyle(Font font) {
        if (this.txnObject == 0) {
            super.setFontStyle(font);
        } else {
            int family = 0;
            int fontStyle = 0;
            int size = 786432;
            if (font != null) {
                short[] id = new short[1];
                short[] s = new short[1];
                OS.FMGetFontFamilyInstanceFromFont(font.handle, id, s);
                family = id[0];
                fontStyle = s[0] | font.style;
                size = OS.X2Fix(font.size);
            }
            int[] attribs = new int[]{1936292453, 2, size, 1717658469, 2, fontStyle, 1718578804, 2, family};
            int ptr = OS.NewPtr(attribs.length * 4);
            OS.memmove(ptr, attribs, attribs.length * 4);
            boolean readOnly = (this.style & 8) != 0;
            int[] tag = new int[]{1768910966};
            if (readOnly) {
                OS.TXNSetTXNObjectControls(this.txnObject, false, 1, tag, new int[1]);
            }
            OS.TXNSetTypeAttributes(this.txnObject, attribs.length / 3, ptr, 0, 0);
            if (readOnly) {
                OS.TXNSetTXNObjectControls(this.txnObject, false, 1, tag, new int[]{1});
            }
            OS.DisposePtr(ptr);
        }
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setMessage(String message) {
        this.checkWidget();
        if (message == null) {
            this.error(4);
        }
        this.message = message;
        if ((this.style & 0x80) != 0) {
            char[] buffer = new char[message.length()];
            message.getChars(0, buffer.length, buffer, 0);
            int ptr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
            if (ptr == 0) {
                this.error(13);
            }
            OS.HISearchFieldSetDescriptiveText(this.handle, ptr);
            OS.CFRelease(ptr);
        }
    }

    public void setSelection(int start) {
        this.checkWidget();
        this.setSelection(start, start);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if (this.txnObject == 0) {
            int length = this.getCharCount();
            ControlEditTextSelectionRec selection = new ControlEditTextSelectionRec();
            selection.selStart = (short)Math.min(Math.max(Math.min(start, end), 0), length);
            selection.selEnd = (short)Math.min(Math.max(Math.max(start, end), 0), length);
            if (this.hasFocus()) {
                OS.SetControlData(this.handle, 0, 1936026725, 4, selection);
            } else {
                this.selection = selection;
            }
        } else {
            int length = OS.TXNDataSize(this.txnObject) / 2;
            int nStart = Math.min(Math.max(Math.min(start, end), 0), length);
            int nEnd = Math.min(Math.max(Math.max(start, end), 0), length);
            OS.TXNSetSelection(this.txnObject, nStart, nEnd);
            OS.TXNShowSelection(this.txnObject, false);
        }
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public void setTabs(int tabs) {
        this.checkWidget();
        if (this.tabs == tabs) {
            return;
        }
        if (this.txnObject == 0) {
            return;
        }
        this.tabs = tabs;
        TXNTab tab = new TXNTab();
        tab.value = (short)(this.textExtent((char[])new char[]{' '}, (int)0).x * tabs);
        int[] tags = new int[]{1952539251};
        int[] datas = new int[1];
        OS.memmove(datas, tab, 4);
        OS.TXNSetTXNObjectControls(this.txnObject, false, tags.length, tags, datas);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount(), null)) == null) {
            return;
        }
        if (this.txnObject == 0) {
            this.setEditText(string);
        } else {
            this.setTXNText(0, Integer.MAX_VALUE, string);
            OS.TXNSetSelection(this.txnObject, 0, 0);
            OS.TXNShowSelection(this.txnObject, false);
        }
        this.sendModifyEvent(true);
    }

    void setEditText(String string) {
        char[] buffer;
        if ((this.style & 0x400000) == 0 && this.echoCharacter != '\u0000') {
            this.hiddenText = string;
            buffer = new char[Math.min(this.hiddenText.length(), this.textLimit)];
            int i = 0;
            while (i < buffer.length) {
                buffer[i] = this.echoCharacter;
                ++i;
            }
        } else {
            this.hiddenText = null;
            buffer = new char[Math.min(string.length(), this.textLimit)];
            string.getChars(0, buffer.length, buffer, 0);
        }
        int ptr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
        if (ptr == 0) {
            this.error(13);
        }
        OS.SetControlData(this.handle, 0, 1667658612, 4, new int[]{ptr});
        OS.CFRelease(ptr);
        if (this.selection != null) {
            this.selection = null;
        }
    }

    void setTXNText(int iStartOffset, int iEndOffset, String string) {
        int length = string.length();
        if (this.textLimit != LIMIT) {
            int charCount = OS.TXNDataSize(this.txnObject) / 2;
            int start = iStartOffset;
            int end = iEndOffset;
            if (iStartOffset == -1 || iEndOffset == -1) {
                int[] oStartOffset = new int[1];
                int[] oEndOffset = new int[1];
                OS.TXNGetSelection(this.txnObject, oStartOffset, oEndOffset);
                start = oStartOffset[0];
                end = oEndOffset[0];
            } else {
                if (iStartOffset == Integer.MAX_VALUE) {
                    start = charCount;
                }
                if (iEndOffset == Integer.MAX_VALUE) {
                    end = charCount;
                }
            }
            if (charCount - (end - start) + length > this.textLimit) {
                length = this.textLimit - charCount + (end - start);
            }
        }
        char[] buffer = new char[length];
        string.getChars(0, buffer.length, buffer, 0);
        boolean readOnly = (this.style & 8) != 0;
        int[] tag = new int[]{1768910966};
        if (readOnly) {
            OS.TXNSetTXNObjectControls(this.txnObject, false, 1, tag, new int[1]);
        }
        OS.TXNSetData(this.txnObject, 1970567284, buffer, buffer.length * 2, iStartOffset, iEndOffset);
        if (readOnly) {
            OS.TXNSetTXNObjectControls(this.txnObject, false, 1, tag, new int[]{1});
        }
        if (OS.TXNDataSize(this.txnObject) / 2 == 0) {
            this.setFontStyle(this.font);
        }
    }

    void setZOrder() {
        if (this.frameHandle != 0) {
            int child = this.scrolledHandle != 0 ? this.scrolledHandle : this.handle;
            OS.HIViewAddSubview(this.frameHandle, child);
            HILayoutInfo layout = new HILayoutInfo();
            layout.version = 0;
            OS.HIViewGetLayoutInfo(child, layout);
            HISideBinding biding = layout.binding.top;
            biding.toView = 0;
            biding.kind = 1;
            biding.offset = 0.0f;
            biding = layout.binding.left;
            biding.toView = 0;
            biding.kind = 1;
            biding.offset = 0.0f;
            biding = layout.binding.bottom;
            biding.toView = 0;
            biding.kind = (short)2;
            biding.offset = 0.0f;
            biding = layout.binding.right;
            biding.toView = 0;
            biding.kind = (short)2;
            biding.offset = 0.0f;
            CGRect r = new CGRect();
            r.height = 100.0f;
            r.width = 100.0f;
            OS.HIViewSetFrame(this.frameHandle, r);
            Rect inset = this.inset();
            r.x += (float)inset.left;
            r.y += (float)inset.top;
            r.width -= (float)(inset.left + inset.right);
            r.height -= (float)(inset.top + inset.bottom);
            OS.HIViewSetFrame(child, r);
            OS.HIViewSetLayoutInfo(child, layout);
        }
        super.setZOrder();
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        this.textLimit = limit;
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int[] event = new int[1];
        OS.CreateEvent(0, 1935897196, 10, 0.0, 0, event);
        if (event[0] != 0) {
            int lineHeight = this.getLineHeight();
            CGPoint pt = new CGPoint();
            pt.y = lineHeight * Math.min(this.getLineCount(), index);
            OS.SetEventParameter(event[0], 1869768558, 1751740532, 8, pt);
            OS.SendEventToEventTarget(event[0], OS.GetControlEventTarget(this.handle));
            OS.ReleaseEvent(event[0]);
        }
    }

    public void showSelection() {
        this.checkWidget();
        if (this.txnObject == 0) {
            this.setSelection(this.getSelection());
        } else {
            OS.TXNShowSelection(this.txnObject, false);
        }
    }

    int topHandle() {
        if (this.frameHandle != 0) {
            return this.frameHandle;
        }
        return super.topHandle();
    }

    int traversalCode(int key, int theEvent) {
        int bits = super.traversalCode(key, theEvent);
        if ((this.style & 8) != 0) {
            return bits;
        }
        if ((this.style & 2) != 0) {
            bits &= 0xFFFFFFFB;
            if (key == 48 && theEvent != 0) {
                boolean next;
                int[] modifiers = new int[1];
                OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
                boolean bl = next = (modifiers[0] & 0x200) == 0;
                if (next && (modifiers[0] & 0x1000) == 0) {
                    bits &= 0xFFFFFFE7;
                }
            }
        }
        return bits;
    }

    String verifyText(String string, int start, int end, Event keyEvent) {
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        if (keyEvent != null) {
            event.character = keyEvent.character;
            event.keyCode = keyEvent.keyCode;
            event.stateMask = keyEvent.stateMask;
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

