/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.security.common;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import org.eclipse.riena.security.common.ISubjectChangeListener;
import org.eclipse.riena.security.common.ISubjectHolder;
import org.eclipse.riena.security.common.SubjectChangeEvent;

public class SimpleSubjectHolder
implements ISubjectHolder {
    private Subject subject;
    private List<ISubjectChangeListener> principalChangeListeners = new ArrayList<ISubjectChangeListener>();

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        Subject old = this.subject;
        this.subject = subject;
        this.notifySubjectChange(this.subject, old);
    }

    private void notifySubjectChange(Subject newSubject, Subject oldSubject) {
        if (this.principalChangeListeners.size() > 0) {
            SubjectChangeEvent event = new SubjectChangeEvent(newSubject, oldSubject);
            for (ISubjectChangeListener listener : this.principalChangeListeners) {
                listener.changed(event);
            }
        }
    }

    public void addSubjectChangeListener(ISubjectChangeListener listener) {
        if (listener != null) {
            this.principalChangeListeners.add(listener);
        }
    }

    public void removeSubjectChangeListener(ISubjectChangeListener listener) {
        this.principalChangeListeners.remove(listener);
    }
}

