/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class Pipe {
    protected InputStream input;
    private PipedInputStream pipedInputStream;
    protected PipedOutputStream pipedOutputStream;

    public Pipe(InputStream original) throws IOException {
        this.input = original;
        this.pipedInputStream = new PipedInputStream(){
            protected IOException failure;
            private boolean started = false;
            protected Object lock = this;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void start() throws IOException {
                Object object = this.lock;
                synchronized (object) {
                    if (this.failure != null) {
                        IOException e = new IOException("Problem piping the stream.");
                        e.fillInStackTrace();
                        e.initCause(this.failure);
                        throw e;
                    }
                    if (!this.started) {
                        this.started = true;
                        Thread pipeThread = new Thread(new Runnable(this){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    1.access$0(this.this$1).pipeInput(1.access$0(this.this$1).input, 1.access$0(this.this$1).pipedOutputStream);
                                    1.access$0(this.this$1).pipedOutputStream.close();
                                }
                                catch (IOException e) {
                                    Object object = this.this$1.lock;
                                    synchronized (object) {
                                        this.this$1.failure = e;
                                    }
                                }
                            }
                        });
                        pipeThread.start();
                    }
                }
            }

            public synchronized int available() throws IOException {
                this.start();
                return super.available();
            }

            public synchronized int read() throws IOException {
                this.start();
                int c = super.read();
                return c;
            }

            public int read(byte[] b) throws IOException {
                this.start();
                return super.read(b);
            }

            public synchronized int read(byte[] b, int off, int len) throws IOException {
                this.start();
                return super.read(b, off, len);
            }

            public synchronized void reset() throws IOException {
                this.started = false;
                this.failure = null;
                Pipe.this.input.reset();
                super.reset();
            }

            static /* synthetic */ Pipe access$0(1 var0) {
                return var0.Pipe.this;
            }
        };
        this.pipedOutputStream = new PipedOutputStream(this.pipedInputStream);
    }

    public InputStream getPipedInputStream() {
        return this.pipedInputStream;
    }

    protected void pipeInput(InputStream original, OutputStream result) throws IOException {
        byte[] buffer = new byte[2048];
        int len = 0;
        while ((len = original.read(buffer)) != 0) {
            result.write(buffer, 0, len);
        }
    }
}

