/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.marker;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.navigation.ui.marker.IUIProcessMarkupStrategy;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISimpleNavigationNodeListener;
import org.eclipse.riena.navigation.model.SimpleNavigationNodeAdapater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeHierarchyMarkerStrategy
implements IUIProcessMarkupStrategy {
    private IMarker marker;
    private ISimpleNavigationNodeListener nodeObserver = new NodeObserver();

    @Override
    public void applyUIProcessMarker(INavigationNode<?> baseNode, IMarker marker) {
        this.marker = marker;
        INavigationNode node = baseNode;
        HashSet markedTyped = new HashSet();
        while (node != null && node.isDeactivated()) {
            if (!this.nodeTypeMarked(markedTyped, node.getClass())) {
                this.addNavigationNodeMarker(node);
                this.observeNodeActivity(node);
                markedTyped.add(node.getClass());
            }
            node = node.getParent();
        }
    }

    boolean nodeTypeMarked(Set<Class<?>> markedTypes, Class<?> nodeType) {
        for (Class<?> markedType : markedTypes) {
            if (!markedType.isAssignableFrom(nodeType) && !nodeType.isAssignableFrom(markedType)) continue;
            return true;
        }
        return false;
    }

    void addNavigationNodeMarker(INavigationNode<?> node) {
        node.addMarker(this.marker);
    }

    private void observeNodeActivity(INavigationNode<?> node) {
        node.addSimpleListener(this.nodeObserver);
    }

    private void removeNavigationNodeMarker(INavigationNode source) {
        source.removeMarker(this.marker);
        source.removeSimpleListener(this.nodeObserver);
    }

    class NodeObserver
    extends SimpleNavigationNodeAdapater {
        NodeObserver() {
        }

        public void activated(INavigationNode source) {
            TypeHierarchyMarkerStrategy.this.removeNavigationNodeMarker(source);
        }
    }
}

