/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import java.util.Iterator;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.navigation.ui.controllers.NavigationNodeController;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IWindowRidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubModuleController
extends NavigationNodeController<ISubModuleNode> {
    public static final String WINDOW_RIDGET = "windowRidget";
    private static final String TITLE_SEPARATOR = " - ";

    public SubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public SubModuleController() {
        this(null);
    }

    @Override
    public void setNavigationNode(ISubModuleNode navigationNode) {
        super.setNavigationNode(navigationNode);
        ((ISubModuleNode)this.getNavigationNode()).addListener((INavigationNodeListener)new SubModuleNodeListener(){

            public void labelChanged(ISubModuleNode subModuleNode) {
                SubModuleController.this.updateLabel();
            }

            public void iconChanged(ISubModuleNode source) {
                SubModuleController.this.updateIcon();
            }
        });
    }

    public void setWindowRidget(IWindowRidget windowRidget) {
        if (this.getRidget(WINDOW_RIDGET) != windowRidget) {
            this.addRidget(WINDOW_RIDGET, (IRidget)windowRidget);
        }
    }

    public IWindowRidget getWindowRidget() {
        return (IWindowRidget)this.getRidget(WINDOW_RIDGET);
    }

    @Override
    public void afterBind() {
        super.afterBind();
        this.updateLabel();
        this.updateIcon();
        this.updateCloseable();
        this.updateActive();
    }

    public void setDefaultButton(IActionRidget actionRidget) {
        IWindowRidget windowRidget = this.getWindowRidget();
        if (windowRidget != null) {
            windowRidget.setDefaultButton(actionRidget.getUIControl());
        }
    }

    public Object getDefaultButton() {
        IWindowRidget windowRidget = this.getWindowRidget();
        if (windowRidget != null) {
            return windowRidget.getDefaultButton();
        }
        return null;
    }

    private void updateLabel() {
        IWindowRidget windowRidget = this.getWindowRidget();
        if (windowRidget != null) {
            windowRidget.setTitle(this.getFullTitle());
        }
    }

    private void updateCloseable() {
        IWindowRidget windowRidget = this.getWindowRidget();
        if (windowRidget != null) {
            windowRidget.setCloseable(false);
        }
    }

    private void updateActive() {
        IWindowRidget windowRidget = this.getWindowRidget();
        if (windowRidget != null) {
            windowRidget.setActive(((ISubModuleNode)this.getNavigationNode()).isActivated());
        }
    }

    protected String getFullTitle() {
        String title = ((ISubModuleNode)this.getNavigationNode()).getLabel();
        if (!this.getModuleController().hasSingleLeafChild()) {
            INavigationNode parent = ((ISubModuleNode)this.getNavigationNode()).getParent();
            while (!(parent instanceof IModuleNode)) {
                title = String.valueOf(parent.getLabel()) + TITLE_SEPARATOR + title;
                parent = parent.getParent();
            }
            title = String.valueOf(parent.getLabel()) + TITLE_SEPARATOR + title;
        }
        return title;
    }

    private void updateIcon() {
        this.updateIcon(this.getWindowRidget());
    }

    public ModuleController getModuleController() {
        return (ModuleController)((IModuleNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IModuleNode.class)).getNavigationNodeController();
    }

    public void configureRidgets() {
    }

    public void updateAllRidgetsFromModel() {
        Iterator<IRidget> r = this.getRidgets().iterator();
        while (r.hasNext()) {
            r.next().updateFromModel();
        }
    }
}

