/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.hooks;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.Subject;
import org.eclipse.riena.communication.core.hooks.MySecurityAction;

public abstract class AbstractHooksProxy
implements InvocationHandler {
    private Object proxiedInstance;
    private HashMap<String, List<Method>> methodTable = new HashMap();

    public AbstractHooksProxy(Object proxiedInstance) {
        Method[] methods;
        this.proxiedInstance = proxiedInstance;
        Method[] methodArray = methods = proxiedInstance.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Class<?>[] param = method.getParameterTypes();
            String computedMethodName = this.computeMethodName(method, param.length);
            List<Method> mList = this.methodTable.get(computedMethodName);
            if (mList == null) {
                mList = new ArrayList<Method>();
                this.methodTable.put(computedMethodName, mList);
            }
            mList.add(method);
            ++n2;
        }
    }

    private String computeMethodName(Method method, int paramSize) {
        return String.valueOf(method.getName()) + "__" + paramSize;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String computedMethodName = args != null ? this.computeMethodName(method, args.length) : this.computeMethodName(method, 0);
        List<Method> mList = this.methodTable.get(computedMethodName);
        Method proxyMethod = null;
        if (mList.size() == 1) {
            proxyMethod = mList.get(0);
        } else {
            for (Method tmpMethod : mList) {
                Class<?>[] paramTypes = tmpMethod.getParameterTypes();
                int i = 0;
                boolean found = true;
                Class<?>[] classArray = paramTypes;
                int n = paramTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> param = classArray[n2];
                    if (!param.isAssignableFrom(args[i].getClass())) {
                        found = false;
                        break;
                    }
                    ++n2;
                }
                if (!found) continue;
                proxyMethod = tmpMethod;
                break;
            }
        }
        if (proxyMethod == null) {
            throw new NoSuchMethodException(this.proxiedInstance + " " + method.getName() + "," + Arrays.toString(args));
        }
        Subject subject = this.getSubject();
        if (subject == null) {
            return proxyMethod.invoke(this.proxiedInstance, args);
        }
        MySecurityAction myAction = new MySecurityAction(proxyMethod, this.proxiedInstance, args);
        try {
            Subject.doAsPrivileged(subject, myAction, null);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof InvocationTargetException) {
                cause = ((InvocationTargetException)cause).getTargetException();
            }
            throw cause;
        }
        return myAction.getResult();
    }

    protected Object getProxiedInstance() {
        return this.proxiedInstance;
    }

    public abstract Subject getSubject();
}

