/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.tests.UITestHelper;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.listener.FocusEvent;
import org.eclipse.riena.ui.ridgets.listener.IFocusListener;
import org.eclipse.riena.ui.tests.base.PropertyChangeEventEquals;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

@UITestCase
public abstract class AbstractSWTRidgetWithControlTest
extends TestCase {
    private Shell shell;
    private Object control;
    private IRidget ridget;
    private Text otherControl;
    private PropertyChangeListener propertyChangeListenerMock;

    protected void setUp() throws Exception {
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        AbstractSWTRidgetWithControlTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        this.shell = new Shell();
        this.shell.setLayout((Layout)new RowLayout(512));
        this.control = this.createWidget((Composite)this.shell);
        this.ridget = this.createRidget();
        this.ridget.setUIControl(this.control);
        this.propertyChangeListenerMock = (PropertyChangeListener)EasyMock.createMock(PropertyChangeListener.class);
        this.ridget.addPropertyChangeListener(this.propertyChangeListenerMock);
        this.otherControl = new Text((Composite)this.shell, 4);
        this.otherControl.setText("other focusable widget");
        this.shell.setSize(130, 100);
        this.shell.setLocation(0, 0);
        this.shell.open();
    }

    protected void tearDown() throws Exception {
        this.ridget = null;
        this.control = null;
        this.otherControl.dispose();
        this.otherControl = null;
        this.shell.dispose();
        this.shell = null;
    }

    protected abstract Object createWidget(Composite var1);

    protected abstract IRidget createRidget();

    protected Object getWidget() {
        return this.control;
    }

    protected IRidget getRidget() {
        return this.ridget;
    }

    protected final Shell getShell() {
        return this.shell;
    }

    protected Text getOtherControl() {
        return this.otherControl;
    }

    protected final void verifyPropertyChangeEvents() {
        EasyMock.verify((Object[])new Object[]{this.propertyChangeListenerMock});
    }

    protected final void expectNoPropertyChangeEvent() {
        EasyMock.reset((Object[])new Object[]{this.propertyChangeListenerMock});
        EasyMock.replay((Object[])new Object[]{this.propertyChangeListenerMock});
    }

    protected final void expectPropertyChangeEvents(PropertyChangeEvent ... propertyChangeEvents) {
        EasyMock.reset((Object[])new Object[]{this.propertyChangeListenerMock});
        PropertyChangeEvent[] propertyChangeEventArray = propertyChangeEvents;
        int n = propertyChangeEvents.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeEvent propertyChangeEvent = propertyChangeEventArray[n2];
            this.propertyChangeListenerMock.propertyChange(this.createArgumentMatcher(propertyChangeEvent));
            ++n2;
        }
        EasyMock.replay((Object[])new Object[]{this.propertyChangeListenerMock});
    }

    protected final void expectPropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        this.expectPropertyChangeEvents(new PropertyChangeEvent(this.getRidget(), propertyName, oldValue, newValue));
    }

    public void testIsVisible() {
        this.shell.open();
        this.ridget.setVisible(false);
        AbstractSWTRidgetWithControlTest.assertFalse((boolean)this.ridget.isVisible());
        this.ridget.setVisible(true);
        AbstractSWTRidgetWithControlTest.assertTrue((boolean)this.ridget.isVisible());
    }

    public void testGetToolTip() {
        if (!(this.getWidget() instanceof Control)) {
            return;
        }
        this.ridget.setUIControl(null);
        AbstractSWTRidgetWithControlTest.assertEquals(null, (String)this.ridget.getToolTipText());
        this.ridget.setToolTipText("foo");
        AbstractSWTRidgetWithControlTest.assertEquals((String)"foo", (String)this.ridget.getToolTipText());
        Control aControl = (Control)this.getWidget();
        aControl.setToolTipText(null);
        this.ridget.setUIControl((Object)aControl);
        AbstractSWTRidgetWithControlTest.assertEquals((String)"foo", (String)this.ridget.getToolTipText());
        AbstractSWTRidgetWithControlTest.assertEquals((String)"foo", (String)((Control)this.ridget.getUIControl()).getToolTipText());
    }

    public void testGetFocusable() {
        if (!(this.getWidget() instanceof Control)) {
            return;
        }
        IRidget aRidget = this.getRidget();
        AbstractSWTRidgetWithControlTest.assertTrue((boolean)aRidget.isFocusable());
        aRidget.setFocusable(false);
        AbstractSWTRidgetWithControlTest.assertFalse((boolean)aRidget.isFocusable());
        aRidget.setFocusable(true);
        AbstractSWTRidgetWithControlTest.assertTrue((boolean)aRidget.isFocusable());
    }

    public void testSetFocusable() {
        if (!(this.getWidget() instanceof Control)) {
            return;
        }
        IRidget aRidget = this.getRidget();
        Control aControl = (Control)this.getWidget();
        this.otherControl.moveAbove(aControl);
        aControl.setFocus();
        if (aControl.isFocusControl()) {
            aRidget.setFocusable(false);
            this.otherControl.setFocus();
            AbstractSWTRidgetWithControlTest.assertTrue((boolean)this.otherControl.isFocusControl());
            UITestHelper.sendString(this.otherControl.getDisplay(), "\t");
            AbstractSWTRidgetWithControlTest.assertFalse((boolean)aControl.isFocusControl());
            aRidget.setFocusable(true);
            this.otherControl.setFocus();
            UITestHelper.sendString(this.otherControl.getDisplay(), "\t");
            AbstractSWTRidgetWithControlTest.assertTrue((boolean)aControl.isFocusControl());
        }
    }

    public void testRequestFocus() throws Exception {
        if (!(this.getWidget() instanceof Control)) {
            return;
        }
        Control aControl = (Control)this.getWidget();
        aControl.setFocus();
        if (aControl.isFocusControl()) {
            AbstractSWTRidgetWithControlTest.assertTrue((boolean)this.otherControl.setFocus());
            AbstractSWTRidgetWithControlTest.assertFalse((boolean)aControl.isFocusControl());
            AbstractSWTRidgetWithControlTest.assertFalse((boolean)this.ridget.hasFocus());
            final ArrayList focusGainedEvents = new ArrayList();
            final ArrayList focusLostEvents = new ArrayList();
            IFocusListener focusListener = new IFocusListener(){

                public void focusGained(FocusEvent event) {
                    focusGainedEvents.add(event);
                }

                public void focusLost(FocusEvent event) {
                    focusLostEvents.add(event);
                }
            };
            this.ridget.addFocusListener(focusListener);
            this.ridget.requestFocus();
            AbstractSWTRidgetWithControlTest.assertTrue((boolean)aControl.isFocusControl());
            AbstractSWTRidgetWithControlTest.assertTrue((boolean)this.ridget.hasFocus());
            AbstractSWTRidgetWithControlTest.assertEquals((int)1, (int)focusGainedEvents.size());
            AbstractSWTRidgetWithControlTest.assertEquals((Object)this.ridget, (Object)((FocusEvent)focusGainedEvents.get(0)).getNewFocusOwner());
            AbstractSWTRidgetWithControlTest.assertEquals((int)0, (int)focusLostEvents.size());
            AbstractSWTRidgetWithControlTest.assertTrue((boolean)this.otherControl.setFocus());
            AbstractSWTRidgetWithControlTest.assertFalse((boolean)aControl.isFocusControl());
            AbstractSWTRidgetWithControlTest.assertFalse((boolean)this.ridget.hasFocus());
            AbstractSWTRidgetWithControlTest.assertEquals((int)1, (int)focusGainedEvents.size());
            AbstractSWTRidgetWithControlTest.assertEquals((int)1, (int)focusLostEvents.size());
            AbstractSWTRidgetWithControlTest.assertEquals((Object)this.ridget, (Object)((FocusEvent)focusLostEvents.get(0)).getOldFocusOwner());
            this.ridget.removeFocusListener(focusListener);
            this.ridget.requestFocus();
            AbstractSWTRidgetWithControlTest.assertTrue((boolean)this.otherControl.setFocus());
            AbstractSWTRidgetWithControlTest.assertEquals((int)1, (int)focusGainedEvents.size());
            AbstractSWTRidgetWithControlTest.assertEquals((int)1, (int)focusLostEvents.size());
        }
    }

    public void testFiresMarkerProperty() {
        if (!(this.getRidget() instanceof IMarkableRidget)) {
            return;
        }
        IMarkableRidget markableRidget = (IMarkableRidget)this.getRidget();
        MandatoryMarker marker = new MandatoryMarker();
        HashSet before = new HashSet(markableRidget.getMarkers());
        HashSet<MandatoryMarker> after = new HashSet<MandatoryMarker>(before);
        after.add(marker);
        AbstractSWTRidgetWithControlTest.assertTrue((boolean)markableRidget.isEnabled());
        AbstractSWTRidgetWithControlTest.assertEquals((int)(before.size() + 1), (int)after.size());
        this.expectPropertyChangeEvent("marker", before, after);
        markableRidget.addMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        markableRidget.addMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("marker", after, before);
        markableRidget.removeMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        markableRidget.removeMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
    }

    public void testFiresDisabledPropertyUsingSetter() {
        if (!(this.getRidget() instanceof IMarkableRidget)) {
            return;
        }
        IMarkableRidget markableRidget = (IMarkableRidget)this.getRidget();
        markableRidget.removePropertyChangeListener(this.propertyChangeListenerMock);
        markableRidget.addPropertyChangeListener("enabled", this.propertyChangeListenerMock);
        AbstractSWTRidgetWithControlTest.assertTrue((boolean)markableRidget.isEnabled());
        this.expectNoPropertyChangeEvent();
        markableRidget.setEnabled(true);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("enabled", Boolean.TRUE, Boolean.FALSE);
        markableRidget.setEnabled(false);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        markableRidget.setEnabled(false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("enabled", Boolean.FALSE, Boolean.TRUE);
        markableRidget.setEnabled(true);
        this.verifyPropertyChangeEvents();
    }

    public void testFiresDisabledPropertyUsingAddRemove() {
        if (!(this.getRidget() instanceof IMarkableRidget)) {
            return;
        }
        IMarkableRidget markableRidget = (IMarkableRidget)this.getRidget();
        DisabledMarker marker = new DisabledMarker();
        markableRidget.removePropertyChangeListener(this.propertyChangeListenerMock);
        markableRidget.addPropertyChangeListener("enabled", this.propertyChangeListenerMock);
        AbstractSWTRidgetWithControlTest.assertTrue((boolean)markableRidget.isEnabled());
        this.expectPropertyChangeEvent("enabled", Boolean.TRUE, Boolean.FALSE);
        markableRidget.addMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        markableRidget.addMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("enabled", Boolean.FALSE, Boolean.TRUE);
        markableRidget.removeMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        markableRidget.removeMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
    }

    public void testDisableWithoutUIControl() {
        if (!(this.getRidget() instanceof IMarkableRidget)) {
            return;
        }
        IMarkableRidget markableRidget = (IMarkableRidget)this.getRidget();
        markableRidget.setUIControl(null);
        AbstractSWTRidgetWithControlTest.assertTrue((boolean)markableRidget.isEnabled());
        markableRidget.setEnabled(false);
        AbstractSWTRidgetWithControlTest.assertFalse((boolean)markableRidget.isEnabled());
        markableRidget.setEnabled(true);
        AbstractSWTRidgetWithControlTest.assertTrue((boolean)markableRidget.isEnabled());
    }

    public void testFiresOutputPropertyUsingSetter() {
        if (!(this.getRidget() instanceof IMarkableRidget)) {
            return;
        }
        IMarkableRidget markableRidget = (IMarkableRidget)this.getRidget();
        markableRidget.removePropertyChangeListener(this.propertyChangeListenerMock);
        markableRidget.addPropertyChangeListener("output", this.propertyChangeListenerMock);
        AbstractSWTRidgetWithControlTest.assertFalse((boolean)markableRidget.isOutputOnly());
        this.expectNoPropertyChangeEvent();
        markableRidget.setOutputOnly(false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("output", Boolean.FALSE, Boolean.TRUE);
        markableRidget.setOutputOnly(true);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        markableRidget.setOutputOnly(true);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("output", Boolean.TRUE, Boolean.FALSE);
        markableRidget.setOutputOnly(false);
        this.verifyPropertyChangeEvents();
    }

    public void testFiresOutputPropertyUsingAddRemove() {
        if (!(this.getRidget() instanceof IMarkableRidget)) {
            return;
        }
        IMarkableRidget markableRidget = (IMarkableRidget)this.getRidget();
        OutputMarker marker = new OutputMarker();
        markableRidget.removePropertyChangeListener(this.propertyChangeListenerMock);
        markableRidget.addPropertyChangeListener("output", this.propertyChangeListenerMock);
        AbstractSWTRidgetWithControlTest.assertFalse((boolean)markableRidget.isOutputOnly());
        this.expectPropertyChangeEvent("output", Boolean.FALSE, Boolean.TRUE);
        markableRidget.addMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        markableRidget.addMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("output", Boolean.TRUE, Boolean.FALSE);
        markableRidget.removeMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        markableRidget.removeMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
    }

    private PropertyChangeEvent createArgumentMatcher(PropertyChangeEvent propertyChangeEvent) {
        return PropertyChangeEventEquals.eqPropertyChangeEvent(propertyChangeEvent);
    }
}

