/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.beans.common.WordNode;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetLabelProvider;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

@NonUITestCase
public class TableRidgetLabelProviderTest
extends TestCase {
    private TableRidgetLabelProvider labelProvider;
    private WordNode elementA;
    private WordNode elementB;

    protected void setUp() throws Exception {
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        IObservableSet elements = this.createElements();
        String[] columnProperties = new String[]{"word", "upperCase"};
        IObservableMap[] attrMap = BeansObservables.observeMaps((IObservableSet)elements, WordNode.class, (String[])columnProperties);
        this.labelProvider = new TableRidgetLabelProvider(attrMap);
    }

    public void testGetText() {
        TableRidgetLabelProviderTest.assertEquals((String)"Alpha", (String)this.labelProvider.getText((Object)this.elementA));
        TableRidgetLabelProviderTest.assertEquals((String)"BRAVO", (String)this.labelProvider.getText((Object)this.elementB));
    }

    public void testGetColumnText() {
        TableRidgetLabelProviderTest.assertEquals((String)"Alpha", (String)this.labelProvider.getColumnText((Object)this.elementA, 0));
        TableRidgetLabelProviderTest.assertEquals((String)"BRAVO", (String)this.labelProvider.getColumnText((Object)this.elementB, 0));
        TableRidgetLabelProviderTest.assertEquals((String)"false", (String)this.labelProvider.getColumnText((Object)this.elementA, 1));
        TableRidgetLabelProviderTest.assertEquals((String)"true", (String)this.labelProvider.getColumnText((Object)this.elementB, 1));
        TableRidgetLabelProviderTest.assertEquals(null, (String)this.labelProvider.getColumnText((Object)this.elementA, 99));
    }

    public void testGetImage() {
        TableRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getImage((Object)this.elementA));
        TableRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getImage((Object)this.elementB));
        IObservableSet elements = this.createElements();
        String[] columnProperties = new String[]{"upperCase"};
        IObservableMap[] attrMap = BeansObservables.observeMaps((IObservableSet)elements, WordNode.class, (String[])columnProperties);
        this.labelProvider = new TableRidgetLabelProvider(attrMap);
        Image siUnchecked = Activator.getSharedImage((String)"IMG_UNCHECKED");
        TableRidgetLabelProviderTest.assertNotNull((Object)siUnchecked);
        TableRidgetLabelProviderTest.assertEquals((Object)siUnchecked, (Object)this.labelProvider.getImage((Object)this.elementA));
        Image siChecked = Activator.getSharedImage((String)"IMG_CHECKED");
        TableRidgetLabelProviderTest.assertNotNull((Object)siChecked);
        TableRidgetLabelProviderTest.assertEquals((Object)siChecked, (Object)this.labelProvider.getImage((Object)this.elementB));
        TableRidgetLabelProviderTest.assertNotSame((Object)siChecked, (Object)siUnchecked);
    }

    public void testGetColumnImage() {
        TableRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getColumnImage((Object)this.elementA, 0));
        TableRidgetLabelProviderTest.assertNull((Object)this.labelProvider.getColumnImage((Object)this.elementB, 0));
        Image siUnchecked = Activator.getSharedImage((String)"IMG_UNCHECKED");
        TableRidgetLabelProviderTest.assertNotNull((Object)siUnchecked);
        TableRidgetLabelProviderTest.assertEquals((Object)siUnchecked, (Object)this.labelProvider.getColumnImage((Object)this.elementA, 1));
        Image siChecked = Activator.getSharedImage((String)"IMG_CHECKED");
        TableRidgetLabelProviderTest.assertNotNull((Object)siChecked);
        TableRidgetLabelProviderTest.assertEquals((Object)siChecked, (Object)this.labelProvider.getColumnImage((Object)this.elementB, 1));
        TableRidgetLabelProviderTest.assertNotSame((Object)siChecked, (Object)siUnchecked);
        TableRidgetLabelProviderTest.assertEquals(null, (Object)this.labelProvider.getColumnImage((Object)this.elementA, 99));
    }

    private IObservableSet createElements() {
        ArrayList<WordNode> collection = new ArrayList<WordNode>();
        this.elementA = new WordNode("Alpha");
        this.elementB = new WordNode("Bravo");
        this.elementB.setUpperCase(true);
        collection.add(this.elementA);
        collection.add(this.elementB);
        WritableSet elements = new WritableSet(Realm.getDefault(), collection, WordNode.class);
        return elements;
    }
}

