/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation.tests;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.validation.ValidEmailAddress;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;

@NonUITestCase
public class ValidEmailAddressTest
extends RienaTestCase {
    public void testValidEmailAddress() throws Exception {
        ValidEmailAddress rule = new ValidEmailAddress();
        ValidEmailAddressTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidEmailAddressTest.assertTrue((boolean)rule.validate((Object)"").isOK());
        ValidEmailAddressTest.assertTrue((boolean)rule.validate((Object)"user@a.b.example").isOK());
        ValidEmailAddressTest.assertTrue((boolean)rule.validate((Object)"user@domain.de").isOK());
        ValidEmailAddressTest.assertTrue((boolean)rule.validate((Object)"user@xy.example.de").isOK());
        ValidEmailAddressTest.assertTrue((boolean)rule.validate((Object)"user@compeople.com").isOK());
        ValidEmailAddressTest.assertTrue((boolean)rule.validate((Object)"user@compeople.co.uk").isOK());
        ValidEmailAddressTest.assertTrue((boolean)rule.validate((Object)"user@[192.168.2.100]").isOK());
        ValidEmailAddressTest.assertTrue((boolean)rule.validate((Object)"user@#1234567890.example").isOK());
        ValidEmailAddressTest.assertTrue((boolean)rule.validate((Object)"ha@domain.example").isOK());
        ValidEmailAddressTest.assertTrue((boolean)rule.validate((Object)"\"basti\"@domain.example").isOK());
        ValidEmailAddressTest.assertTrue((boolean)rule.validate((Object)"\"ba\\,sti\"@domain.example").isOK());
        ValidEmailAddressTest.assertTrue((boolean)rule.validate((Object)"user.from.hell@domain.example").isOK());
        ValidEmailAddressTest.assertFalse((boolean)rule.validate((Object)"@domain.example").isOK());
        ValidEmailAddressTest.assertFalse((boolean)rule.validate((Object)"user@dom\"ain.example").isOK());
        ValidEmailAddressTest.assertFalse((boolean)rule.validate((Object)"user@dom ain.example").isOK());
        ValidEmailAddressTest.assertFalse((boolean)rule.validate((Object)"user@dom,ain.example").isOK());
        ValidEmailAddressTest.assertFalse((boolean)rule.validate((Object)"u\nser@domain.example").isOK());
        ValidEmailAddressTest.assertFalse((boolean)rule.validate((Object)"u\nser@domain.example").isOK());
        ValidEmailAddressTest.assertFalse((boolean)rule.validate((Object)"u\"nser@domain.example").isOK());
        ValidEmailAddressTest.assertFalse((boolean)rule.validate((Object)"u;ser@domain.example").isOK());
        ValidEmailAddressTest.assertFalse((boolean)rule.validate((Object)"us er@domain.example").isOK());
        ValidEmailAddressTest.assertFalse((boolean)rule.validate((Object)"user@").isOK());
        ValidEmailAddressTest.assertFalse((boolean)rule.validate((Object)"user@[xxx.xxx.xxx]").isOK());
        ValidEmailAddressTest.assertFalse((boolean)rule.validate((Object)"user@192.168.2.100").isOK());
        ValidEmailAddressTest.assertFalse((boolean)rule.validate((Object)"user@1234567").isOK());
        ValidEmailAddressTest.assertFalse((boolean)rule.validate((Object)"user@#1a2346").isOK());
    }

    public void testException() throws Exception {
        try {
            new ValidEmailAddress().validate(new Object());
            ValidEmailAddressTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
        catch (RuntimeException runtimeException) {
            ValidEmailAddressTest.fail((String)("expected a " + ValidationFailure.class.getName()));
        }
    }

    public void testValidEmailAddressSpecial() throws Exception {
        ValidEmailAddress rule = new ValidEmailAddress();
        ValidEmailAddressTest.assertFalse((boolean)rule.validate((Object)"user").isOK());
    }

    public void testDoesNotBlockInputWhenFailing() {
        ValidEmailAddress rule = new ValidEmailAddress();
        IStatus result = rule.validate((Object)"invalid");
        ValidEmailAddressTest.assertFalse((boolean)result.isOK());
        ValidEmailAddressTest.assertEquals((int)1025, (int)result.getCode());
    }
}

