/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.swt.IRienaDialog;
import org.eclipse.riena.ui.swt.RienaDialog;
import org.eclipse.riena.ui.swt.RienaDialogDelegate;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class RienaDialogDelegateTest
extends TestCase {
    private Shell shell;
    private RienaDialog dlg;
    private RienaDialogDelegate delegate;

    protected void setUp() throws Exception {
        this.shell = new Shell();
        this.dlg = new RienaDialog(this.shell);
        this.delegate = new RienaDialogDelegate((IRienaDialog)this.dlg);
    }

    protected void tearDown() throws Exception {
        this.delegate = null;
        this.dlg = null;
        SwtUtilities.disposeWidget((Widget)this.shell);
    }

    public void testEvaluateStyle() {
        this.dlg.setShellStyle(1232);
        ReflectionUtils.invokeHidden((Object)this.delegate, (String)"evaluateStyle", (Object[])new Object[0]);
        RienaDialogDelegateTest.assertTrue((boolean)this.delegate.isCloseable());
        RienaDialogDelegateTest.assertTrue((boolean)this.delegate.isMaximizeable());
        RienaDialogDelegateTest.assertTrue((boolean)this.delegate.isMinimizeable());
        RienaDialogDelegateTest.assertTrue((boolean)this.delegate.isResizeable());
        this.dlg.setShellStyle(64);
        ReflectionUtils.invokeHidden((Object)this.delegate, (String)"evaluateStyle", (Object[])new Object[0]);
        RienaDialogDelegateTest.assertTrue((boolean)this.delegate.isCloseable());
        RienaDialogDelegateTest.assertFalse((boolean)this.delegate.isMaximizeable());
        RienaDialogDelegateTest.assertFalse((boolean)this.delegate.isMinimizeable());
        RienaDialogDelegateTest.assertFalse((boolean)this.delegate.isResizeable());
        this.dlg.setShellStyle(1024);
        ReflectionUtils.invokeHidden((Object)this.delegate, (String)"evaluateStyle", (Object[])new Object[0]);
        RienaDialogDelegateTest.assertFalse((boolean)this.delegate.isCloseable());
        RienaDialogDelegateTest.assertTrue((boolean)this.delegate.isMaximizeable());
        RienaDialogDelegateTest.assertFalse((boolean)this.delegate.isMinimizeable());
        RienaDialogDelegateTest.assertFalse((boolean)this.delegate.isResizeable());
        this.dlg.setShellStyle(128);
        ReflectionUtils.invokeHidden((Object)this.delegate, (String)"evaluateStyle", (Object[])new Object[0]);
        RienaDialogDelegateTest.assertFalse((boolean)this.delegate.isCloseable());
        RienaDialogDelegateTest.assertFalse((boolean)this.delegate.isMaximizeable());
        RienaDialogDelegateTest.assertTrue((boolean)this.delegate.isMinimizeable());
        RienaDialogDelegateTest.assertFalse((boolean)this.delegate.isResizeable());
        this.dlg.setShellStyle(16);
        ReflectionUtils.invokeHidden((Object)this.delegate, (String)"evaluateStyle", (Object[])new Object[0]);
        RienaDialogDelegateTest.assertFalse((boolean)this.delegate.isCloseable());
        RienaDialogDelegateTest.assertFalse((boolean)this.delegate.isMaximizeable());
        RienaDialogDelegateTest.assertFalse((boolean)this.delegate.isMinimizeable());
        RienaDialogDelegateTest.assertTrue((boolean)this.delegate.isResizeable());
    }

    public void testUpdateDialogStyle() {
        this.delegate.setHideOsBorder(true);
        this.dlg.setShellStyle(67696);
        ReflectionUtils.invokeHidden((Object)this.delegate, (String)"updateDialogStyle", (Object[])new Object[0]);
        int style = this.dlg.getShellStyle();
        RienaDialogDelegateTest.assertFalse(((style & 0x860) == 2144 ? 1 : 0) != 0);
        RienaDialogDelegateTest.assertTrue(((style & 8) == 8 ? 1 : 0) != 0);
        RienaDialogDelegateTest.assertTrue(((style & 0x10) == 16 ? 1 : 0) != 0);
        RienaDialogDelegateTest.assertFalse(((style & 0x10000) == 65536 ? 1 : 0) != 0);
        this.delegate.setHideOsBorder(false);
        ReflectionUtils.invokeHidden((Object)this.delegate, (String)"setApplicationModal", (Object[])new Object[]{true});
        this.dlg.setShellStyle(2160);
        ReflectionUtils.invokeHidden((Object)this.delegate, (String)"updateDialogStyle", (Object[])new Object[0]);
        style = this.dlg.getShellStyle();
        RienaDialogDelegateTest.assertFalse(((style & 0x860) == 2144 ? 1 : 0) != 0);
        RienaDialogDelegateTest.assertTrue(((style & 0x10) == 16 ? 1 : 0) != 0);
        RienaDialogDelegateTest.assertTrue(((style & 0x10000) == 65536 ? 1 : 0) != 0);
    }
}

