/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.DetachedWindow;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.services.IServiceLocator;

public final class CurrentSelectionSourceProvider
extends AbstractSourceProvider
implements INullSelectionListener {
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"selection"};
    private IWorkbench workbench;
    private IWorkbenchWindow lastWindow = null;
    static /* synthetic */ Class class$0;

    public void handleCheck(Shell s) {
        IWorkbenchWindow window = null;
        if (s.getData() instanceof WorkbenchWindow) {
            window = (IWorkbenchWindow)s.getData();
        } else if (s.getData() instanceof DetachedWindow) {
            window = ((DetachedWindow)s.getData()).getWorkbenchPage().getWorkbenchWindow();
        }
        this.updateWindows(window);
    }

    public void dispose() {
    }

    public final Map getCurrentState() {
        TreeMap<String, Object> currentState = new TreeMap<String, Object>();
        IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
        if (window != null) {
            ISelectionService service = window.getSelectionService();
            ISelection selection = service.getSelection();
            currentState.put("selection", selection);
        } else {
            currentState.put("selection", IEvaluationContext.UNDEFINED_VARIABLE);
        }
        return currentState;
    }

    public final String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }

    public final void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (DEBUG) {
            this.logDebuggingInfo("Selection changed to " + selection);
        }
        this.fireSourceChanged(0x40000000, "selection", selection);
    }

    private final void updateWindows(IWorkbenchWindow newWindow) {
        if (this.lastWindow == newWindow) {
            return;
        }
        ISelection selection = null;
        if (this.lastWindow != null) {
            this.lastWindow.getSelectionService().removeSelectionListener(this);
        }
        if (newWindow != null) {
            newWindow.getSelectionService().addSelectionListener(this);
            selection = newWindow.getSelectionService().getSelection();
        }
        this.selectionChanged(null, selection);
        this.lastWindow = newWindow;
    }

    public void initialize(IServiceLocator locator) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.services.IWorkbenchLocationService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWorkbenchLocationService wls = (IWorkbenchLocationService)locator.getService(clazz);
        this.workbench = wls.getWorkbench();
    }
}

