/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.navigation.ui.filter.UIFilterRuleRidgetDisabledMarker;
import org.eclipse.riena.internal.navigation.ui.filter.UIFilterRuleRidgetHiddenMarker;
import org.eclipse.riena.internal.navigation.ui.filter.UIFilterRuleRidgetMandatoryMarker;
import org.eclipse.riena.internal.navigation.ui.filter.UIFilterRuleRidgetOutputMarker;
import org.eclipse.riena.internal.navigation.ui.filter.UIFilterRuleRidgetValidator;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeUtility;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.filter.IUIFilterRule;
import org.eclipse.riena.ui.filter.impl.UIFilter;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.validation.MaxLength;
import org.eclipse.riena.ui.ridgets.validation.MinLength;
import org.eclipse.riena.ui.ridgets.validation.ValidEmailAddress;

public class FilterSubModuleController
extends SubModuleController {
    private IComboRidget filterTypeValues;
    private IComboRidget globalFilterTypeValues;
    private FilterModel filterModel;
    private FilterModel globalFilterModel;
    private MarkerModel markerModel;
    private IActionRidget addFilter;
    private IActionRidget globalAddFilter;
    private IActionRidget addMarker;
    private IActionRidget removeMarker;
    private IMarker[] markers = new IMarker[]{new ErrorMarker(), new MandatoryMarker(), new HiddenMarker(), new OutputMarker(), new DisabledMarker()};

    public void afterBind() {
        super.afterBind();
        this.initMarkerGroup();
        this.initLocalFilterGroup();
        this.initGlobalFilterGroup();
        this.rebindFilterTypeValues(this.filterModel, this.filterTypeValues, this.addFilter);
        this.rebindFilterTypeValues(this.globalFilterModel, this.globalFilterTypeValues, this.globalAddFilter);
    }

    private void initMarkerGroup() {
        IComboRidget ridgetToMarkID = (IComboRidget)this.getRidget("ridgetToMarkID");
        this.markerModel = new MarkerModel();
        ridgetToMarkID.bindToModel((Object)this.markerModel, "ids", MarkerModel.class, null, (Object)this.markerModel, "selectedId");
        ridgetToMarkID.updateFromModel();
        IComboRidget markersCombo = (IComboRidget)this.getRidget("markers");
        markersCombo.bindToModel((Object)this.markerModel, "markers", MarkerModel.class, null, (Object)this.markerModel, "selectedMarker");
        markersCombo.updateFromModel();
        this.addMarker = (IActionRidget)this.getRidget("addMarker");
        this.addMarker.addListener(new IActionListener(){

            public void callback() {
                FilterSubModuleController.this.doAddMarker();
            }
        });
        this.removeMarker = (IActionRidget)this.getRidget("removeMarker");
        this.removeMarker.addListener(new IActionListener(){

            public void callback() {
                FilterSubModuleController.this.doRemoveMarker();
            }
        });
    }

    private void initLocalFilterGroup() {
        IComboRidget ridgetID = (IComboRidget)this.getRidget("ridgetID");
        this.filterModel = new FilterModel();
        ridgetID.bindToModel((Object)this.filterModel, "ids", FilterModel.class, null, (Object)this.filterModel, "selectedId");
        ridgetID.updateFromModel();
        ISingleChoiceRidget filterType = (ISingleChoiceRidget)this.getRidget("filterType");
        filterType.addPropertyChangeListener((PropertyChangeListener)new FilterTypeChangeListener());
        filterType.bindToModel((Object)this.filterModel, "types", (Object)this.filterModel, "selectedType");
        filterType.updateFromModel();
        this.filterTypeValues = (IComboRidget)this.getRidget("filterTypeValues");
        this.filterTypeValues.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (FilterSubModuleController.this.addFilter != null) {
                    FilterSubModuleController.this.addFilter.setEnabled(evt.getNewValue() != null);
                }
            }
        });
        this.addFilter = (IActionRidget)this.getRidget("addFilter");
        this.addFilter.addListener(new IActionListener(){

            public void callback() {
                FilterSubModuleController.this.doAddFilter();
            }
        });
        IActionRidget removeFilters = (IActionRidget)this.getRidget("removeFilters");
        removeFilters.addListener(new IActionListener(){

            public void callback() {
                FilterSubModuleController.this.doRemoveFilters();
            }
        });
    }

    private void initGlobalFilterGroup() {
        ITextRidget ridgetID = (ITextRidget)this.getRidget("globalRidgetID");
        this.globalFilterModel = new FilterModel();
        ridgetID.bindToModel((Object)this.globalFilterModel, "selectedId");
        ridgetID.updateFromModel();
        ISingleChoiceRidget filterType = (ISingleChoiceRidget)this.getRidget("globalFilterType");
        filterType.addPropertyChangeListener((PropertyChangeListener)new FilterTypeChangeListener());
        filterType.bindToModel((Object)this.globalFilterModel, "types", (Object)this.globalFilterModel, "selectedType");
        filterType.updateFromModel();
        this.globalFilterTypeValues = (IComboRidget)this.getRidget("globalFilterTypeValues");
        this.globalFilterTypeValues.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (FilterSubModuleController.this.globalAddFilter != null) {
                    FilterSubModuleController.this.globalAddFilter.setEnabled(evt.getNewValue() != null);
                }
            }
        });
        this.globalAddFilter = (IActionRidget)this.getRidget("globalAddFilter");
        this.globalAddFilter.addListener(new IActionListener(){

            public void callback() {
                FilterSubModuleController.this.doGlobalAddFilter();
            }
        });
        IActionRidget removeFilters = (IActionRidget)this.getRidget("globalRemoveFilters");
        removeFilters.addListener(new IActionListener(){

            public void callback() {
                FilterSubModuleController.this.doGlobalRemoveFilters();
            }
        });
    }

    private void doAddFilter() {
        ArrayList<IUIFilterRule> attributes = new ArrayList<IUIFilterRule>(1);
        attributes.add(this.createFilterRule(this.filterModel, true));
        UIFilter filter = new UIFilter(attributes);
        ((ISubModuleNode)this.getNavigationNode()).addFilter((IUIFilter)filter);
    }

    private void doGlobalAddFilter() {
        ArrayList<IUIFilterRule> attributes = new ArrayList<IUIFilterRule>(1);
        attributes.add(this.createFilterRule(this.globalFilterModel, false));
        UIFilter filter = new UIFilter(attributes);
        IApplicationNode applNode = (IApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IApplicationNode.class);
        applNode.addFilter((IUIFilter)filter);
    }

    private IUIFilterRule createFilterRule(FilterModel model, boolean local) {
        UIFilterRuleRidgetOutputMarker attribute = null;
        String id = model.getSelectedId();
        if (local) {
            INavigationNode node = this.getNavigationNode();
            id = String.valueOf(NavigationNodeUtility.getNodeLongId((INavigationNode)node)) + "/" + id;
        } else {
            id = "*/" + id;
        }
        Object filterValue = model.getSelectedFilterTypeValue();
        FilterType type = model.getSelectedType();
        if (type == FilterType.MARKER) {
            if (filterValue instanceof OutputMarker) {
                attribute = new UIFilterRuleRidgetOutputMarker(id);
            } else if (filterValue instanceof DisabledMarker) {
                attribute = new UIFilterRuleRidgetDisabledMarker(id);
            } else if (filterValue instanceof MandatoryMarker) {
                attribute = new UIFilterRuleRidgetMandatoryMarker(id);
            } else if (filterValue instanceof HiddenMarker) {
                attribute = new UIFilterRuleRidgetHiddenMarker(id);
            }
        } else if (type == FilterType.VALIDATOR && filterValue instanceof IValidator) {
            attribute = new UIFilterRuleRidgetValidator(id, (IValidator)filterValue, ValidationTime.ON_UI_CONTROL_EDIT);
        }
        return attribute;
    }

    private void doRemoveFilters() {
        ((ISubModuleNode)this.getNavigationNode()).removeAllFilters();
    }

    private void doGlobalRemoveFilters() {
        IApplicationNode applNode = (IApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IApplicationNode.class);
        applNode.removeAllFilters();
    }

    private void rebindFilterTypeValues(FilterModel model, IComboRidget typeValues, IActionRidget add) {
        if (model == null) {
            return;
        }
        model.setSelectedFilterTypeValue(null);
        if (typeValues != null) {
            typeValues.bindToModel((IObservableList)new WritableList(Arrays.asList(model.getSelectedType().getArgs()), Object.class), FilterModel.class, null, BeansObservables.observeValue((Object)model, (String)"selectedFilterTypeValue"));
            typeValues.updateFromModel();
        }
        if (add != null) {
            add.setEnabled(model.getSelectedFilterTypeValue() != null);
        }
    }

    private void doAddMarker() {
        if (this.markerModel.getSelectedId() != null) {
            IMarkableRidget ridget = (IMarkableRidget)this.getRidget(this.markerModel.getSelectedId());
            ridget.addMarker(this.markerModel.getSelectedMarker().getMarker());
        }
    }

    private void doRemoveMarker() {
        if (this.markerModel.getSelectedId() != null) {
            IMarkableRidget ridget = (IMarkableRidget)this.getRidget(this.markerModel.getSelectedId());
            ridget.removeMarker(this.markerModel.getSelectedMarker().getMarker());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractModel {
        private List<String> ids;
        private String selectedId;

        private AbstractModel() {
        }

        public List<String> getIds() {
            if (this.ids == null) {
                this.ids = new ArrayList<String>();
                Collection ridgets = FilterSubModuleController.this.getRidgets();
                for (IRidget ridget : ridgets) {
                    if (ridget.getID() == null || !ridget.getID().startsWith("ui_")) continue;
                    this.ids.add(ridget.getID());
                }
            }
            return this.ids;
        }

        public void setSelectedId(String selectedId) {
            this.selectedId = selectedId;
        }

        public String getSelectedId() {
            if (this.selectedId == null) {
                this.selectedId = this.getIds().get(0);
            }
            return this.selectedId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterModel
    extends AbstractModel {
        private List<FilterType> types;
        private FilterType selectedType;
        private Object selectedFilterTypeValue;

        private FilterModel() {
        }

        public List<FilterType> getTypes() {
            if (this.types == null) {
                this.types = new ArrayList<FilterType>();
                this.types.add(FilterType.MARKER);
                this.types.add(FilterType.VALIDATOR);
            }
            return this.types;
        }

        public void setSelectedType(FilterType selectedType) {
            this.selectedType = selectedType;
        }

        public FilterType getSelectedType() {
            if (this.selectedType == null) {
                this.selectedType = this.getTypes().get(0);
            }
            return this.selectedType;
        }

        public void setSelectedFilterTypeValue(Object selectedFilterTypeValue) {
            this.selectedFilterTypeValue = selectedFilterTypeValue;
        }

        public Object getSelectedFilterTypeValue() {
            return this.selectedFilterTypeValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FilterType {
        MARKER("Marker", new MandatoryMarker(), new HiddenMarker(), new OutputMarker(), new DisabledMarker()),
        VALIDATOR("Validator", new MinLength(3), new MaxLength(10), new ValidEmailAddress());

        private String text;
        private Object[] args;

        private FilterType(String text, Object ... args) {
            this.text = text;
            this.args = args;
        }

        public String toString() {
            return this.text;
        }

        public Object[] getArgs() {
            return this.args;
        }
    }

    private class FilterTypeChangeListener
    implements PropertyChangeListener {
        private FilterTypeChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            FilterSubModuleController.this.rebindFilterTypeValues(FilterSubModuleController.this.filterModel, FilterSubModuleController.this.filterTypeValues, FilterSubModuleController.this.addFilter);
            FilterSubModuleController.this.rebindFilterTypeValues(FilterSubModuleController.this.globalFilterModel, FilterSubModuleController.this.globalFilterTypeValues, FilterSubModuleController.this.globalAddFilter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MarkerModel
    extends AbstractModel {
        private MarkerWrapper selectedMarker;
        private List<MarkerWrapper> markerWrappers;

        private MarkerModel() {
        }

        public void setSelectedMarker(MarkerWrapper selectedMarker) {
            this.selectedMarker = selectedMarker;
        }

        public MarkerWrapper getSelectedMarker() {
            return this.selectedMarker;
        }

        public List<MarkerWrapper> getMarkers() {
            if (this.markerWrappers == null) {
                this.markerWrappers = new ArrayList<MarkerWrapper>(FilterSubModuleController.this.markers.length);
                IMarker[] iMarkerArray = FilterSubModuleController.this.markers;
                int n = iMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    this.markerWrappers.add(new MarkerWrapper(marker));
                    ++n2;
                }
                this.setSelectedMarker(this.markerWrappers.get(0));
            }
            return this.markerWrappers;
        }
    }

    private static class MarkerWrapper {
        private IMarker marker;

        public MarkerWrapper(IMarker marker) {
            this.marker = marker;
        }

        public IMarker getMarker() {
            return this.marker;
        }

        public String toString() {
            if (this.getMarker() == null) {
                return "";
            }
            return this.getMarker().getClass().getSimpleName();
        }
    }
}

