/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.app.client.rcpmail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.WordNode;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.sample.app.client.rcpmail.TestBean;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.IGroupedTreeTableRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IMultipleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.ridgets.ITreeRidget;
import org.eclipse.riena.ui.ridgets.tree2.ITreeNode;
import org.eclipse.riena.ui.ridgets.tree2.TreeNode;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;

public class MarkerSubModuleController
extends SubModuleController {
    public void configureRidgets() {
        final ITextRidget textName = (ITextRidget)this.getRidget("textName");
        textName.setText("Chateau Schaedelbrummer");
        final ITextRidget textPrice = (ITextRidget)this.getRidget("textPrice");
        textPrice.addMarker((IMarker)new NegativeMarker());
        textPrice.setText("-29,99");
        final IComboRidget comboAge = (IComboRidget)this.getRidget("comboAge");
        List<String> ages = Arrays.asList("<none>", "young", "moderate", "aged", "old");
        comboAge.bindToModel((IObservableList)new WritableList(ages, String.class), String.class, null, (IObservableValue)new WritableValue());
        comboAge.updateFromModel();
        comboAge.setEmptySelectionItem((Object)"<none>");
        comboAge.setSelection(1);
        final ISingleChoiceRidget choiceType = (ISingleChoiceRidget)this.getRidget("choiceType");
        choiceType.bindToModel(Arrays.asList("red", "white", "rose"), null, (Object)new TestBean(), "property");
        choiceType.updateFromModel();
        choiceType.setSelection((Object)"red");
        final IMultipleChoiceRidget choiceFlavor = (IMultipleChoiceRidget)this.getRidget("choiceFlavor");
        choiceFlavor.bindToModel(Arrays.asList("dry", "sweet", "sour", "spicy"), null, (Object)new TestBean(), "property");
        choiceFlavor.updateFromModel();
        choiceFlavor.setSelection(Arrays.asList("dry"));
        final ITableRidget listPersons = (ITableRidget)this.getRidget("listPersons");
        listPersons.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        listPersons.bindToModel((IObservableList)this.createPersonList(), Person.class, new String[]{"listEntry"}, new String[]{""});
        listPersons.updateFromModel();
        final ITableRidget tablePersons = (ITableRidget)this.getRidget("tablePersons");
        tablePersons.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        String[] colValues = new String[]{"lastname", "firstname"};
        String[] colHeaders = new String[]{"Last Name", "First Name"};
        tablePersons.bindToModel((IObservableList)this.createPersonList(), Person.class, colValues, colHeaders);
        tablePersons.updateFromModel();
        final ITreeRidget treePersons = (ITreeRidget)this.getRidget("treePersons");
        treePersons.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        treePersons.bindToModel((Object[])this.createTreeRoots(), ITreeNode.class, "children", "parent", "value");
        treePersons.updateFromModel();
        final IGroupedTreeTableRidget treeWCols = (IGroupedTreeTableRidget)this.getRidget("treeWCols");
        treeWCols.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        treeWCols.setGroupingEnabled(true);
        colValues = new String[]{"word", "ACount"};
        colHeaders = new String[]{"Word", "#A"};
        treeWCols.bindToModel((Object[])this.createTreeTableRoots(), WordNode.class, "children", "parent", colValues, colHeaders);
        treeWCols.updateFromModel();
        final IToggleButtonRidget buttonToggle = (IToggleButtonRidget)this.getRidget("buttonToggle");
        buttonToggle.setText("Toggle");
        buttonToggle.setSelected(true);
        IActionRidget buttonPush = (IActionRidget)this.getRidget("buttonPush");
        final IToggleButtonRidget buttonRadioA = (IToggleButtonRidget)this.getRidget("buttonRadioA");
        final IToggleButtonRidget buttonRadioB = (IToggleButtonRidget)this.getRidget("buttonRadioB");
        final IToggleButtonRidget buttonCheck = (IToggleButtonRidget)this.getRidget("buttonCheck");
        final IMarkableRidget[] markables = new IMarkableRidget[]{textName, textPrice, comboAge, choiceType, choiceFlavor, listPersons, tablePersons, treePersons, treeWCols, buttonToggle, buttonPush, buttonRadioA, buttonRadioB, buttonCheck};
        final IToggleButtonRidget checkMandatory = (IToggleButtonRidget)this.getRidget("checkMandatory");
        final IToggleButtonRidget checkError = (IToggleButtonRidget)this.getRidget("checkError");
        final IToggleButtonRidget checkDisabled = (IToggleButtonRidget)this.getRidget("checkDisabled");
        final IToggleButtonRidget checkOutput = (IToggleButtonRidget)this.getRidget("checkOutput");
        final IToggleButtonRidget checkHidden = (IToggleButtonRidget)this.getRidget("checkHidden");
        checkMandatory.setText("&mandatory");
        checkMandatory.addListener(new IActionListener(){

            public void callback() {
                boolean isMandatory = checkMandatory.isSelected();
                IMarkableRidget[] iMarkableRidgetArray = markables;
                int n = markables.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarkableRidget ridget = iMarkableRidgetArray[n2];
                    ridget.setMandatory(isMandatory);
                    ++n2;
                }
                if (isMandatory) {
                    textName.setText("");
                    textPrice.setText("");
                    comboAge.setSelection((Object)"<none>");
                    choiceType.setSelection(null);
                    choiceFlavor.setSelection(null);
                    listPersons.setSelection(null);
                    tablePersons.setSelection(null);
                    treePersons.setSelection(null);
                    treeWCols.setSelection(null);
                    buttonToggle.setSelected(false);
                    buttonRadioA.setSelected(false);
                    buttonRadioB.setSelected(false);
                    buttonCheck.setSelected(false);
                }
            }
        });
        checkError.setText("&error");
        checkError.addListener(new IActionListener(){
            private IValidator alwaysWrong = new AlwaysWrongValidator();

            public void callback() {
                boolean isError = checkError.isSelected();
                IMarkableRidget[] iMarkableRidgetArray = markables;
                int n = markables.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarkableRidget ridget = iMarkableRidgetArray[n2];
                    ridget.setErrorMarked(isError);
                    ++n2;
                }
                if (isError) {
                    textName.addValidationRule(this.alwaysWrong, ValidationTime.ON_UI_CONTROL_EDIT);
                    textPrice.addValidationRule(this.alwaysWrong, ValidationTime.ON_UI_CONTROL_EDIT);
                } else {
                    textName.removeValidationRule(this.alwaysWrong);
                    textPrice.removeValidationRule(this.alwaysWrong);
                }
            }
        });
        checkDisabled.setText("&disabled");
        checkDisabled.addListener(new IActionListener(){

            public void callback() {
                boolean isEnabled = !checkDisabled.isSelected();
                IMarkableRidget[] iMarkableRidgetArray = markables;
                int n = markables.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarkableRidget ridget = iMarkableRidgetArray[n2];
                    ridget.setEnabled(isEnabled);
                    ++n2;
                }
            }
        });
        checkOutput.setText("&output");
        checkOutput.addListener(new IActionListener(){

            public void callback() {
                boolean isOutput = checkOutput.isSelected();
                IMarkableRidget[] iMarkableRidgetArray = markables;
                int n = markables.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarkableRidget ridget = iMarkableRidgetArray[n2];
                    ridget.setOutputOnly(isOutput);
                    ++n2;
                }
            }
        });
        checkHidden.setText("&hidden");
        checkHidden.addListener(new IActionListener(){

            public void callback() {
                boolean isVisible = !checkHidden.isSelected();
                IMarkableRidget[] iMarkableRidgetArray = markables;
                int n = markables.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarkableRidget ridget = iMarkableRidgetArray[n2];
                    ridget.setVisible(isVisible);
                    ++n2;
                }
            }
        });
    }

    private WritableList createPersonList() {
        ArrayList<Person> personList = new ArrayList<Person>();
        personList.add(new Person("Albinus", "Albert"));
        personList.add(new Person("Aurelius", "Mark"));
        personList.add(new Person("Adjunctus", "Maximus"));
        return new WritableList(personList, Person.class);
    }

    private ITreeNode[] createTreeRoots() {
        TreeNode rootA = new TreeNode((Object)"A");
        new TreeNode((ITreeNode)rootA, (Object)new Person("Albinus", "Albert"));
        new TreeNode((ITreeNode)rootA, (Object)new Person("Aurelius", "Mark"));
        TreeNode rootB = new TreeNode((Object)"B");
        new TreeNode((ITreeNode)rootB, (Object)new Person("Barker", "Clyve"));
        new TreeNode((ITreeNode)rootB, (Object)new Person("Barclay", "Bob"));
        return new ITreeNode[]{rootA, rootB};
    }

    private WordNode[] createTreeTableRoots() {
        WordNode rootA = new WordNode("A");
        WordNode rootB = new WordNode("B");
        new WordNode(rootA, "Astoria");
        new WordNode(rootA, "Ashland");
        new WordNode(rootA, "Aurora");
        new WordNode(rootA, "Alpine");
        new WordNode(rootB, "Boring");
        new WordNode(rootB, "Bend");
        new WordNode(rootB, "Beaverton");
        new WordNode(rootB, "Bridgeport");
        return new WordNode[]{rootA, rootB};
    }

    private static final class AlwaysWrongValidator
    implements IValidator {
        private AlwaysWrongValidator() {
        }

        public IStatus validate(Object value) {
            return ValidationRuleStatus.error((boolean)false, (String)"", (IValidator)this);
        }
    }
}

