/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.logging;

import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.logging.ILogCatcher;
import org.eclipse.riena.core.service.ServiceInjector;
import org.eclipse.riena.internal.core.Activator;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class LogServiceLogCatcher
implements ILogCatcher,
LogListener {
    private ServiceInjector logReaderInjector = null;

    public void attach() {
        this.logReaderInjector = Inject.service(LogReaderService.class).useRanking().into(this).andStart(Activator.getDefault().getContext());
    }

    public void detach() {
        if (this.logReaderInjector == null) {
            return;
        }
        this.logReaderInjector.stop();
    }

    public void bind(LogReaderService logReaderService) {
        if (logReaderService instanceof ExtendedLogReaderService) {
            return;
        }
        logReaderService.addLogListener((LogListener)this);
    }

    public void unbind(LogReaderService logReaderService) {
        if (logReaderService instanceof ExtendedLogReaderService) {
            return;
        }
        logReaderService.removeLogListener((LogListener)this);
    }

    public void logged(LogEntry entry) {
        Activator.getDefault().getLogger("Bundle " + entry.getBundle()).log(entry.getServiceReference(), entry.getLevel(), entry.getMessage(), entry.getException());
    }
}

