/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.internal.core.Activator;

public final class VariableManagerUtil {
    private static final Logger LOGGER = Activator.getDefault().getLogger(VariableManagerUtil.class);

    private VariableManagerUtil() {
    }

    public static String substitute(String expression) throws CoreException {
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        return variableManager.performStringSubstitution(expression);
    }

    public static void addVariable(String key, String value) throws CoreException {
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        IValueVariable[] variables = new IValueVariable[]{variableManager.newValueVariable(key, null, true, value)};
        try {
            variableManager.addVariables(variables);
        }
        catch (CoreException e) {
            IValueVariable existingValue = variableManager.getValueVariable(key);
            if (existingValue.getValue().equals(value)) {
                LOGGER.log(2, "Already defined: (" + key + "," + value + ")");
            }
            throw e;
        }
    }

    public static void removeVariable(String key) {
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        IValueVariable[] variables = new IValueVariable[]{variableManager.newValueVariable(key, null, true, null)};
        variableManager.removeVariables(variables);
    }
}

