/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.ridgets.AbstractRidget;
import org.eclipse.riena.ui.ridgets.IComplexRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.UIBindingFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompositeRidget
extends AbstractRidget
implements IComplexRidget {
    private IComplexComponent uiControl;
    private Map<String, IRidget> ridgets = new HashMap<String, IRidget>();
    private PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();
    protected boolean visible = true;
    private String toolTip = null;
    private boolean blocked;

    @Override
    public boolean isVisible() {
        return this.uiControl != null && this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            this.updateVisible();
        }
    }

    public IComplexComponent getUIControl() {
        return this.uiControl;
    }

    @Override
    public void setUIControl(Object uiControl) {
        if (uiControl != null && !(uiControl instanceof IComplexComponent)) {
            throw new UIBindingFailure("uiControl of a AbstractCompositeRidget must be a IComplexComponent but was a " + uiControl.getClass().getSimpleName());
        }
        this.uiControl = (IComplexComponent)uiControl;
        this.updateVisible();
    }

    @Override
    public void addRidget(String id, IRidget ridget) {
        ridget.addPropertyChangeListener(this.propertyChangeListener);
        this.ridgets.put(id, ridget);
    }

    @Override
    public IRidget getRidget(String id) {
        return this.ridgets.get(id);
    }

    @Override
    public Collection<? extends IRidget> getRidgets() {
        return this.ridgets.values();
    }

    @Override
    public void requestFocus() {
        if (!this.getRidgets().isEmpty()) {
            this.getRidgets().iterator().next().requestFocus();
        }
    }

    @Override
    public boolean hasFocus() {
        Collection<? extends IRidget> myRidgets = this.getRidgets();
        for (IRidget iRidget : myRidgets) {
            if (!iRidget.hasFocus()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
        Collection<? extends IRidget> r = this.getRidgets();
        for (IRidget iRidget : r) {
            iRidget.setFocusable(focusable);
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public String getToolTipText() {
        return this.toolTip;
    }

    @Override
    public void setToolTipText(String toolTipText) {
        String oldValue = this.toolTip;
        this.toolTip = toolTipText;
        this.updateToolTipText();
        this.firePropertyChange("tooltip", oldValue, this.toolTip);
    }

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public void setBlocked(boolean blocked) {
        Collection<? extends IRidget> r = this.getRidgets();
        for (IRidget iRidget : r) {
            iRidget.setBlocked(blocked);
        }
    }

    @Override
    public void configureRidgets() {
    }

    @Override
    public String getID() {
        return null;
    }

    protected void updateVisible() {
        if (this.uiControl != null && this.uiControl instanceof Component) {
            ((Component)this.uiControl).setVisible(this.visible);
        }
    }

    protected void updateToolTipText() {
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractCompositeRidget.this.propertyChangeSupport.firePropertyChange(evt);
        }
    }
}

