/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.uibinding;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.ReflectionFailure;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.ridgets.IComplexRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingPropertyLocator;
import org.eclipse.riena.ui.ridgets.uibinding.IControlRidgetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBindingManager
implements IBindingManager {
    private IBindingPropertyLocator propertyStrategy;
    private IControlRidgetMapper<Object> mapper;

    public DefaultBindingManager(IBindingPropertyLocator propertyStrategy, IControlRidgetMapper<Object> mapper) {
        this.propertyStrategy = propertyStrategy;
        this.mapper = mapper;
    }

    @Override
    public void injectRidgets(IRidgetContainer ridgetContainer, List<Object> uiControls) {
        for (Object control : uiControls) {
            String bindingProperty = this.propertyStrategy.locateBindingProperty(control);
            if (bindingProperty == null) continue;
            IRidget ridget = this.createRidget(control);
            this.injectRidget(ridgetContainer, bindingProperty, ridget);
            if (!(control instanceof IComplexComponent)) continue;
            IComplexRidget complexRidget = (IComplexRidget)ridget;
            IComplexComponent complexComponent = (IComplexComponent)control;
            this.injectRidgets(complexRidget, complexComponent.getUIControls());
        }
        ridgetContainer.configureRidgets();
    }

    protected void injectRidget(IRidgetContainer ridgetContainer, String bindingProperty, IRidget ridget) {
        ridgetContainer.addRidget(bindingProperty, ridget);
    }

    @Override
    public IRidget createRidget(Object control) throws ReflectionFailure {
        Class<IRidget> ridgetClass = this.mapper.getRidgetClass(control);
        return (IRidget)ReflectionUtils.newInstance(ridgetClass, (Object[])new Object[0]);
    }

    protected IRidget getRidget(String bindingProperty, IRidgetContainer controller) {
        return controller.getRidget(bindingProperty);
    }

    @Override
    public void bind(IRidgetContainer controller, List<Object> uiControls) {
        this.updateBindings(controller, uiControls, false);
    }

    @Override
    public void unbind(IRidgetContainer controller, List<Object> uiControls) {
        this.updateBindings(controller, uiControls, true);
    }

    private void updateBindings(IRidgetContainer controller, List<Object> uiControls, boolean unbind) {
        for (Object control : uiControls) {
            if (control instanceof IComplexComponent) {
                IComplexComponent complexComponent = (IComplexComponent)control;
                String bindingProperty = this.propertyStrategy.locateBindingProperty(control);
                IComplexRidget complexRidget = (IComplexRidget)this.getRidget(bindingProperty, controller);
                this.updateBindings(complexRidget, complexComponent.getUIControls(), unbind);
                if (complexRidget == null) continue;
                this.bindRidget(complexRidget, complexComponent, unbind);
                continue;
            }
            String bindingProperty = this.propertyStrategy.locateBindingProperty(control);
            if (bindingProperty == null) continue;
            IRidget ridget = this.getRidget(bindingProperty, controller);
            Assert.isNotNull((Object)ridget, (String)("Null ridget for property: " + bindingProperty));
            this.bindRidget(ridget, control, unbind);
        }
    }

    private void bindRidget(IRidget ridget, Object uiControl, boolean unbind) {
        if (unbind) {
            ridget.setUIControl(null);
        } else {
            ridget.setUIControl(uiControl);
        }
    }
}

