/*******************************************************************************
 * Copyright (c) 2007, 2008 compeople AG and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    compeople AG - initial API and implementation
 *******************************************************************************/
package org.eclipse.riena.ui.workarea.spi;

import org.eclipse.riena.ui.workarea.IWorkareaDefinition;

public interface IWorkareaDefinitionRegistry {

	IWorkareaDefinition getDefinition(Object id);

	/**
	 * Registers the specified workarea definition with the specified typeId.
	 * 
	 * @param id
	 *            The typeId.
	 * @param definition
	 *            A workarea definition.
	 * @return The registered workarea definition or null, if the workarea
	 *         definition could not be registered by this registry.
	 */
	IWorkareaDefinition register(Object id, IWorkareaDefinition definition);
}
