/*******************************************************************************
 * Copyright (c) 2007, 2008 compeople AG and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    compeople AG - initial API and implementation
 *******************************************************************************/
package org.eclipse.riena.ui.ridgets.validation;

import org.eclipse.core.runtime.IStatus;

/**
 * Result of a validation performed by an IValidationRule. Extends the IStatus
 * by adding some specific code for validation of Ridgets.
 */
public interface IValidationRuleStatus extends IStatus {

	/**
	 * Status code indicating that the effects of the last edit that was
	 * verified must be undone and that the UI-control must be marked with a
	 * temporary ErrorMarker.
	 * 
	 * @see IStatus#getCode()
	 */
	int ERROR_BLOCK_WITH_FLASH = 1024;

	/**
	 * Status code indicating that the effects of the last edit that was
	 * verified should be allowed for the UI-control. The UI-control must be
	 * marked with an ErrorMarker until the next validation.
	 * 
	 * @see IStatus#getCode()
	 */
	int ERROR_ALLOW_WITH_MESSAGE = 1025;

}
