/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.riena.ui.swt.MessageBox;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class UIControlsFactory {
    public static final String KEY_TYPE = "type";
    public static final String TYPE_NUMERIC = "numeric";
    public static final String TYPE_DECIMAL = "decimal";
    public static final String TYPE_DATE = "date";
    private static final Color SHARED_BG_COLOR = LnfManager.getLnf().getColor("SubModule.background");

    static {
        Assert.isNotNull((Object)SHARED_BG_COLOR);
    }

    private UIControlsFactory() {
    }

    public static Label createLabel(Composite parent, String caption) {
        return UIControlsFactory.createLabel(parent, caption, 0);
    }

    public static Label createLabel(Composite parent, String caption, int style) {
        Label label = new Label(parent, style);
        label.setText(caption);
        label.setBackground(SHARED_BG_COLOR);
        return label;
    }

    public static Text createText(Composite parent) {
        return new Text(parent, 2052);
    }

    public static Text createText(Composite parent, int style) {
        return new Text(parent, style | 0x800);
    }

    public static Text createTextDate(Composite parent) {
        Text result = new Text(parent, 133124);
        result.setData(KEY_TYPE, (Object)TYPE_DATE);
        return result;
    }

    public static Text createTextDecimal(Composite parent) {
        Text result = new Text(parent, 133124);
        result.setData(KEY_TYPE, (Object)TYPE_DECIMAL);
        return result;
    }

    public static Text createTextNumeric(Composite parent) {
        Text result = new Text(parent, 133124);
        result.setData(KEY_TYPE, (Object)TYPE_NUMERIC);
        return result;
    }

    public static Text createTextOutput(Composite parent) {
        Text text = new Text(parent, 2056);
        text.setEditable(false);
        text.setEnabled(false);
        return text;
    }

    public static Text createTextMulti(Composite parent, boolean hScroll, boolean vScroll) {
        int style = 2050;
        if (hScroll) {
            style |= 0x100;
        }
        if (vScroll) {
            style |= 0x200;
        }
        return new Text(parent, style);
    }

    public static Button createButton(Composite parent) {
        return new Button(parent, 8);
    }

    public static Button createButtonToggle(Composite parent) {
        return new Button(parent, 2);
    }

    public static Button createButtonCheck(Composite parent) {
        Button button = new Button(parent, 32);
        button.setBackground(SHARED_BG_COLOR);
        return button;
    }

    public static Button createButtonRadio(Composite parent) {
        Button button = new Button(parent, 16);
        button.setBackground(SHARED_BG_COLOR);
        return button;
    }

    public static Combo createCombo(Composite parent) {
        return new Combo(parent, 2060);
    }

    public static Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(SHARED_BG_COLOR);
        return composite;
    }

    public static Group createGroup(Composite parent, String caption) {
        Group group = new Group(parent, 0);
        group.setText(caption);
        group.setBackground(SHARED_BG_COLOR);
        return group;
    }

    public static List createList(Composite parent, boolean hScroll, boolean vScroll) {
        int style = 2050;
        if (hScroll) {
            style |= 0x100;
        }
        if (vScroll) {
            style |= 0x200;
        }
        return new List(parent, style);
    }

    public static Shell createShell(Display display) {
        Assert.isNotNull((Object)display);
        Shell shell = new Shell(display);
        shell.setBackground(SHARED_BG_COLOR);
        return shell;
    }

    public static int getWidthHint(Button button) {
        GC gc = new GC((Drawable)button.getDisplay());
        try {
            FontMetrics fm = gc.getFontMetrics();
            int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fm, (int)61);
            Point minSize = button.computeSize(-1, -1, true);
            int n = Math.max(widthHint, minSize.x);
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    public static int getWidthHint(Text text, int numChars) {
        GC gc = new GC((Drawable)text.getDisplay());
        try {
            FontMetrics fm = gc.getFontMetrics();
            int widthHint = fm.getAverageCharWidth() * numChars;
            Point minSize = text.computeSize(-1, -1, true);
            int n = Math.max(widthHint, minSize.x);
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    public static int getHeightHint(List list, int numItems) {
        Assert.isLegal((numItems > 0 ? 1 : 0) != 0, (String)"numItems must be greater than 0");
        int items = list.getItemHeight() * numItems;
        return items;
    }

    public static MessageBox createMessageBox(Composite parent) {
        return new MessageBox(parent);
    }
}

