/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.tree;

import java.io.Serializable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.ui.ridgets.UIBindingFailure;
import org.eclipse.riena.ui.ridgets.tree.DefaultTreeNode;
import org.eclipse.riena.ui.ridgets.tree.ITreeModel;
import org.eclipse.riena.ui.ridgets.tree.ITreeModelListener;
import org.eclipse.riena.ui.ridgets.tree.ITreeNode;
import org.eclipse.riena.ui.ridgets.tree.IVisibleTreeNode;
import org.eclipse.riena.ui.ridgets.tree.TreeModelEvent;

public class DefaultTreeModel
extends AbstractObservableValue
implements ITreeModel {
    protected ITreeNode root;
    protected ListenerList<ITreeModelListener> listenerList = new ListenerList(ITreeModelListener.class);

    public DefaultTreeModel(ITreeNode root) {
        this.root = root;
    }

    public Object getChild(Object parent, int index) {
        Assert.isNotNull((Object)parent, (String)"parent is null");
        Assert.isTrue((boolean)(parent instanceof ITreeNode), (String)"parent is not an instance of ITreeNode");
        return ((ITreeNode)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        Assert.isNotNull((Object)parent, (String)"parent is null");
        Assert.isTrue((boolean)(parent instanceof ITreeNode), (String)"parent is not an instance of ITreeNode");
        return ((ITreeNode)parent).getChildCount();
    }

    public Object getRoot() {
        return this.root;
    }

    public Object doGetValue() {
        return this;
    }

    public Object getValueType() {
        return null;
    }

    public int getIndexOfChild(Object parent, Object child) {
        Assert.isNotNull((Object)parent, (String)"parent is null");
        Assert.isTrue((boolean)(parent instanceof ITreeNode), (String)"parent is not an instance of ITreeNode");
        Assert.isNotNull((Object)child, (String)"child is null");
        Assert.isTrue((boolean)(child instanceof ITreeNode), (String)"child is not an instance of ITreeNode");
        return ((ITreeNode)parent).getIndex((ITreeNode)child);
    }

    public boolean isLeaf(Object node) {
        Assert.isNotNull((Object)node, (String)"node is null");
        Assert.isTrue((boolean)(node instanceof ITreeNode), (String)"node is not an instance of ITreeNode");
        return ((ITreeNode)node).isLeaf();
    }

    public void addTreeModelListener(ITreeModelListener l) {
        this.listenerList.add((Object)l);
    }

    public void removeTreeModelListener(ITreeModelListener l) {
        this.listenerList.remove((Object)l);
    }

    public void insertNodeInto(DefaultTreeNode newChild, DefaultTreeNode parent, int index) {
        parent.insert(newChild, index);
        int[] newIndexs = new int[]{index};
        Serializable[] newChildren = new Serializable[]{newChild};
        this.fireTreeNodesInserted((IObservable)this, parent, newIndexs, newChildren);
    }

    public void addNode(DefaultTreeNode newChild, DefaultTreeNode parent) {
        this.insertNodeInto(newChild, parent, this.getChildCount(newChild, parent));
    }

    protected int getChildCount(DefaultTreeNode newChild, DefaultTreeNode parent) {
        return this.getChildCount(parent);
    }

    public void removeNodeFromParent(DefaultTreeNode node) {
        DefaultTreeNode parent = (DefaultTreeNode)node.getParent();
        if (parent == null) {
            throw new UIBindingFailure("node does not have a parent.");
        }
        int[] childIndex = new int[1];
        Serializable[] removedArray = new Serializable[1];
        childIndex[0] = this.getIndex(parent, node);
        removedArray[0] = node;
        parent.remove(childIndex[0]);
        this.fireTreeNodesRemoved((IObservable)this, parent, childIndex, removedArray);
    }

    protected int getIndex(DefaultTreeNode parent, DefaultTreeNode node) {
        return this.getIndexOfChild(parent, node);
    }

    public void nodeChanged(ITreeNode node) {
        if (this.listenerList != null && node != null) {
            ITreeNode parent = node.getParent();
            if (parent != null) {
                int anIndex = -1;
                if (parent instanceof IVisibleTreeNode) {
                    IVisibleTreeNode changeVisibilityParent = (IVisibleTreeNode)((Object)parent);
                    anIndex = changeVisibilityParent.getVisibleIndex((IVisibleTreeNode)((Object)node));
                } else {
                    anIndex = parent.getIndex(node);
                }
                if (anIndex != -1) {
                    int[] cIndexs = new int[]{anIndex};
                    this.nodesChanged(parent, cIndexs);
                }
            } else if (node == this.getRoot()) {
                this.nodesChanged(node, null);
            }
        }
    }

    public void nodesChanged(ITreeNode node, int[] childIndices) {
        if (node != null) {
            if (childIndices != null) {
                if (childIndices.length > 0) {
                    Serializable[] cChildren = this.getChildren(node, childIndices);
                    this.fireTreeNodesChanged((IObservable)this, node, childIndices, cChildren);
                }
            } else if (node == this.getRoot()) {
                this.fireTreeNodesChanged((IObservable)this, node, null, null);
            }
        }
    }

    public void nodesAdded(ITreeNode node, int[] childIndices) {
        if (node != null && childIndices != null) {
            this.fireTreeNodesInserted((IObservable)this, node, childIndices, this.getChildren(node, childIndices));
        }
    }

    public void nodesRemoved(ITreeNode node, int[] childIndices) {
        if (node != null && childIndices != null) {
            this.fireTreeNodesRemoved((IObservable)this, node, childIndices, this.getChildren(node, childIndices));
        }
    }

    private Serializable[] getChildren(ITreeNode node, int[] childIndices) {
        int cCount = childIndices.length;
        Serializable[] cChildren = new Serializable[cCount];
        int counter = 0;
        while (counter < cCount) {
            cChildren[counter] = node.getChildAt(childIndices[counter]);
            ++counter;
        }
        return cChildren;
    }

    public void refresh() {
        this.fireTreeStructureChanged((IObservable)this, (ITreeNode)this.getRoot(), null, null);
    }

    protected void fireTreeStructureChanged(IObservable source, ITreeNode node, int[] childIndices, Serializable[] children) {
        TreeModelEvent e = null;
        ITreeModelListener[] iTreeModelListenerArray = (ITreeModelListener[])this.listenerList.getListeners();
        int n = iTreeModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeModelListener listener = iTreeModelListenerArray[n2];
            if (e == null) {
                e = TreeModelEvent.createStructureChangedInstance(source, node, childIndices, children);
            }
            listener.treeStructureChanged(e);
            ++n2;
        }
    }

    protected void fireTreeNodesInserted(IObservable source, ITreeNode node, int[] childIndices, Serializable[] children) {
        TreeModelEvent e = null;
        ITreeModelListener[] iTreeModelListenerArray = (ITreeModelListener[])this.listenerList.getListeners();
        int n = iTreeModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeModelListener listener = iTreeModelListenerArray[n2];
            if (e == null) {
                e = TreeModelEvent.createNodesInsertedInstance(source, node, childIndices, children);
            }
            listener.treeNodesInserted(e);
            ++n2;
        }
    }

    protected void fireTreeNodesRemoved(IObservable source, ITreeNode node, int[] childIndices, Serializable[] children) {
        TreeModelEvent e = null;
        ITreeModelListener[] iTreeModelListenerArray = (ITreeModelListener[])this.listenerList.getListeners();
        int n = iTreeModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeModelListener listener = iTreeModelListenerArray[n2];
            if (e == null) {
                e = TreeModelEvent.createNodesRemovedInstance(source, node, childIndices, children);
            }
            listener.treeNodesRemoved(e);
            ++n2;
        }
    }

    protected void fireTreeNodesChanged(IObservable source, ITreeNode node, int[] childIndices, Serializable[] children) {
        TreeModelEvent e = null;
        ITreeModelListener[] iTreeModelListenerArray = (ITreeModelListener[])this.listenerList.getListeners();
        int n = iTreeModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeModelListener listener = iTreeModelListenerArray[n2];
            if (e == null) {
                e = TreeModelEvent.createValueDiffInstance(source, node, childIndices, children);
            }
            listener.treeNodesChanged(e);
            ++n2;
        }
    }
}

