/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf.renderer;

import org.eclipse.riena.ui.swt.lnf.AbstractLnfRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ShellLogoRenderer
extends AbstractLnfRenderer {
    public void paint(GC gc, Object value) {
        Image logo = this.getLogoImage();
        if (logo == null) {
            return;
        }
        int logoWidth = logo.getImageData().width;
        int logoHeight = logo.getImageData().height;
        int hMargin = ShellLogoRenderer.getHorizontalLogoMargin();
        int vMargin = this.getVerticalLogoMargin();
        int x = this.getBounds().x;
        Integer hPos = this.getHorizontalLogoPosition();
        switch (hPos) {
            case 0x1000000: {
                x = this.getBounds().width / 2 - logoWidth / 2;
                break;
            }
            case 131072: {
                x = this.getBounds().width - logoWidth - hMargin;
                break;
            }
            default: {
                x = hMargin;
            }
        }
        int y = this.getBounds().y;
        Integer vPos = this.getVerticalLogoPosition();
        switch (vPos) {
            case 0x1000000: {
                y = this.getBounds().height / 2 - logoHeight / 2;
                break;
            }
            case 1024: {
                y = this.getBounds().height - logoHeight - vMargin;
                break;
            }
            default: {
                y = vMargin;
            }
        }
        gc.drawImage(logo, x, y);
    }

    public void dispose() {
    }

    public static Integer getHorizontalLogoMargin() {
        Integer margin = LnfManager.getLnf().getIntegerSetting("TitlelessShell.horizontalLogoMargin");
        if (margin == null) {
            margin = 0;
        }
        return margin;
    }

    private Integer getVerticalLogoMargin() {
        Integer margin = LnfManager.getLnf().getIntegerSetting("TitlelessShell.verticalLogoMargin");
        if (margin == null) {
            margin = 0;
        }
        return margin;
    }

    private int getHorizontalLogoPosition() {
        Integer hPos = LnfManager.getLnf().getIntegerSetting("TitlelessShell.horizontalLogoPosition");
        if (hPos == null) {
            hPos = 16384;
        }
        return hPos;
    }

    private int getVerticalLogoPosition() {
        Integer hPos = LnfManager.getLnf().getIntegerSetting("TitlelessShell.verticalLogoPosition");
        if (hPos == null) {
            hPos = 128;
        }
        return hPos;
    }

    private Image getLogoImage() {
        return LnfManager.getLnf().getImage("TitlelessShell.logo");
    }
}

