/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.marker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.IMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Markable
implements IMarkable {
    private Set<IMarker> markers = new HashSet<IMarker>();

    @Override
    public void addMarker(IMarker marker) {
        if (marker.isUnique()) {
            Collection<?> markersOfType = this.getMarkersOfType(marker.getClass());
            boolean unique = false;
            for (IMarker m : markersOfType) {
                if (!m.isUnique()) continue;
                unique = true;
            }
            if (!unique) {
                this.markers.add(marker);
            }
        } else {
            this.markers.add(marker);
        }
    }

    @Override
    public Collection<? extends IMarker> getMarkers() {
        return this.markers;
    }

    @Override
    public <T extends IMarker> Collection<T> getMarkersOfType(Class<T> type) {
        return Markable.getMarkersOfType(this.getMarkers(), type);
    }

    @Override
    public void removeAllMarkers() {
        this.markers.clear();
    }

    @Override
    public void removeMarker(IMarker marker) {
        this.markers.remove(marker);
    }

    public static <T extends IMarker> Collection<T> getMarkersOfType(Collection<? extends IMarker> markerSet, Class<T> type) {
        if (type == null || markerSet == null) {
            return Collections.emptyList();
        }
        ArrayList<IMarker> typedMarkerList = new ArrayList<IMarker>();
        for (IMarker iMarker : markerSet) {
            if (!type.isAssignableFrom(iMarker.getClass())) continue;
            typedMarkerList.add(iMarker);
        }
        return typedMarkerList;
    }
}

