/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.logging.CommandProviderLogFilter;
import org.eclipse.riena.core.logging.ILogCatcher;
import org.eclipse.riena.core.logging.LogServiceLogCatcher;
import org.eclipse.riena.core.logging.PlatformLogCatcher;
import org.eclipse.riena.core.logging.SysoLogListener;
import org.eclipse.riena.internal.core.logging.ILogCatcherDefinition;
import org.eclipse.riena.internal.core.logging.ILogListenerDefinition;
import org.eclipse.riena.internal.core.logging.SynchronousLogListenerAdapter;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogListener;

public class LoggerMill {
    public static final String RIENA_DEFAULT_LOGGING = "riena.defaultlogging";
    private List<LogListener> logListeners = new ArrayList<LogListener>();
    private List<ILogCatcher> logCatchers = new ArrayList<ILogCatcher>();
    private ILogListenerDefinition[] listenerDefs;
    private ILogCatcherDefinition[] catcherDefs;
    private final AtomicReference<ExtendedLogService> logServiceRef = new AtomicReference<Object>(null);

    public LoggerMill(BundleContext context) {
        this(context, true);
    }

    protected LoggerMill(BundleContext context, boolean autoConfig) {
        Inject.extension("org.eclipse.riena.core.logging.catchers").useType(ILogCatcherDefinition.class).into(this).andStart(context);
        Inject.extension("org.eclipse.riena.core.logging.listeners").useType(ILogListenerDefinition.class).into(this).andStart(context);
        Inject.service(ExtendedLogReaderService.class).useRanking().into(this).andStart(context);
        Inject.service(ExtendedLogService.class).useRanking().into(this).andStart(context);
    }

    public Logger getLogger(String category) {
        return this.isReady() ? this.logServiceRef.get().getLogger(category) : null;
    }

    public void bind(ExtendedLogService logService) {
        this.logServiceRef.set(logService);
    }

    public void unbind(ExtendedLogService logService) {
        this.logServiceRef.set(null);
    }

    public void bind(ExtendedLogReaderService logReaderService) {
        if (this.listenerDefs.length == 0 && Boolean.getBoolean(RIENA_DEFAULT_LOGGING)) {
            this.listenerDefs = new ILogListenerDefinition[]{new SysoLogListenerDefinition()};
        }
        Object[] objectArray = this.listenerDefs;
        int n = this.listenerDefs.length;
        int n2 = 0;
        while (n2 < n) {
            ILogListenerDefinition logListenerDef = objectArray[n2];
            Object listener = logListenerDef.createLogListener();
            if (listener != null) {
                if (logListenerDef.isSynchronous()) {
                    listener = new SynchronousLogListenerAdapter((LogListener)listener);
                }
                this.logListeners.add((LogListener)listener);
                LogFilter filter = logListenerDef.createLogFilter();
                if (filter == null) {
                    logReaderService.addLogListener(listener);
                } else {
                    logReaderService.addLogListener(listener, filter);
                }
            }
            ++n2;
        }
        if (this.catcherDefs.length == 0 && Boolean.getBoolean(RIENA_DEFAULT_LOGGING)) {
            this.catcherDefs = new ILogCatcherDefinition[]{new PlatformLogCatcherDefinition(), new LogServiceLogCatcherDefinition()};
        }
        objectArray = this.catcherDefs;
        n = this.catcherDefs.length;
        n2 = 0;
        while (n2 < n) {
            Object catcherDef = objectArray[n2];
            ILogCatcher logCatcher = catcherDef.createLogCatcher();
            logCatcher.attach();
            this.logCatchers.add(logCatcher);
            ++n2;
        }
    }

    public void unbind(ExtendedLogReaderService logReaderService) {
        for (LogListener logListener : this.logListeners) {
            logReaderService.removeLogListener(logListener);
        }
        for (ILogCatcher logCatcher : this.logCatchers) {
            logCatcher.detach();
        }
    }

    public void update(ILogListenerDefinition[] listenerDefs) {
        this.listenerDefs = listenerDefs;
    }

    public void update(ILogCatcherDefinition[] catcherDefs) {
        this.catcherDefs = catcherDefs;
    }

    public boolean isReady() {
        return this.logServiceRef.get() != null;
    }

    private static final class LogServiceLogCatcherDefinition
    implements ILogCatcherDefinition {
        private LogServiceLogCatcherDefinition() {
        }

        public ILogCatcher createLogCatcher() {
            return new LogServiceLogCatcher();
        }

        public String getName() {
            return "DefaultLogServiceLogCatcher";
        }
    }

    private static final class PlatformLogCatcherDefinition
    implements ILogCatcherDefinition {
        private PlatformLogCatcherDefinition() {
        }

        public ILogCatcher createLogCatcher() {
            return new PlatformLogCatcher();
        }

        public String getName() {
            return "DefaultPlatformLogCatcher";
        }
    }

    private static final class SysoLogListenerDefinition
    implements ILogListenerDefinition {
        private SysoLogListenerDefinition() {
        }

        public boolean isSynchronous() {
            return true;
        }

        public LogFilter createLogFilter() {
            return new CommandProviderLogFilter();
        }

        public LogListener createLogListener() {
            return new SysoLogListener();
        }

        public String getName() {
            return "DefaultLogListner";
        }
    }
}

