/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.EventHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractValueRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.ActionObserver;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public class ToggleButtonRidget
extends AbstractValueRidget
implements IToggleButtonRidget {
    private static final String EMPTY_STRING = "";
    private final ActionObserver actionObserver = new ActionObserver();
    private Binding controlBinding;
    private String text;
    private String icon;
    private boolean selected;
    private boolean textAlreadyInitialized = false;
    private boolean useRidgetIcon = false;

    public ToggleButtonRidget() {
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean isEnabled = (Boolean)evt.getNewValue();
                ToggleButtonRidget.this.updateSelection(isEnabled);
            }
        });
    }

    protected void checkUIControl(Object uiControl) {
        Button uiButton;
        int style;
        AbstractSWTRidget.assertType(uiControl, Button.class);
        if (uiControl != null && ((style = (uiButton = (Button)uiControl).getStyle()) & 0x20) != 32 && (style & 2) != 2 && (style & 0x10) != 16) {
            throw new BindingException("Button must be a check box, a radio button or a toggle button");
        }
    }

    protected void bindUIControl() {
        DataBindingContext context = this.getValueBindingSupport().getContext();
        Button control = this.getUIControl();
        if (control != null) {
            this.controlBinding = context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)control), BeansObservables.observeValue((Object)((Object)this), (String)"selected"), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setBeforeSetValidator((IValidator)new CancelControlUpdateWhenDisabled()));
            this.initText();
            this.updateUIText();
            this.updateSelection(this.isEnabled());
            this.updateUIIcon();
        }
    }

    protected void unbindUIControl() {
        if (this.controlBinding != null) {
            this.controlBinding.dispose();
            this.controlBinding = null;
        }
    }

    IObservableValue getRidgetObservable() {
        return BeansObservables.observeValue((Object)((Object)this), (String)"selected");
    }

    public boolean isDisableMandatoryMarker() {
        return true;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (this.selected != selected) {
            boolean oldValue = this.selected;
            this.selected = selected;
            this.actionObserver.fireAction();
            this.firePropertyChange("selected", oldValue, selected);
        }
    }

    public Button getUIControl() {
        return (Button)super.getUIControl();
    }

    public void addListener(IActionListener listener) {
        this.actionObserver.addListener(listener);
    }

    public void addListener(Object target, String action) {
        IActionListener listener = EventHandler.create(IActionListener.class, target, action);
        this.actionObserver.addListener(listener);
    }

    public void removeListener(IActionListener listener) {
        this.actionObserver.removeListener(listener);
    }

    public final String getText() {
        return this.text;
    }

    public final void setText(String newText) {
        this.text = newText;
        this.updateUIText();
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        boolean oldUseRidgetIcon = this.useRidgetIcon;
        this.useRidgetIcon = true;
        String oldIcon = this.icon;
        this.icon = icon;
        if (this.hasChanged(oldIcon, icon) || !oldUseRidgetIcon) {
            this.updateUIIcon();
        }
    }

    private void initText() {
        if (this.text == null && !this.textAlreadyInitialized && this.getUIControl() != null && !this.getUIControl().isDisposed()) {
            this.text = this.getUIControl().getText();
            if (this.text == null) {
                this.text = EMPTY_STRING;
            }
            this.textAlreadyInitialized = true;
        }
    }

    private void updateSelection(boolean isRidgetEnabled) {
        Button control = this.getUIControl();
        if (control != null && MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            if (!isRidgetEnabled) {
                control.setSelection(false);
            } else {
                control.setSelection(this.isSelected());
            }
        }
    }

    private void updateUIText() {
        Button control = this.getUIControl();
        if (control != null) {
            control.setText(this.text);
        }
    }

    private void updateUIIcon() {
        Button control = this.getUIControl();
        if (control != null) {
            Image image = null;
            if (this.icon != null) {
                image = this.getManagedImage(this.icon);
            }
            if (image != null || this.useRidgetIcon) {
                control.setImage(image);
            }
        }
    }

    private final class CancelControlUpdateWhenDisabled
    implements IValidator {
        private CancelControlUpdateWhenDisabled() {
        }

        public IStatus validate(Object value) {
            boolean cancel = MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT && !ToggleButtonRidget.this.isEnabled();
            return cancel ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }
    }
}

