/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeSupport;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.riena.internal.ui.ridgets.swt.ToolItemRidget;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.swt.MenuManagerHelper;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.menus.CommandContributionItem;

public class ToolItemMarkerSupport
extends AbstractMarkerSupport {
    public ToolItemMarkerSupport(ToolItemRidget ridget, PropertyChangeSupport propertyChangeSupport) {
        super((IMarkableRidget)ridget, propertyChangeSupport);
    }

    public void updateMarkers() {
        this.updateToolItem();
    }

    protected void handleMarkerAttributesChanged() {
        this.updateToolItem();
        super.handleMarkerAttributesChanged();
    }

    protected ToolItemRidget getRidget() {
        return (ToolItemRidget)this.ridget;
    }

    private void updateDisabled(ToolItem item) {
        if (item.isDisposed()) {
            return;
        }
        boolean enabled = this.ridget.isEnabled();
        CommandContributionItem commandItem = this.getContributionItem(item);
        if (commandItem != null) {
            enabled = enabled && commandItem.isEnabled();
        }
        item.setEnabled(enabled);
    }

    private void updateVisible(ToolItem item) {
        if (this.getRidget().isVisible()) {
            this.getRidget().createItem();
        } else {
            MenuManager menuManager = this.getMenuManager(item);
            if (menuManager != null) {
                MenuManagerHelper helper = new MenuManagerHelper();
                helper.removeListeners(item, menuManager.getMenu());
            }
            item.dispose();
        }
    }

    private MenuManager getMenuManager(ToolItem item) {
        if (item.isDisposed()) {
            return null;
        }
        if (item.getData() instanceof MenuManager) {
            return (MenuManager)item.getData();
        }
        return null;
    }

    private CommandContributionItem getContributionItem(ToolItem item) {
        if (item.isDisposed()) {
            return null;
        }
        if (item.getData() instanceof CommandContributionItem) {
            return (CommandContributionItem)item.getData();
        }
        return null;
    }

    private void updateToolItem() {
        ToolItem item = (ToolItem)this.ridget.getUIControl();
        if (item != null) {
            this.updateVisible(item);
            if (!item.isDisposed()) {
                this.updateDisabled(item);
            }
        }
    }
}

