/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.internal;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.equinox.log.internal.EventAdminLogListener;
import org.eclipse.equinox.log.internal.ExtendedLogReaderServiceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class EventAdminAdapter
implements ServiceTrackerCustomizer {
    private static final String[] LOG_TOPICS_ARRAY = new String[]{"*", "org/*", "org/osgi/*", "org/osgi/service/*", "org/osgi/service/log/*", "org/osgi/service/log/LogEntry/*", "org/osgi/service/log/LogEntry/LOG_ERROR", "org/osgi/service/log/LogEntry/LOG_WARNING", "org/osgi/service/log/LogEntry/LOG_INFO", "org/osgi/service/log/LogEntry/LOG_DEBUG", "org/osgi/service/log/LogEntry/LOG_OTHER"};
    private static HashSet logTopics = new HashSet(Arrays.asList(LOG_TOPICS_ARRAY));
    private ServiceTracker eventAdminTracker;
    private ServiceTracker eventHandlerTracker;
    private BundleContext context;
    private EventAdmin eventAdmin;
    private int logEventHandlers;
    private ExtendedLogReaderServiceFactory logReaderServiceFactory;
    private EventAdminLogListener logListener;

    public EventAdminAdapter(BundleContext context, ExtendedLogReaderServiceFactory logReaderServiceFactory) {
        this.context = context;
        this.logReaderServiceFactory = logReaderServiceFactory;
        this.eventAdminTracker = new ServiceTracker(context, EventAdmin.class.getName(), (ServiceTrackerCustomizer)this);
        this.eventHandlerTracker = new ServiceTracker(context, EventHandler.class.getName(), (ServiceTrackerCustomizer)this);
    }

    public void start() {
        this.eventHandlerTracker.open();
        this.eventAdminTracker.open();
    }

    public void stop() {
        this.eventAdminTracker.close();
        this.eventHandlerTracker.close();
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.context.getService(reference);
        if (service instanceof EventAdmin && this.eventAdmin == null) {
            this.eventAdmin = (EventAdmin)service;
        } else if (service instanceof EventHandler && EventAdminAdapter.hasLogTopic(reference.getProperty("event.topics"))) {
            ++this.logEventHandlers;
        }
        if (this.eventAdmin != null && this.logEventHandlers > 0 && this.logListener == null) {
            this.logListener = new EventAdminLogListener(this.eventAdmin);
            this.logReaderServiceFactory.addLogListener(this.logListener, ExtendedLogReaderServiceFactory.NULL_LOGGER_FILTER);
        }
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.removedService(reference, service);
        this.addingService(reference);
    }

    public void removedService(ServiceReference reference, Object service) {
        if (service == this.eventAdmin) {
            this.eventAdmin = null;
        } else if (service instanceof EventHandler && EventAdminAdapter.hasLogTopic(reference.getProperty("event.topics"))) {
            --this.logEventHandlers;
        }
        if (this.logListener != null && (this.eventAdmin == null || this.logEventHandlers == 0)) {
            this.logReaderServiceFactory.removeLogListener(this.logListener);
            this.logListener = null;
        }
    }

    private static boolean hasLogTopic(Object property) {
        if (property instanceof String) {
            return logTopics.contains(property);
        }
        if (property instanceof String[]) {
            String[] topics = (String[])property;
            int i = 0;
            while (i < topics.length) {
                if (logTopics.contains(topics[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

