/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.monitor.client;

import java.io.Serializable;
import org.eclipse.riena.monitor.client.Category;
import org.eclipse.riena.monitor.client.ICollectingAggregator;
import org.eclipse.riena.monitor.client.ICollector;
import org.eclipse.riena.monitor.common.Collectible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollector
implements ICollector {
    private ICollectingAggregator aggregator;
    private Category category;
    private boolean started;

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public void setAggregator(ICollectingAggregator aggregator) {
        this.aggregator = aggregator;
    }

    protected ICollectingAggregator getAggregator() {
        return this.aggregator;
    }

    @Override
    public void setCategory(Category category) {
        this.category = category;
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        this.doStart();
        this.started = true;
    }

    protected void doStart() {
    }

    protected boolean isReady() {
        return this.aggregator != null && this.category != null && this.started;
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        this.doStop();
        this.started = false;
    }

    protected void doStop() {
    }

    protected <T extends Serializable> void collect(T payload) {
        if (!this.isReady()) {
            return;
        }
        this.aggregator.collect(new Collectible(this.category.getName(), payload));
    }

    protected void triggerTransfer() {
        this.aggregator.triggerTransfer(this.category.getName());
    }
}

