/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.monitor.client;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.internal.monitor.client.Activator;
import org.eclipse.riena.monitor.client.AbstractCollector;
import org.eclipse.riena.monitor.client.Range;
import org.eclipse.riena.monitor.common.LogEntryTransferObject;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public class LogServiceCollector
extends AbstractCollector
implements IExecutableExtension {
    private Range collectRange;
    private Range triggerRange;
    private final LogListener logListener = this.newLogListener();
    private static final String TRIGGER_RANGE = "triggerRange";
    private static final String COLLECT_RANGE = "collectRange";

    public LogServiceCollector() {
        this(true);
    }

    protected LogServiceCollector(boolean autoConfig) {
        if (autoConfig) {
            Inject.service(ExtendedLogReaderService.class).useRanking().into((Object)this).andStart(Activator.getDefault().getContext());
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        Map properties = null;
        try {
            properties = PropertiesUtils.asMap((Object)data, (String[])new String[]{COLLECT_RANGE, TRIGGER_RANGE});
            this.collectRange = new Range((String)properties.get(COLLECT_RANGE));
            this.triggerRange = new Range((String)properties.get(TRIGGER_RANGE));
        }
        catch (IllegalArgumentException e) {
            throw this.configurationException("Bad configuration.", e);
        }
    }

    public void bind(ExtendedLogReaderService extendedLogReaderService) {
        extendedLogReaderService.addLogListener(this.logListener);
    }

    public void unbind(ExtendedLogReaderService extendedLogReaderService) {
        extendedLogReaderService.removeLogListener(this.logListener);
    }

    private LogListener newLogListener() {
        return new LogListener(){

            public void logged(LogEntry entry) {
                if (!LogServiceCollector.this.collectRange.matches(entry.getLevel())) {
                    return;
                }
                LogServiceCollector.this.collect(new LogEntryTransferObject((ExtendedLogEntry)entry));
                if (LogServiceCollector.this.triggerRange.matches(entry.getLevel())) {
                    LogServiceCollector.this.triggerTransfer();
                }
            }
        };
    }

    private CoreException configurationException(String message, Exception e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.riena.monitor.client", message, (Throwable)e));
    }
}

