/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.monitor.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.util.Literal;
import org.eclipse.riena.core.util.Millis;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.internal.monitor.client.Activator;
import org.eclipse.riena.monitor.client.Category;
import org.eclipse.riena.monitor.client.ISender;
import org.eclipse.riena.monitor.client.IStore;
import org.eclipse.riena.monitor.common.Collectible;
import org.eclipse.riena.monitor.common.IReceiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSender
implements ISender,
IExecutableExtension {
    private IStore store;
    private IReceiver receiver;
    private boolean started;
    private long retryTime;
    private Map<String, Category> categories = new HashMap<String, Category>();
    private final Map<String, Sender> senders = new HashMap<String, Sender>();
    private static final String RETRY_TIME = "retryTime";
    private static final String RETRY_TIME_DEFAULT = "15 m";
    private static final boolean TRACE = false;

    public SimpleSender() throws CoreException {
        this(true);
        this.setInitializationData(null, null, null);
    }

    public SimpleSender(boolean autoConfig) {
        if (autoConfig) {
            Inject.service(IReceiver.class).useRanking().into((Object)this).andStart(Activator.getDefault().getContext());
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        Map properties = null;
        try {
            properties = PropertiesUtils.asMap((Object)data, (Map)((Map)Literal.map((Object)RETRY_TIME, (Object)RETRY_TIME_DEFAULT)), (String[])new String[0]);
            this.retryTime = Millis.valueOf((String)((String)properties.get(RETRY_TIME)));
            Assert.isLegal((this.retryTime > 0L ? 1 : 0) != 0, (String)"retryTime must be greater than 0.");
        }
        catch (IllegalArgumentException e) {
            throw this.configurationException("Bad configuration.", e);
        }
    }

    private CoreException configurationException(String message, Exception e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.riena.monitor.client", message, (Throwable)e));
    }

    public void bind(IReceiver receiver) {
        this.receiver = receiver;
    }

    public void unbind(IReceiver receiver) {
        this.receiver = null;
    }

    @Override
    public void setStore(IStore store) {
        Assert.isNotNull((Object)store, (String)"store must not be null");
        this.store = store;
    }

    @Override
    public void setCategories(Map<String, Category> categories) {
        Assert.isNotNull(categories, (String)"categories must not be null");
        this.categories = categories;
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        for (String categoryName : this.categories.keySet()) {
            Sender sender = new Sender(categoryName);
            this.senders.put(categoryName, sender);
            sender.tryIt(Millis.seconds((int)5));
        }
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        for (Sender sender : this.senders.values()) {
            sender.cancel();
        }
        this.senders.clear();
    }

    @Override
    public synchronized void triggerTransfer(String categoryName) {
        if (!this.started) {
            return;
        }
        Sender sender = this.senders.get(categoryName);
        if (sender == null) {
            return;
        }
        sender.tryIt(0L);
    }

    private static void trace(String line) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Sender
    extends Job {
        private final String category;
        private boolean retrying;

        private Sender(String category) {
            super("SimpleSender");
            this.category = category;
        }

        private void tryIt(long delay) {
            if (this.retrying) {
                SimpleSender.trace("Retry already scheduled.");
                return;
            }
            this.schedule(delay);
        }

        protected IStatus run(IProgressMonitor monitor) {
            SimpleSender.trace("Sender retrying: " + this.retrying);
            SimpleSender.trace("sender start - " + this.category);
            if (SimpleSender.this.receiver == null) {
                SimpleSender.trace("sender ended(no receiver) - " + this.category);
                return Status.OK_STATUS;
            }
            List<Collectible<?>> transferables = SimpleSender.this.store.retrieveTransferables(this.category);
            if (transferables.size() == 0) {
                SimpleSender.trace("sender ended(nothing to send) - " + this.category);
                return Status.OK_STATUS;
            }
            this.transfer(transferables);
            SimpleSender.trace("sender ended - " + this.category);
            return Status.OK_STATUS;
        }

        private void transfer(List<Collectible<?>> transferables) {
            block4: {
                SimpleSender.trace("sender transfer " + transferables.size() + " transferables:");
                for (Collectible<?> transferable : transferables) {
                    SimpleSender.trace(" - " + transferable);
                }
                try {
                    if (SimpleSender.this.receiver.take(System.currentTimeMillis(), transferables)) {
                        SimpleSender.this.store.commitTransferred(transferables);
                        this.retrying = false;
                        break block4;
                    }
                    throw new RuntimeException("Retry sending later because receiver rejected it.");
                }
                catch (Throwable t) {
                    SimpleSender.trace("sending failed with: " + t);
                    SimpleSender.trace("retrying in " + SimpleSender.this.retryTime + " milli seconds");
                    this.retrying = true;
                    this.schedule(SimpleSender.this.retryTime);
                }
            }
        }
    }
}

