/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.monitor.client;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.RienaLocations;
import org.eclipse.riena.core.util.IOUtils;
import org.eclipse.riena.core.util.Literal;
import org.eclipse.riena.core.util.Millis;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.internal.monitor.client.Activator;
import org.eclipse.riena.monitor.client.Category;
import org.eclipse.riena.monitor.client.IStore;
import org.eclipse.riena.monitor.common.Collectible;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStore
implements IStore,
IExecutableExtension {
    private File storeFolder;
    private long cleanupDelay;
    private Cleaner cleaner;
    private Map<String, Category> categories = new HashMap<String, Category>();
    private Cipher encrypt;
    private Cipher decrypt;
    private static final String TRANSFER_FILE_EXTENSION = ".trans";
    private static final String COLLECT_FILE_EXTENSION = ".coll";
    private static final String DEL_FILE_EXTENSION = ".del";
    private static final String CATEGORY_DELIMITER = "#";
    private static final String CLEANUP_DELAY = "cleanupDelay";
    private static final String CLEANUP_DELAY_DEFAULT = "1 h";
    private static final Logger LOGGER = Activator.getDefault().getLogger(SimpleStore.class);
    private static final boolean TRACE = false;
    private static final byte[] KEY = new byte[8];

    static {
        long first = "This is not very clever :-)".hashCode();
        long second = "And this neither!".hashCode();
        new Random(first * second).nextBytes(KEY);
    }

    public SimpleStore() throws CoreException {
        this("simplestore", true);
        this.setInitializationData(null, null, null);
    }

    private SimpleStore(String storeFolderName, boolean autoConfig) {
        if (autoConfig) {
            this.cleaner = new Cleaner();
            this.storeFolder = new File(RienaLocations.getDataArea((Bundle)Activator.getDefault().getBundle()), storeFolderName);
            if (!this.storeFolder.isDirectory()) {
                boolean directoryCreated = this.storeFolder.mkdirs();
                Assert.isTrue((boolean)directoryCreated);
            }
            try {
                this.encrypt = SimpleStore.getCipher(1);
                this.decrypt = SimpleStore.getCipher(2);
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException("Could not generate keys for encryption.", e);
            }
            LOGGER.log(4, "SimpleStore at " + this.storeFolder);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        Map properties = null;
        try {
            properties = PropertiesUtils.asMap((Object)data, (Map)((Map)Literal.map((Object)CLEANUP_DELAY, (Object)CLEANUP_DELAY_DEFAULT)), (String[])new String[0]);
            this.cleanupDelay = Millis.valueOf((String)((String)properties.get(CLEANUP_DELAY)));
            Assert.isLegal((this.cleanupDelay > 0L ? 1 : 0) != 0, (String)"cleanupDelay must be greater than 0.");
        }
        catch (IllegalArgumentException e) {
            throw this.configurationException("Bad configuration.", e);
        }
    }

    private CoreException configurationException(String message, Exception e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.riena.monitor.client", message, (Throwable)e));
    }

    @Override
    public void setCategories(Map<String, Category> categories) {
        this.categories = categories;
    }

    @Override
    public void open() {
        this.cleaner.schedule(Millis.seconds((int)15));
    }

    @Override
    public void close() {
        this.cleaner.cancel();
    }

    @Override
    public void flush() {
    }

    @Override
    public synchronized boolean collect(Collectible<?> collectible) {
        File file = this.getFile(collectible, COLLECT_FILE_EXTENSION);
        this.putCollectible(collectible, file);
        return true;
    }

    @Override
    public void prepareTransferables(final String category) {
        File[] trans;
        File[] fileArray = trans = this.storeFolder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(category) && name.endsWith(SimpleStore.COLLECT_FILE_EXTENSION);
            }
        });
        int n = trans.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName().replace(COLLECT_FILE_EXTENSION, TRANSFER_FILE_EXTENSION);
            boolean fileRenamed = file.renameTo(new File(file.getParent(), name));
            Assert.isTrue((boolean)fileRenamed);
            ++n2;
        }
    }

    @Override
    public synchronized List<Collectible<?>> retrieveTransferables(final String category) {
        File[] transferables = this.storeFolder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(category) && name.endsWith(SimpleStore.TRANSFER_FILE_EXTENSION);
            }
        });
        ArrayList collectibles = new ArrayList();
        File[] fileArray = transferables;
        int n = transferables.length;
        int n2 = 0;
        while (n2 < n) {
            File transferable = fileArray[n2];
            Collectible<?> collectible = this.getCollectible(transferable);
            if (collectible != null) {
                collectibles.add(collectible);
            }
            ++n2;
        }
        return collectibles;
    }

    protected InputStream getDecryptor(InputStream is) throws IOException {
        return new CipherInputStream(is, this.decrypt);
    }

    protected OutputStream getEncryptor(OutputStream os) throws IOException {
        return new CipherOutputStream(os, this.encrypt);
    }

    protected OutputStream getCompressor(OutputStream os) throws IOException {
        return new GZIPOutputStream(os);
    }

    protected InputStream getDecompressor(InputStream is) throws IOException {
        return new GZIPInputStream(is);
    }

    @Override
    public synchronized void commitTransferred(List<Collectible<?>> collectibles) {
        for (Collectible<?> collectible : collectibles) {
            this.delete(this.getFile(collectible, TRANSFER_FILE_EXTENSION));
        }
    }

    private void delete(File file) {
        if (!file.delete()) {
            if (file.getName().endsWith(DEL_FILE_EXTENSION)) {
                file.deleteOnExit();
                return;
            }
            File toDelete = new File(file, DEL_FILE_EXTENSION);
            if (file.renameTo(toDelete)) {
                toDelete.deleteOnExit();
            }
        }
    }

    private Collectible<?> getCollectible(File file) {
        ObjectInputStream objectis = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            InputStream decris = this.getDecryptor(fis);
            InputStream gzipis = this.getDecompressor(decris);
            objectis = new ObjectInputStream(gzipis);
            Collectible collectible = (Collectible)objectis.readObject();
            IOUtils.close((Closeable)objectis);
            return collectible;
        }
        catch (Exception e) {
            SimpleStore.trace("Error retrieving collectible: " + e.getMessage());
            if (file.exists() && !file.delete()) {
                file.deleteOnExit();
            }
            return null;
        }
        finally {
            IOUtils.close(objectis);
        }
    }

    private void putCollectible(Collectible<?> collectible, File file) {
        block6: {
            ObjectOutputStream objectos = null;
            try {
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    OutputStream encos = this.getEncryptor(fos);
                    OutputStream gzipos = this.getCompressor(encos);
                    objectos = new ObjectOutputStream(gzipos);
                    objectos.writeObject(collectible);
                }
                catch (IOException e) {
                    SimpleStore.trace("Error storing collectible: " + e.getMessage());
                    if (file.exists() && !file.delete()) {
                        file.deleteOnExit();
                    }
                    IOUtils.close(objectos);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(objectos);
                throw throwable;
            }
            IOUtils.close((Closeable)objectos);
        }
    }

    private File getFile(Collectible<?> collectible, String extension) {
        return new File(this.storeFolder, String.valueOf(collectible.getCategory()) + CATEGORY_DELIMITER + collectible.getUUID().toString() + extension);
    }

    private static Cipher getCipher(int mode) throws GeneralSecurityException {
        Cipher desCipher = Cipher.getInstance("DES");
        desCipher.init(mode, SimpleStore.getKey());
        return desCipher;
    }

    private static Key getKey() throws GeneralSecurityException {
        DESKeySpec pass = new DESKeySpec(KEY);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
        SecretKey s = skf.generateSecret(pass);
        return s;
    }

    private static void trace(String line) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Cleaner
    extends Job {
        public Cleaner() {
            super("SimpleStoreCleaner");
            this.setUser(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            SimpleStore.trace("Store Cleaner started");
            monitor.beginTask("Cleanup", -1);
            this.clean();
            monitor.done();
            this.schedule(SimpleStore.this.cleanupDelay);
            SimpleStore.trace("Store Cleaner ended");
            return Status.OK_STATUS;
        }

        private void clean() {
            File[] scrutinizedFiles = SimpleStore.this.storeFolder.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(SimpleStore.COLLECT_FILE_EXTENSION) || name.endsWith(SimpleStore.DEL_FILE_EXTENSION);
                }
            });
            HashMap<String, ArrayList<File>> categorizedScrutinized = new HashMap<String, ArrayList<File>>(scrutinizedFiles.length);
            File[] fileArray = scrutinizedFiles;
            int n = scrutinizedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File scrutinizedFile = fileArray[n2];
                int categoryDelimiterIndex = scrutinizedFile.getName().indexOf(SimpleStore.CATEGORY_DELIMITER);
                if (categoryDelimiterIndex != -1) {
                    String category = scrutinizedFile.getName().substring(0, categoryDelimiterIndex);
                    ArrayList<File> files = (ArrayList<File>)categorizedScrutinized.get(category);
                    if (files == null) {
                        files = new ArrayList<File>();
                        categorizedScrutinized.put(category, files);
                    }
                    files.add(scrutinizedFile);
                }
                ++n2;
            }
            for (Map.Entry entry : categorizedScrutinized.entrySet()) {
                this.clean((List)entry.getValue(), ((Category)SimpleStore.this.categories.get(entry.getKey())).getMaxItems());
            }
        }

        private void clean(List<File> files, int maxItems) {
            if (files.size() < maxItems) {
                return;
            }
            Collections.sort(files, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    Long time1 = file1.lastModified();
                    Long time2 = file2.lastModified();
                    return time1.compareTo(time2);
                }
            });
            int i = 0;
            while (i < files.size() - maxItems) {
                SimpleStore.this.delete(files.get(i));
                ++i;
            }
        }
    }
}

