/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.common.authentication;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import org.eclipse.riena.security.common.authentication.credentials.AbstractCredential;
import org.eclipse.riena.security.common.authentication.credentials.ChoiceCredential;
import org.eclipse.riena.security.common.authentication.credentials.ConfirmationCredential;
import org.eclipse.riena.security.common.authentication.credentials.CustomCredential;
import org.eclipse.riena.security.common.authentication.credentials.LanguageCredential;
import org.eclipse.riena.security.common.authentication.credentials.NameCredential;
import org.eclipse.riena.security.common.authentication.credentials.PasswordCredential;
import org.eclipse.riena.security.common.authentication.credentials.TextInputCredential;
import org.eclipse.riena.security.common.authentication.credentials.TextOutputCredential;

public final class Callback2CredentialConverter {
    private Callback2CredentialConverter() {
    }

    public static AbstractCredential[] callbacks2Credentials(Callback[] callbacks) {
        AbstractCredential[] creds = new AbstractCredential[callbacks.length];
        int i = 0;
        Callback[] callbackArray = callbacks;
        int n = callbacks.length;
        int n2 = 0;
        while (n2 < n) {
            Callback ccb;
            Callback cb = callbackArray[n2];
            if (cb instanceof NameCallback) {
                NameCallback ncb = (NameCallback)cb;
                NameCredential nc = new NameCredential(ncb.getPrompt(), ncb.getDefaultName());
                nc.setName(ncb.getName());
                creds[i++] = nc;
            } else if (cb instanceof PasswordCallback) {
                PasswordCallback pcb = (PasswordCallback)cb;
                PasswordCredential pc = new PasswordCredential(pcb.getPrompt(), pcb.isEchoOn());
                pc.setPassword(pcb.getPassword());
                creds[i++] = pc;
            } else if (cb instanceof ConfirmationCallback) {
                ccb = (ConfirmationCallback)cb;
                ConfirmationCredential ccc = new ConfirmationCredential(((ConfirmationCallback)ccb).getMessageType(), ((ConfirmationCallback)ccb).getOptionType(), ((ConfirmationCallback)ccb).getDefaultOption());
                ccc.setSelectedIndex(((ConfirmationCallback)ccb).getSelectedIndex());
                creds[i++] = ccc;
            } else if (cb instanceof TextInputCallback) {
                TextInputCallback ticb = (TextInputCallback)cb;
                TextInputCredential tic = new TextInputCredential(ticb.getPrompt(), ticb.getDefaultText());
                tic.setText(ticb.getText());
                creds[i++] = tic;
            } else if (cb instanceof TextOutputCallback) {
                TextOutputCallback tocb = (TextOutputCallback)cb;
                TextOutputCredential toc = new TextOutputCredential(tocb.getMessageType(), tocb.getMessage());
                creds[i++] = toc;
            } else if (cb instanceof LanguageCallback) {
                LanguageCallback lcb = (LanguageCallback)cb;
                LanguageCredential lc = new LanguageCredential(lcb.getLocale());
                creds[i++] = lc;
            } else if (cb instanceof ChoiceCallback) {
                ccb = (ChoiceCallback)cb;
                ChoiceCredential cc = new ChoiceCredential(((ChoiceCallback)ccb).getPrompt(), ((ChoiceCallback)ccb).getChoices(), ((ChoiceCallback)ccb).getDefaultChoice(), ((ChoiceCallback)ccb).allowMultipleSelections());
                cc.setSelections(((ChoiceCallback)ccb).getSelectedIndexes());
                creds[i++] = cc;
            } else {
                CustomCredential cc = new CustomCredential(cb);
                creds[i++] = cc;
            }
            ++n2;
        }
        return creds;
    }

    public static Callback[] credentials2Callbacks(AbstractCredential[] credentials) {
        Callback[] callbacks = new Callback[credentials.length];
        int i = 0;
        AbstractCredential[] abstractCredentialArray = credentials;
        int n = credentials.length;
        int n2 = 0;
        while (n2 < n) {
            Callback ccb;
            AbstractCredential cc;
            AbstractCredential cred = abstractCredentialArray[n2];
            if (cred instanceof NameCredential) {
                NameCredential nc = (NameCredential)cred;
                NameCallback ncb = nc.getDefaultName() == null ? new NameCallback(nc.getPrompt()) : new NameCallback(nc.getPrompt(), nc.getDefaultName());
                ncb.setName(nc.getName());
                callbacks[i++] = ncb;
            } else if (cred instanceof PasswordCredential) {
                PasswordCredential pc = (PasswordCredential)cred;
                PasswordCallback pcb = new PasswordCallback(pc.getPrompt(), pc.isEchoOn());
                pcb.setPassword(pc.getPassword());
                callbacks[i++] = pcb;
            } else if (cred instanceof ConfirmationCredential) {
                cc = (ConfirmationCredential)cred;
                ccb = new ConfirmationCallback(((ConfirmationCredential)cc).getMessageType(), ((ConfirmationCredential)cc).getOptionType(), ((ConfirmationCredential)cc).getDefaultOption());
                ((ConfirmationCallback)ccb).setSelectedIndex(((ConfirmationCredential)cc).getSelectedIndex());
                callbacks[i++] = ccb;
            } else if (cred instanceof TextInputCredential) {
                TextInputCredential tic = (TextInputCredential)cred;
                TextInputCallback ticb = new TextInputCallback(tic.getPrompt(), tic.getDefaultText());
                ticb.setText(tic.getText());
                callbacks[i++] = ticb;
            } else if (cred instanceof TextOutputCredential) {
                TextOutputCredential toc = (TextOutputCredential)cred;
                TextOutputCallback tocb = new TextOutputCallback(toc.getMessageType(), toc.getMessage());
                callbacks[i++] = tocb;
            } else if (cred instanceof LanguageCredential) {
                LanguageCredential lc = (LanguageCredential)cred;
                LanguageCallback lcb = new LanguageCallback();
                lcb.setLocale(lc.getLocale());
                callbacks[i++] = lcb;
            } else if (cred instanceof ChoiceCredential) {
                cc = (ChoiceCredential)cred;
                ccb = new ChoiceCallback(cc.getPrompt(), ((ChoiceCredential)cc).getChoices(), ((ChoiceCredential)cc).getDefaultChoice(), ((ChoiceCredential)cc).isMultipleSelectionsAllowed());
                int[] selections = ((ChoiceCredential)cc).getSelections();
                if (selections.length == 1) {
                    ((ChoiceCallback)ccb).setSelectedIndex(selections[0]);
                } else {
                    ((ChoiceCallback)ccb).setSelectedIndexes(((ChoiceCredential)cc).getSelections());
                }
                callbacks[i++] = ccb;
            } else if (cred instanceof CustomCredential) {
                callbacks[i++] = ((CustomCredential)cred).getCallback();
            }
            ++n2;
        }
        return callbacks;
    }
}

