/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.discovery;

import com.caucho.hessian.client.HessianRuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.communication.core.IRemoteServiceReference;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.IRemoteServiceRegistry;
import org.eclipse.riena.communication.core.RemoteServiceDescription;
import org.eclipse.riena.communication.core.factory.RemoteServiceFactory;
import org.eclipse.riena.communication.core.publisher.IServicePublishEventDispatcher;
import org.eclipse.riena.internal.communication.discovery.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServiceDiscovery {
    private static final RemoteServiceDescription[] EMPTY_SERVICE_ENTRY_ARRAY = new RemoteServiceDescription[0];
    private IRemoteServiceRegistry registry;
    private RemoteServiceFactory rsFactory;
    private Map<String, RemoteServiceDescription> unpublishedServices = new HashMap<String, RemoteServiceDescription>();
    private BundleContext context;
    private static final Logger LOGGER = Activator.getDefault().getLogger(RemoteServiceDiscovery.class);

    RemoteServiceDiscovery(BundleContext context) {
        this.context = context;
    }

    private synchronized RemoteServiceDescription[] getAllServices() {
        ServiceReference refPublisher = this.context.getServiceReference(IServicePublishEventDispatcher.class.getName());
        if (refPublisher == null) {
            LOGGER.log(2, "no IServicePublishEventDispatcher service available [" + IServicePublishEventDispatcher.class.getName() + "]");
            return EMPTY_SERVICE_ENTRY_ARRAY;
        }
        IServicePublishEventDispatcher servicePublisher = (IServicePublishEventDispatcher)this.context.getService(refPublisher);
        try {
            RemoteServiceDescription[] rsDescriptions = servicePublisher.getAllServices();
            if (rsDescriptions == null) {
                RemoteServiceDescription[] remoteServiceDescriptionArray = EMPTY_SERVICE_ENTRY_ARRAY;
                return remoteServiceDescriptionArray;
            }
            RemoteServiceDescription[] remoteServiceDescriptionArray = rsDescriptions;
            return remoteServiceDescriptionArray;
        }
        finally {
            this.context.ungetService(refPublisher);
        }
    }

    private synchronized void updateInRegistry(RemoteServiceDescription[] rsDescriptions) {
        List registeredServices = this.registry.registeredServices(null);
        HashMap<String, IRemoteServiceRegistration> existingPathsMap = new HashMap<String, IRemoteServiceRegistration>();
        for (IRemoteServiceRegistration registeredService : registeredServices) {
            String url = registeredService.getReference().getURL();
            existingPathsMap.put(url, registeredService);
        }
        ArrayList<RemoteServiceDescription> newServices = new ArrayList<RemoteServiceDescription>();
        RemoteServiceDescription[] remoteServiceDescriptionArray = rsDescriptions;
        int n = rsDescriptions.length;
        int url = 0;
        while (url < n) {
            RemoteServiceDescription rsDescription = remoteServiceDescriptionArray[url];
            if (existingPathsMap.get(rsDescription.getURL()) != null) {
                existingPathsMap.remove(rsDescription.getURL());
            } else {
                newServices.add(rsDescription);
            }
            ++url;
        }
        for (IRemoteServiceRegistration serviceReg : existingPathsMap.values()) {
            if (!serviceReg.getReference().getContext().equals(Activator.getDefault().getContext())) continue;
            serviceReg.unregister();
        }
        ArrayList<IRemoteServiceReference> rsReferences = new ArrayList<IRemoteServiceReference>();
        for (RemoteServiceDescription rsDesc : newServices) {
            Class<?> interfaceClass = this.loadClass(rsDesc);
            rsDesc.setServiceInterfaceClass(interfaceClass);
            LOGGER.log(4, "creating service with uri=" + rsDesc.getURL());
            IRemoteServiceReference rsRef = this.createReference(rsDesc);
            if (rsRef != null) {
                rsReferences.add(rsRef);
                continue;
            }
            LOGGER.log(4, "*****************");
            this.addAsUnpublished(rsDesc);
        }
        for (IRemoteServiceReference rsRef : rsReferences) {
            this.registry.registerService(rsRef, Activator.getDefault().getContext());
        }
    }

    private IRemoteServiceReference createReference(RemoteServiceDescription rsDesc) {
        IRemoteServiceReference rsRef = this.rsFactory.createProxy(rsDesc);
        rsRef.setContext(Activator.getDefault().getContext());
        return rsRef;
    }

    private void addAsUnpublished(RemoteServiceDescription rsDesc) {
        this.unpublishedServices.put(rsDesc.getURL(), rsDesc);
    }

    protected void checkForUnpublishedServices(String protocol) {
        Set<Map.Entry<String, RemoteServiceDescription>> set = this.unpublishedServices.entrySet();
        for (Map.Entry<String, RemoteServiceDescription> entry : set) {
            IRemoteServiceReference rsRef;
            RemoteServiceDescription rsDesc = entry.getValue();
            if (!rsDesc.getProtocol().equals(protocol) || (rsRef = this.createReference(rsDesc)) == null) continue;
            this.registry.registerService(rsRef, Activator.getDefault().getContext());
            set.remove(entry);
        }
    }

    private Class<?> loadClass(RemoteServiceDescription endpoint) {
        if (endpoint.getServiceInterfaceClass() != null) {
            return endpoint.getServiceInterfaceClass();
        }
        String interfaceClassName = endpoint.getServiceInterfaceClassName();
        try {
            return new RemoteServiceFactory().loadClass(interfaceClassName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not create web service interface for [" + interfaceClassName + "]", e);
        }
    }

    public void bind(IRemoteServiceRegistry registry) {
        this.registry = registry;
    }

    public void unbind(IRemoteServiceRegistry registry) {
        this.registry = registry;
    }

    void start() {
        this.update();
    }

    void update() {
        if (this.registry != null) {
            try {
                RemoteServiceDescription[] serviceDescriptions = this.getAllServices();
                if (serviceDescriptions.length > 0) {
                    this.updateInRegistry(serviceDescriptions);
                }
            }
            catch (HessianRuntimeException ex) {
                LOGGER.log(1, "update of services from server failed. " + ex.getLocalizedMessage());
            }
        }
    }

    void stop() {
        if (this.registry != null) {
            List registeredServices = this.registry.registeredServices(Activator.getDefault().getContext());
            for (IRemoteServiceRegistration rsReg : registeredServices) {
                rsReg.unregister();
            }
        }
    }

    void setRemoteServiceFactory(RemoteServiceFactory remoteServiceFactory) {
        this.rsFactory = remoteServiceFactory;
    }
}

