/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.riena.beans.common.WordNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IGroupedTreeTableRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;

public class TreeTableSubModuleController
extends SubModuleController {
    private IActionRidget buttonRename;
    private IGroupedTreeTableRidget tree;

    public TreeTableSubModuleController() {
        this(null);
    }

    public TreeTableSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void afterBind() {
        super.afterBind();
        this.bindModel();
    }

    private void bindModel() {
        Object[] roots = this.createTreeInput();
        String[] columnPropertyNames = new String[]{"word", "upperCase", "ACount"};
        String[] columnHeaders = new String[]{"Word", "Uppercase", "A Count"};
        this.tree.bindToModel(roots, WordNode.class, "children", "parent", columnPropertyNames, columnHeaders);
        this.tree.expand(roots[0]);
        this.tree.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        this.tree.setComparator(0, (Comparator)new StringComparator());
        this.tree.setComparator(1, (Comparator)new StringComparator());
        this.tree.setColumnSortable(2, false);
    }

    public void configureRidgets() {
        this.tree = (IGroupedTreeTableRidget)this.getRidget("tree");
        IToggleButtonRidget buttonEnableGrouping = (IToggleButtonRidget)this.getRidget("buttonEnableGrouping");
        IActionRidget buttonAddSibling = (IActionRidget)this.getRidget("buttonAddSibling");
        IActionRidget buttonAddChild = (IActionRidget)this.getRidget("buttonAddChild");
        this.buttonRename = (IActionRidget)this.getRidget("buttonRename");
        IActionRidget buttonDelete = (IActionRidget)this.getRidget("buttonDelete");
        IActionRidget buttonExpand = (IActionRidget)this.getRidget("buttonExpand");
        IActionRidget buttonCollapse = (IActionRidget)this.getRidget("buttonCollapse");
        this.tree.addDoubleClickListener(new IActionListener(){

            public void callback() {
                WordNode node = (WordNode)TreeTableSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                if (node != null) {
                    boolean isUpperCase = !node.isUpperCase();
                    node.setUpperCase(isUpperCase);
                }
            }
        });
        buttonEnableGrouping.setText("Grouping &Enabled");
        buttonEnableGrouping.setSelected(true);
        buttonAddSibling.setText("Add &Sibling");
        buttonAddSibling.addListener(new IActionListener(){

            public void callback() {
                WordNode parent;
                WordNode node = (WordNode)TreeTableSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                WordNode wordNode = parent = node != null ? node.getParent() : null;
                if (parent != null) {
                    new WordNode(parent, "A_NEW_SIBLING");
                }
            }
        });
        buttonAddChild.setText("Add &Child");
        buttonAddChild.addListener(new IActionListener(){

            public void callback() {
                WordNode node = (WordNode)TreeTableSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                if (node != null) {
                    new WordNode(node, "ANOTHER_CHILD");
                }
            }
        });
        this.buttonRename.setText("&Modify");
        this.buttonRename.addListener(new IActionListener(){

            public void callback() {
                String newValue;
                WordNode node = (WordNode)TreeTableSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                if (node != null && (newValue = TreeTableSubModuleController.this.getNewValue(node.getWordIgnoreUppercase())) != null) {
                    node.setWord(newValue);
                }
            }
        });
        buttonDelete.setText("&Delete");
        buttonDelete.addListener(new IActionListener(){

            public void callback() {
                WordNode parent;
                WordNode node = (WordNode)TreeTableSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                WordNode wordNode = parent = node != null ? node.getParent() : null;
                if (parent != null) {
                    List children = parent.getChildren();
                    children.remove(node);
                    parent.setChildren(children);
                }
            }
        });
        buttonExpand.setText("E&xpand");
        buttonExpand.addListener(new IActionListener(){

            public void callback() {
                WordNode node = (WordNode)TreeTableSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                if (node != null) {
                    TreeTableSubModuleController.this.tree.expand((Object)node);
                }
            }
        });
        buttonCollapse.setText("&Collapse");
        buttonCollapse.addListener(new IActionListener(){

            public void callback() {
                WordNode node = (WordNode)TreeTableSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                if (node != null) {
                    TreeTableSubModuleController.this.tree.collapse((Object)node);
                }
            }
        });
        final IObservableValue viewerSelection = this.tree.getSingleSelectionObservable();
        ComputedValue hasSelection = new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                return viewerSelection.getValue() != null;
            }
        };
        ComputedValue hasNonRootSelection = new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                boolean result = false;
                Object node = viewerSelection.getValue();
                if (node instanceof WordNode) {
                    result = ((WordNode)node).getParent() != null;
                }
                return result;
            }
        };
        DataBindingContext dbc = new DataBindingContext();
        dbc.bindValue(BeansObservables.observeValue((Object)this.tree, (String)"groupingEnabled"), BeansObservables.observeValue((Object)buttonEnableGrouping, (String)"selected"), null, null);
        this.bindEnablementToValue(dbc, (IMarkableRidget)buttonAddChild, (IObservableValue)hasSelection);
        this.bindEnablementToValue(dbc, (IMarkableRidget)buttonAddSibling, (IObservableValue)hasNonRootSelection);
        this.bindEnablementToValue(dbc, (IMarkableRidget)buttonDelete, (IObservableValue)hasNonRootSelection);
        this.bindEnablementToValue(dbc, (IMarkableRidget)this.buttonRename, (IObservableValue)hasSelection);
        this.bindEnablementToValue(dbc, (IMarkableRidget)buttonExpand, (IObservableValue)hasSelection);
        this.bindEnablementToValue(dbc, (IMarkableRidget)buttonCollapse, (IObservableValue)hasSelection);
    }

    private void bindEnablementToValue(DataBindingContext dbc, IMarkableRidget ridget, IObservableValue value) {
        dbc.bindValue(BeansObservables.observeValue((Object)ridget, (String)"enabled"), value, null, null);
    }

    private String getNewValue(Object oldValue) {
        String newValue = null;
        if (oldValue != null) {
            Shell shell = ((Button)this.buttonRename.getUIControl()).getShell();
            IInputValidator validator = new IInputValidator(){

                public String isValid(String newText) {
                    boolean isValid = newText.trim().length() > 0;
                    return isValid ? null : "Word cannot be empty!";
                }
            };
            InputDialog dialog = new InputDialog(shell, "Modify", "Enter a new word:", String.valueOf(oldValue), validator);
            int result = dialog.open();
            if (result == 0) {
                newValue = dialog.getValue();
            }
        }
        return newValue;
    }

    private WordNode[] createTreeInput() {
        WordNode groupA = new WordNode("A");
        WordNode groupB = new WordNode("B");
        WordNode groupC = new WordNode("C");
        WordNode groupD = new WordNode("D");
        WordNode groupE = new WordNode("E");
        WordNode node1 = new WordNode(groupA, "Abandonment");
        node1.setUpperCase(true);
        new WordNode(groupA, "Adventure");
        new WordNode(groupA, "Acclimatisation");
        new WordNode(groupA, "Aardwark");
        new WordNode(groupB, "Binoculars");
        new WordNode(groupB, "Beverage");
        new WordNode(groupB, "Boredom");
        new WordNode(groupB, "Ballistics");
        new WordNode(groupC, "Calculation");
        new WordNode(groupC, "Coexistence");
        new WordNode(groupC, "Cinnamon");
        new WordNode(groupC, "Celebration");
        new WordNode(groupD, "Disney");
        new WordNode(groupD, "Dictionary");
        new WordNode(groupD, "Delta");
        new WordNode(groupD, "Desperate");
        new WordNode(groupE, "Elf");
        new WordNode(groupE, "Electronics");
        new WordNode(groupE, "Elwood");
        new WordNode(groupE, "Enemy");
        return new WordNode[]{groupA, groupB, groupC, groupD, groupE};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringComparator
    implements Comparator<Object>,
    Serializable {
        private StringComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareTo(s2);
        }
    }
}

