/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.LabelRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TestBean;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.DefaultSwtControlRidgetMapper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class LabelRidgetTest
extends AbstractSWTRidgetTest {
    private static final String PLUGIN_ID = "org.eclipse.riena.tests:";
    private static final String ICON_ECLIPSE = "org.eclipse.riena.tests:/icons/eclipse.gif";
    private static final String LABEL = "testlabel";
    private static final String LABEL2 = "testlabel2";

    protected void setUp() throws Exception {
        super.setUp();
        this.getRidget().setText(LABEL);
    }

    protected ILabelRidget createRidget() {
        return new LabelRidget();
    }

    protected Label createWidget(Composite parent) {
        return new Label(parent, 0);
    }

    protected ILabelRidget getRidget() {
        return (ILabelRidget)super.getRidget();
    }

    protected Label getWidget() {
        return (Label)super.getWidget();
    }

    public void testRidgetMapping() {
        DefaultSwtControlRidgetMapper mapper = new DefaultSwtControlRidgetMapper();
        LabelRidgetTest.assertSame(LabelRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public final void testSetIcon() {
        ILabelRidget ridget = this.getRidget();
        Label control = (Label)ridget.getUIControl();
        ridget.setIcon(ICON_ECLIPSE);
        LabelRidgetTest.assertEquals((String)ICON_ECLIPSE, (String)ridget.getIcon());
        LabelRidgetTest.assertNotNull((Object)control.getImage());
        ridget.setIcon(null);
        LabelRidgetTest.assertNull((Object)ridget.getIcon());
        LabelRidgetTest.assertNull((Object)control.getImage());
        Label label = this.createWidget((Composite)this.getShell());
        Image labelImage = label.getDisplay().getSystemImage(2);
        label.setImage(labelImage);
        ILabelRidget labelRidget = this.createRidget();
        labelRidget.setUIControl((Object)label);
        LabelRidgetTest.assertSame((Object)labelImage, (Object)label.getImage());
        labelRidget.setIcon(null);
        LabelRidgetTest.assertNull((Object)labelRidget.getIcon());
        LabelRidgetTest.assertNull((Object)label.getImage());
        labelRidget.setIcon(ICON_ECLIPSE);
        LabelRidgetTest.assertEquals((String)ICON_ECLIPSE, (String)labelRidget.getIcon());
        LabelRidgetTest.assertNotNull((Object)label.getImage());
        LabelRidgetTest.assertNotSame((Object)labelImage, (Object)label.getImage());
        label = this.createWidget((Composite)this.getShell());
        label.setImage(labelImage);
        labelRidget = this.createRidget();
        labelRidget.setIcon(ICON_ECLIPSE);
        labelRidget.setUIControl((Object)label);
        LabelRidgetTest.assertNotNull((Object)label.getImage());
        LabelRidgetTest.assertNotSame((Object)labelImage, (Object)label.getImage());
    }

    public final void testSetText() throws Exception {
        ILabelRidget ridget = this.getRidget();
        Label control = (Label)ridget.getUIControl();
        ridget.setText(LABEL2);
        LabelRidgetTest.assertEquals((String)LABEL2, (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)LABEL2, (String)control.getText());
        ridget.setText("");
        LabelRidgetTest.assertEquals((String)"", (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)"", (String)control.getText());
        try {
            ridget.setText(null);
            LabelRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
    }

    public void testUpdateFromModel() throws Exception {
        ILabelRidget ridget = this.getRidget();
        TestBean bean = new TestBean();
        bean.setProperty("NewLabel");
        ridget.bindToModel((Object)bean, "property");
        LabelRidgetTest.assertEquals((Object)"NewLabel", (Object)bean.getProperty());
        LabelRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)LABEL, (String)((Label)ridget.getUIControl()).getText());
        ridget.updateFromModel();
        LabelRidgetTest.assertEquals((Object)"NewLabel", (Object)bean.getProperty());
        LabelRidgetTest.assertEquals((String)"NewLabel", (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)"NewLabel", (String)((Label)ridget.getUIControl()).getText());
    }

    public void testUpdateFromRidget() {
        ILabelRidget ridget = this.getRidget();
        Label control = (Label)ridget.getUIControl();
        TestBean bean = new TestBean();
        bean.setProperty("NewLabel");
        ridget.bindToModel((Object)bean, "property");
        ridget.updateFromModel();
        LabelRidgetTest.assertEquals((Object)"NewLabel", (Object)bean.getProperty());
        LabelRidgetTest.assertEquals((String)"NewLabel", (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)"NewLabel", (String)control.getText());
        ridget.setText(LABEL);
        LabelRidgetTest.assertEquals((Object)LABEL, (Object)bean.getProperty());
        LabelRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)LABEL, (String)control.getText());
    }

    public void testUpdateFromControl() {
        ILabelRidget ridget = this.getRidget();
        Label control = (Label)ridget.getUIControl();
        TestBean bean = new TestBean();
        bean.setProperty("NewLabel");
        ridget.bindToModel((Object)bean, "property");
        ridget.updateFromModel();
        LabelRidgetTest.assertEquals((Object)"NewLabel", (Object)bean.getProperty());
        LabelRidgetTest.assertEquals((String)"NewLabel", (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)"NewLabel", (String)control.getText());
        control.setText(LABEL);
        LabelRidgetTest.assertEquals((Object)"NewLabel", (Object)bean.getProperty());
        LabelRidgetTest.assertEquals((String)"NewLabel", (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)LABEL, (String)control.getText());
    }

    public void testUpdateFromRidgetOnRebind() throws Exception {
        ILabelRidget ridget = this.getRidget();
        Label control = (Label)ridget.getUIControl();
        TestBean bean = new TestBean();
        bean.setProperty("NewLabel");
        ridget.bindToModel((Object)bean, "property");
        ridget.updateFromModel();
        LabelRidgetTest.assertEquals((String)"NewLabel", (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)"NewLabel", (String)control.getText());
        ridget.setUIControl(null);
        LabelRidgetTest.assertEquals((String)"NewLabel", (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)"NewLabel", (String)control.getText());
        ridget.setText(LABEL);
        LabelRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)"NewLabel", (String)control.getText());
        control = new Label((Composite)this.getShell(), 0);
        ridget.setUIControl((Object)control);
        LabelRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)LABEL, (String)control.getText());
    }

    public void testDontReadValueInConstructor() throws Exception {
        ILabelRidget ridget = this.getRidget();
        AbstractObservableValue observableValue = new AbstractObservableValue(){

            protected Object doGetValue() {
                return "TestText";
            }

            public Object getValueType() {
                return String.class;
            }
        };
        ridget.bindToModel((IObservableValue)observableValue);
        LabelRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        ridget.updateFromModel();
        LabelRidgetTest.assertEquals((String)"TestText", (String)ridget.getText());
    }

    public void testSetIconLocation() throws Exception {
        ILabelRidget ridget = this.getRidget();
        Label control = (Label)ridget.getUIControl();
        LabelRidgetTest.assertNull((Object)ridget.getIconLocation());
        LabelRidgetTest.assertNull((Object)control.getImage());
        URL url = new URL("http://www.compeople.de/assets/compeople-logo.gif");
        ridget.setIconLocation(url);
        LabelRidgetTest.assertEquals((Object)url, (Object)ridget.getIconLocation());
        LabelRidgetTest.assertNotNull((Object)control.getImage());
        ridget.setIconLocation(null);
        LabelRidgetTest.assertNull((Object)ridget.getIconLocation());
        LabelRidgetTest.assertNull((Object)control.getImage());
    }

    public void testSetUIControl() throws Exception {
        ILabelRidget ridget = this.getRidget();
        Label control = this.getWidget();
        LabelRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)LABEL, (String)control.getText());
        ridget.setUIControl(null);
        LabelRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)LABEL, (String)control.getText());
        ridget.setText(LABEL2);
        ridget.setUIControl((Object)control);
        LabelRidgetTest.assertEquals((String)LABEL2, (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)LABEL2, (String)control.getText());
    }

    public void testInitText() {
        ILabelRidget ridget = this.getRidget();
        Label control = (Label)ridget.getUIControl();
        ReflectionUtils.setHidden((Object)ridget, (String)"textAlreadyInitialized", (Object)false);
        ReflectionUtils.setHidden((Object)ridget, (String)"text", null);
        control.setText("Hello!");
        ReflectionUtils.invokeHidden((Object)ridget, (String)"initText", (Object[])new Object[0]);
        LabelRidgetTest.assertEquals((String)"Hello!", (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)"Hello!", (String)control.getText());
        LabelRidgetTest.assertTrue((boolean)((Boolean)ReflectionUtils.getHidden((Object)ridget, (String)"textAlreadyInitialized")));
        control.setText("World");
        ReflectionUtils.invokeHidden((Object)ridget, (String)"initText", (Object[])new Object[0]);
        LabelRidgetTest.assertEquals((String)"Hello!", (String)ridget.getText());
        LabelRidgetTest.assertEquals((String)"World", (String)control.getText());
    }

    public void testHasChanged() throws MalformedURLException {
        ILabelRidget ridget = this.getRidget();
        URL url1 = new URL("file:/a");
        URL url2 = new URL("file:/b");
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)ridget, (String)"hasChanged", (Object[])new Object[]{url1, url2});
        LabelRidgetTest.assertTrue((boolean)ret);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)ridget, (String)"hasChanged", (Object[])new Object[]{url1, url1});
        LabelRidgetTest.assertFalse((boolean)ret);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)ridget, (String)"hasChanged", (Object[])new Object[]{url1, null});
        LabelRidgetTest.assertTrue((boolean)ret);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)ridget, (String)"hasChanged", (Object[])new Object[]{null, url2});
        LabelRidgetTest.assertTrue((boolean)ret);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)ridget, (String)"hasChanged", (Object[])new Object[]{null, null});
        LabelRidgetTest.assertFalse((boolean)ret);
    }
}

