/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.binding;

import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.riena.internal.ui.ridgets.swt.ActionRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.LabelRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.ToggleButtonRidget;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.listener.IFocusListener;
import org.eclipse.riena.ui.ridgets.swt.uibinding.DefaultSwtControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.uibinding.IMappingCondition;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

@UITestCase
public class DefaultSwtControlRidgetMapperTest
extends RienaTestCase {
    private DefaultSwtControlRidgetMapper mapper;
    private Shell shell;

    protected void setUp() throws Exception {
        super.setUp();
        this.mapper = new DefaultSwtControlRidgetMapper();
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        this.mapper = null;
        this.shell.dispose();
        this.shell = null;
        super.tearDown();
    }

    public void testAddMapping() throws Exception {
        this.mapper.addMapping(MockComposite.class, MockRidget.class);
        Class ridget = this.mapper.getRidgetClass(MockComposite.class);
        DefaultSwtControlRidgetMapperTest.assertNotNull((Object)ridget);
        DefaultSwtControlRidgetMapperTest.assertEquals((String)MockRidget.class.getName(), (String)ridget.getName());
    }

    public void testAddMappingSwtStyle() throws Exception {
        this.mapper.addMapping(MockComposite.class, MockRidget2.class, 2048);
        this.mapper.addMapping(MockComposite.class, MockRidget.class);
        Class ridget = this.mapper.getRidgetClass(MockComposite.class);
        DefaultSwtControlRidgetMapperTest.assertNotNull((Object)ridget);
        DefaultSwtControlRidgetMapperTest.assertEquals((String)MockRidget.class.getName(), (String)ridget.getName());
        MockComposite widget = new MockComposite((Composite)this.shell, 2048);
        ridget = this.mapper.getRidgetClass((Object)widget);
        DefaultSwtControlRidgetMapperTest.assertNotNull((Object)ridget);
        DefaultSwtControlRidgetMapperTest.assertEquals((String)MockRidget2.class.getName(), (String)ridget.getName());
        widget.dispose();
    }

    public void testAddMappingWithCondition() {
        FTMappingCondition condition1 = new FTMappingCondition(false);
        FTMappingCondition condition2 = new FTMappingCondition(false);
        this.mapper.addMapping(MockComposite.class, MockRidget.class, (IMappingCondition)condition1);
        this.mapper.addMapping(MockComposite.class, MockRidget2.class, (IMappingCondition)condition2);
        MockComposite widget = new MockComposite((Composite)this.shell, 0);
        try {
            condition1.setMatch(true);
            Class ridgetClass = this.mapper.getRidgetClass((Object)widget);
            DefaultSwtControlRidgetMapperTest.assertNotNull((Object)ridgetClass);
            DefaultSwtControlRidgetMapperTest.assertEquals((String)MockRidget.class.getName(), (String)ridgetClass.getName());
            condition1.setMatch(false);
            condition2.setMatch(true);
            ridgetClass = this.mapper.getRidgetClass((Object)widget);
            DefaultSwtControlRidgetMapperTest.assertNotNull((Object)ridgetClass);
            DefaultSwtControlRidgetMapperTest.assertEquals((String)MockRidget2.class.getName(), (String)ridgetClass.getName());
            condition2.setMatch(false);
            try {
                this.mapper.getRidgetClass((Object)widget);
                DefaultSwtControlRidgetMapperTest.fail();
            }
            catch (BindingException bindingException) {
                this.ok();
            }
        }
        finally {
            widget.dispose();
        }
    }

    public void testGetRidgetClass() throws Exception {
        Class ridget = this.mapper.getRidgetClass(Label.class);
        DefaultSwtControlRidgetMapperTest.assertNotNull((Object)ridget);
        DefaultSwtControlRidgetMapperTest.assertEquals((String)LabelRidget.class.getName(), (String)ridget.getName());
        try {
            this.mapper.getRidgetClass(MockComposite.class);
            DefaultSwtControlRidgetMapperTest.fail((String)"BindingException expected");
        }
        catch (BindingException bindingException) {
            this.ok("BindingException expected");
        }
    }

    public void testGetRidgetClassWidget() throws Exception {
        Button button = new Button((Composite)this.shell, -1);
        Class ridget = this.mapper.getRidgetClass((Object)button);
        DefaultSwtControlRidgetMapperTest.assertNotNull((Object)ridget);
        DefaultSwtControlRidgetMapperTest.assertEquals((String)ActionRidget.class.getName(), (String)ridget.getName());
        button = new Button((Composite)this.shell, 0x800000);
        ridget = this.mapper.getRidgetClass((Object)button);
        DefaultSwtControlRidgetMapperTest.assertNotNull((Object)ridget);
        DefaultSwtControlRidgetMapperTest.assertEquals((String)ActionRidget.class.getName(), (String)ridget.getName());
        button = new Button((Composite)this.shell, 32);
        ridget = this.mapper.getRidgetClass((Object)button);
        DefaultSwtControlRidgetMapperTest.assertNotNull((Object)ridget);
        DefaultSwtControlRidgetMapperTest.assertEquals((String)ToggleButtonRidget.class.getName(), (String)ridget.getName());
    }

    public void testIsMatching() throws Exception {
        DefaultSwtControlRidgetMapper.Mapping mapping = new DefaultSwtControlRidgetMapper.Mapping(MockComposite.class, MockRidget.class);
        DefaultSwtControlRidgetMapperTest.assertTrue((boolean)mapping.isMatching(MockComposite.class));
        DefaultSwtControlRidgetMapperTest.assertFalse((boolean)mapping.isMatching(MockComposite2.class));
        mapping = new DefaultSwtControlRidgetMapper.Mapping(MockComposite.class, MockRidget.class, 32);
        DefaultSwtControlRidgetMapperTest.assertFalse((boolean)mapping.isMatching(MockComposite.class));
        DefaultSwtControlRidgetMapperTest.assertFalse((boolean)mapping.isMatching(MockComposite2.class));
        mapping = new DefaultSwtControlRidgetMapper.Mapping(MockComposite.class, MockRidget.class, (IMappingCondition)new FTMappingCondition(true));
        DefaultSwtControlRidgetMapperTest.assertFalse((boolean)mapping.isMatching(MockComposite.class));
        DefaultSwtControlRidgetMapperTest.assertFalse((boolean)mapping.isMatching(MockComposite2.class));
    }

    public void testIsMatchingWidget() throws Exception {
        DefaultSwtControlRidgetMapper.Mapping mapping = new DefaultSwtControlRidgetMapper.Mapping(MockComposite.class, MockRidget.class);
        MockComposite comp = new MockComposite((Composite)this.shell, -1);
        DefaultSwtControlRidgetMapperTest.assertTrue((boolean)mapping.isMatching((Object)comp));
        comp.dispose();
        MockComposite2 comp2 = new MockComposite2((Composite)this.shell, -1);
        DefaultSwtControlRidgetMapperTest.assertFalse((boolean)mapping.isMatching((Object)comp2));
        comp2.dispose();
        mapping = new DefaultSwtControlRidgetMapper.Mapping(MockComposite.class, MockRidget.class, 512);
        comp = new MockComposite((Composite)this.shell, 4);
        DefaultSwtControlRidgetMapperTest.assertFalse((boolean)mapping.isMatching((Object)comp));
        comp.dispose();
        comp = new MockComposite((Composite)this.shell, 512);
        DefaultSwtControlRidgetMapperTest.assertTrue((boolean)mapping.isMatching((Object)comp));
        comp.dispose();
        comp = new MockComposite((Composite)this.shell, 66048);
        DefaultSwtControlRidgetMapperTest.assertTrue((boolean)mapping.isMatching((Object)comp));
        comp.dispose();
        FTMappingCondition condition = new FTMappingCondition(true);
        mapping = new DefaultSwtControlRidgetMapper.Mapping(MockComposite.class, MockRidget.class, (IMappingCondition)condition);
        comp = new MockComposite((Composite)this.shell, -1);
        try {
            DefaultSwtControlRidgetMapperTest.assertTrue((boolean)mapping.isMatching((Object)comp));
            condition.setMatch(false);
            DefaultSwtControlRidgetMapperTest.assertFalse((boolean)mapping.isMatching((Object)comp));
        }
        finally {
            comp.dispose();
        }
    }

    private static final class FTMappingCondition
    implements IMappingCondition {
        private boolean isMatch = true;

        public FTMappingCondition(boolean isMatch) {
            this.isMatch = isMatch;
        }

        void setMatch(boolean isMatch) {
            this.isMatch = isMatch;
        }

        public boolean isMatch(Object widget) {
            return this.isMatch;
        }
    }

    private static final class MockComposite
    extends Composite {
        public MockComposite(Composite parent, int style) {
            super(parent, style);
        }
    }

    private static final class MockComposite2
    extends Composite {
        public MockComposite2(Composite parent, int style) {
            super(parent, style);
        }
    }

    private static final class MockRidget
    implements IRidget {
        private MockRidget() {
        }

        public Object getUIControl() {
            return null;
        }

        public void setUIControl(Object uiControl) {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        }

        public boolean isVisible() {
            return false;
        }

        public void setVisible(boolean visible) {
        }

        public void addFocusListener(IFocusListener listener) {
        }

        public void removeFocusListener(IFocusListener listener) {
        }

        public void updateFromModel() {
        }

        public void requestFocus() {
        }

        public boolean hasFocus() {
            return false;
        }

        public boolean isFocusable() {
            return false;
        }

        public void setFocusable(boolean focusable) {
        }

        public String getToolTipText() {
            return null;
        }

        public void setToolTipText(String toolTipText) {
        }

        public boolean isBlocked() {
            return false;
        }

        public void setBlocked(boolean blocked) {
        }

        public String getID() {
            return null;
        }
    }

    private static final class MockRidget2
    implements IRidget {
        private MockRidget2() {
        }

        public Object getUIControl() {
            return null;
        }

        public void setUIControl(Object uiControl) {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        }

        public boolean isVisible() {
            return false;
        }

        public void setVisible(boolean visible) {
        }

        public void addFocusListener(IFocusListener listener) {
        }

        public void removeFocusListener(IFocusListener listener) {
        }

        public void updateFromModel() {
        }

        public void requestFocus() {
        }

        public boolean hasFocus() {
            return false;
        }

        public boolean isFocusable() {
            return false;
        }

        public void setFocusable(boolean focusable) {
        }

        public String getToolTipText() {
            return null;
        }

        public void setToolTipText(String toolTipText) {
        }

        public boolean isBlocked() {
            return false;
        }

        public void setBlocked(boolean blocked) {
        }

        public String getID() {
            return null;
        }
    }
}

