/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.marker;

import junit.framework.TestCase;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.core.marker.ErrorMessageMarker;
import org.eclipse.riena.ui.core.marker.MessageMarker;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.marker.TooltipMessageMarkerViewer;
import org.eclipse.riena.ui.ridgets.swt.DefaultRealm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

@UITestCase
public class TooltipMessageMarkerViewerTest
extends TestCase {
    private DefaultRealm realm;
    private Shell shell;
    private TooltipMessageMarkerViewer tooltipMessageMarkerViewer;
    private TextRidget ridget;
    private Text control;
    private String errorMessage;
    private ErrorMessageMarker errorMessageMarker;

    protected void setUp() throws Exception {
        super.setUp();
        this.realm = new DefaultRealm();
        this.shell = new Shell();
        this.control = new Text((Composite)this.shell, 2048);
        this.ridget = new TextRidget();
        this.ridget.setUIControl((Object)this.control);
        this.tooltipMessageMarkerViewer = new TooltipMessageMarkerViewer();
        this.tooltipMessageMarkerViewer.addRidget((IMarkableRidget)this.ridget);
        this.errorMessage = "TestErrorMessage";
        this.errorMessageMarker = new ErrorMessageMarker(this.errorMessage);
    }

    protected void tearDown() throws Exception {
        this.shell.dispose();
        this.shell = null;
        this.realm.dispose();
        this.realm = null;
        super.tearDown();
    }

    public void testSetMessage() throws Exception {
        TooltipMessageMarkerViewerTest.assertNull((Object)this.ridget.getToolTipText());
        this.ridget.addMarker((IMarker)this.errorMessageMarker);
        TooltipMessageMarkerViewerTest.assertEquals((String)this.errorMessage, (String)this.ridget.getToolTipText());
        TooltipMessageMarkerViewerTest.assertEquals((String)this.errorMessage, (String)this.control.getToolTipText());
        this.ridget.removeMarker((IMarker)this.errorMessageMarker);
        TooltipMessageMarkerViewerTest.assertNull((Object)this.ridget.getToolTipText());
        TooltipMessageMarkerViewerTest.assertNull((Object)this.control.getToolTipText());
    }

    public void testSetMessageExistingTooltip() throws Exception {
        String existingTooltip = "TestExistingTooltip";
        this.ridget.setToolTipText(existingTooltip);
        this.ridget.addMarker((IMarker)this.errorMessageMarker);
        TooltipMessageMarkerViewerTest.assertEquals((String)this.errorMessage, (String)this.ridget.getToolTipText());
        TooltipMessageMarkerViewerTest.assertEquals((String)this.errorMessage, (String)this.control.getToolTipText());
        this.ridget.removeMarker((IMarker)this.errorMessageMarker);
        TooltipMessageMarkerViewerTest.assertEquals((String)existingTooltip, (String)this.ridget.getToolTipText());
        TooltipMessageMarkerViewerTest.assertEquals((String)existingTooltip, (String)this.control.getToolTipText());
    }

    public void testAddRidgetWithMarker() throws Exception {
        TextRidget anotherRidget = new TextRidget();
        anotherRidget.addMarker((IMarker)this.errorMessageMarker);
        this.tooltipMessageMarkerViewer.addRidget((IMarkableRidget)anotherRidget);
        TooltipMessageMarkerViewerTest.assertEquals((String)this.errorMessage, (String)anotherRidget.getToolTipText());
        this.tooltipMessageMarkerViewer.removeRidget((IMarkableRidget)anotherRidget);
        TooltipMessageMarkerViewerTest.assertNull((Object)anotherRidget.getToolTipText());
    }

    public void testAddAndRemoveMarkerType() throws Exception {
        TextRidget anotherRidget = new TextRidget();
        String anotherMessage = "TestAnotherMessage";
        MessageMarker anotherMarker = new MessageMarker(anotherMessage);
        anotherRidget.addMarker((IMarker)anotherMarker);
        this.tooltipMessageMarkerViewer.addRidget((IMarkableRidget)anotherRidget);
        TooltipMessageMarkerViewerTest.assertNull((Object)anotherRidget.getToolTipText());
        this.tooltipMessageMarkerViewer.addMarkerType(MessageMarker.class);
        TooltipMessageMarkerViewerTest.assertEquals((String)anotherMessage, (String)anotherRidget.getToolTipText());
        this.tooltipMessageMarkerViewer.removeMarkerType(MessageMarker.class);
        TooltipMessageMarkerViewerTest.assertNull((Object)anotherRidget.getToolTipText());
    }

    public void testVisible() throws Exception {
        this.ridget.addMarker((IMarker)this.errorMessageMarker);
        this.tooltipMessageMarkerViewer.setVisible(false);
        TooltipMessageMarkerViewerTest.assertNull((Object)this.ridget.getToolTipText());
        TooltipMessageMarkerViewerTest.assertNull((Object)this.control.getToolTipText());
        this.tooltipMessageMarkerViewer.setVisible(true);
        TooltipMessageMarkerViewerTest.assertEquals((String)this.errorMessage, (String)this.ridget.getToolTipText());
        TooltipMessageMarkerViewerTest.assertEquals((String)this.errorMessage, (String)this.control.getToolTipText());
    }

    public void testSetMessageTwoMarkers() throws Exception {
        TooltipMessageMarkerViewerTest.assertNull((Object)this.ridget.getToolTipText());
        this.ridget.addMarker((IMarker)this.errorMessageMarker);
        String secondMessage = String.valueOf(this.errorMessage) + 2;
        MessageMarker secondMarker = new MessageMarker(secondMessage);
        this.tooltipMessageMarkerViewer.addMarkerType(MessageMarker.class);
        this.ridget.addMarker((IMarker)secondMarker);
        TooltipMessageMarkerViewerTest.assertEquals((String)(String.valueOf(this.errorMessage) + "; " + secondMessage), (String)this.ridget.getToolTipText());
        this.ridget.removeMarker((IMarker)this.errorMessageMarker);
        TooltipMessageMarkerViewerTest.assertEquals((String)secondMessage, (String)this.ridget.getToolTipText());
        this.ridget.removeMarker((IMarker)secondMarker);
        TooltipMessageMarkerViewerTest.assertEquals(null, (String)this.ridget.getToolTipText());
        TooltipMessageMarkerViewerTest.assertNull((Object)this.ridget.getToolTipText());
        this.ridget.addMarker((IMarker)this.errorMessageMarker);
        this.ridget.addMarker((IMarker)secondMarker);
        this.ridget.addMarker((IMarker)new MessageMarker(String.valueOf(this.errorMessage) + 3));
        this.ridget.addMarker((IMarker)new MessageMarker(String.valueOf(this.errorMessage) + 4));
        this.ridget.addMarker((IMarker)new MessageMarker(String.valueOf(this.errorMessage) + 5));
        TooltipMessageMarkerViewerTest.assertEquals((String)(String.valueOf(this.errorMessage) + "; " + secondMessage + "; " + this.errorMessage + "3; " + this.errorMessage + "4; " + this.errorMessage + "5"), (String)this.ridget.getToolTipText());
    }

    public void testBug258540() {
        TextRidget aRidget = new TextRidget();
        Text aControl = new Text((Composite)this.shell, 2048);
        aRidget.setUIControl((Object)aControl);
        aRidget.setToolTipText("tooltip");
        TooltipMessageMarkerViewerTest.assertEquals((String)"tooltip", (String)aRidget.getToolTipText());
        TooltipMessageMarkerViewerTest.assertEquals((String)"tooltip", (String)aControl.getToolTipText());
        this.tooltipMessageMarkerViewer.addRidget((IMarkableRidget)aRidget);
        TooltipMessageMarkerViewerTest.assertEquals((String)"tooltip", (String)aRidget.getToolTipText());
        TooltipMessageMarkerViewerTest.assertEquals((String)"tooltip", (String)aControl.getToolTipText());
    }

    public void testBug258540Snippet2() {
        TextRidget aRidget = new TextRidget();
        Text aControl = new Text((Composite)this.shell, 2048);
        aRidget.setUIControl((Object)aControl);
        this.tooltipMessageMarkerViewer.addRidget((IMarkableRidget)aRidget);
        aRidget.setToolTipText("tooltip");
        TooltipMessageMarkerViewerTest.assertEquals((String)"tooltip", (String)aRidget.getToolTipText());
        TooltipMessageMarkerViewerTest.assertEquals((String)"tooltip", (String)aControl.getToolTipText());
        ErrorMessageMarker marker = new ErrorMessageMarker("errormessage");
        aRidget.addMarker((IMarker)marker);
        aRidget.setToolTipText("tooltip2");
        TooltipMessageMarkerViewerTest.assertEquals((String)"errormessage", (String)aRidget.getToolTipText());
        TooltipMessageMarkerViewerTest.assertEquals((String)"errormessage", (String)aControl.getToolTipText());
        aRidget.removeMarker((IMarker)marker);
        TooltipMessageMarkerViewerTest.assertEquals((String)"tooltip2", (String)aRidget.getToolTipText());
        TooltipMessageMarkerViewerTest.assertEquals((String)"tooltip2", (String)aControl.getToolTipText());
    }
}

