/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.beans.common;

import org.eclipse.riena.beans.common.AbstractBean;

public class Person
extends AbstractBean {
    public static final String PROPERTY_FIRSTNAME = "firstname";
    public static final String PROPERTY_LASTNAME = "lastname";
    public static final String PROPERTY_EYE_COLOR = "eyeColor";
    public static final String MALE = "male";
    public static final String FEMALE = "female";
    private String lastname;
    private String firstname;
    private String gender;
    private boolean hasDog;
    private boolean hasCat;
    private boolean hasFish;
    private String birthday;
    private int eyeColor;

    public Person(String lastname, String firstname) {
        this.lastname = lastname;
        this.firstname = firstname;
        this.birthday = "";
        this.gender = MALE;
    }

    public String getLastname() {
        return this.lastname;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public Integer getEyeColor() {
        return this.eyeColor;
    }

    public void setLastname(String lastname) {
        String oldLastname = this.lastname;
        this.lastname = lastname;
        this.firePropertyChanged(PROPERTY_LASTNAME, oldLastname, lastname);
    }

    public void setFirstname(String firstname) {
        String oldFirstname = this.firstname;
        this.firstname = firstname;
        this.firePropertyChanged(PROPERTY_FIRSTNAME, oldFirstname, firstname);
    }

    public void setEyeColor(Integer newEyeColor) {
        if (newEyeColor != null) {
            this.setEyeColor((int)newEyeColor);
        }
    }

    public void setEyeColor(int newEyeColor) {
        int oldEyeColor = this.eyeColor;
        this.eyeColor = newEyeColor;
        this.firePropertyChanged(PROPERTY_EYE_COLOR, oldEyeColor, this.eyeColor);
    }

    public void setEyeColorGreen(boolean value) {
        if (value) {
            this.setEyeColor(0);
        }
    }

    public void setEyeColorGray(boolean value) {
        if (value) {
            this.setEyeColor(1);
        }
    }

    public void setEyeColorBlue(boolean value) {
        if (value) {
            this.setEyeColor(2);
        }
    }

    public void setEyeColorBrown(boolean value) {
        if (value) {
            this.setEyeColor(3);
        }
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public boolean isHasDog() {
        return this.hasDog;
    }

    public void setHasDog(boolean hasDog) {
        this.hasDog = hasDog;
    }

    public boolean isHasCat() {
        return this.hasCat;
    }

    public void setHasCat(boolean hasCat) {
        this.hasCat = hasCat;
    }

    public boolean isHasFish() {
        return this.hasFish;
    }

    public void setHasFish(boolean hasFish) {
        this.hasFish = hasFish;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Person)) {
            return false;
        }
        Person p = (Person)obj;
        return this.equalsFirstname(p) && this.equalsLastname(p);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private boolean equalsFirstname(Person person) {
        if (this.firstname == null) {
            return person.firstname == this.firstname;
        }
        return this.firstname.equals(person.firstname);
    }

    private boolean equalsLastname(Person person) {
        if (this.lastname == null) {
            return this.lastname == person.lastname;
        }
        return this.lastname.equals(person.lastname);
    }

    public String toString() {
        return String.valueOf(this.lastname) + ", " + this.firstname;
    }

    public String getListEntry() {
        return String.valueOf(this.lastname) + " - " + this.firstname;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }
}

