/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ui.internal;

/**
 * This class defines constants for looking up resources that are available
 * only within the Eclipse UI and Eclipse UI Standard Components projects.
 */
public interface IWorkbenchGraphicConstants {
	
	public final static String IMG_DTOOL_SHOW_SUPPORT = "IMG_DTOOL_SHOW_SUPPORT";  //$NON-NLS-1$

    public final static String IMG_ETOOL_IMPORT_WIZ = "IMG_ETOOL_IMPORT_WIZ"; //$NON-NLS-1$

    public final static String IMG_ETOOL_EXPORT_WIZ = "IMG_ETOOL_EXPORT_WIZ"; //$NON-NLS-1$

    public final static String IMG_ETOOL_NEW_PAGE = "IMG_ETOOL_NEW_PAGE"; //$NON-NLS-1$

    public final static String IMG_ETOOL_PIN_EDITOR = "IMG_ETOOL_PIN_EDITOR"; //$NON-NLS-1$

    public final static String IMG_ETOOL_PIN_EDITOR_DISABLED = "IMG_ETOOL_PIN_EDITOR_DISABLED"; //$NON-NLS-1$

    public final static String IMG_ETOOL_HELP_CONTENTS = "IMG_ETOOL_HELP_CONTENTS"; //$NON-NLS-1$
    
    public final static String IMG_ETOOL_HELP_SEARCH = "IMG_ETOOL_HELP_SEARCH"; //$NON-NLS-1$
    
    
    //Fast view enabled and disabled icons
    public final static String IMG_ETOOL_NEW_FASTVIEW = "IMG_ETOOL_NEW_FASTVIEW"; //$NON-NLS-1$
    public final static String IMG_DTOOL_NEW_FASTVIEW = "IMG_DTOOL_NEW_FASTVIEW"; //$NON-NLS-1$

    // TrimStack buttons
    public final static String IMG_ETOOL_RESTORE_TRIMPART = "IMG_ETOOL_RESTORE_TRIMPART"; //$NON-NLS-1$
    public final static String IMG_ETOOL_EDITOR_TRIMPART = "IMG_ETOOL_EDITOR_TRIMPART"; //$NON-NLS-1$
    
    // local toolbars
    
    public final static String IMG_LCL_CLOSE_VIEW = "IMG_LCL_CLOSE_VIEW"; //$NON-NLS-1$

    public final static String IMG_LCL_PIN_VIEW = "IMG_LCL_PIN_VIEW"; //$NON-NLS-1$

    public final static String IMG_LCL_MIN_VIEW = "IMG_LCL_MIN_VIEW"; //$NON-NLS-1$

    public final static String IMG_LCL_RENDERED_VIEW_MENU = "IMG_LCL_RENDERED_VIEW_MENU"; //$NON-NLS-1$
    
    public final static String IMG_LCL_VIEW_MENU = "IMG_LCL_VIEW_MENU"; //$NON-NLS-1$

    public final static String IMG_LCL_SELECTED_MODE = "IMG_LCL_SELECTED_MODE"; //$NON-NLS-1$

    public final static String IMG_LCL_SHOWCHILD_MODE = "IMG_LCL_SHOWCHILD_MODE"; //$NON-NLS-1$

    public final static String IMG_LCL_SHOWSYNC_RN = "IMG_LCL_SHOWSYNC_RN"; //$NON-NLS-1$

    public static final String IMG_LCL_CLOSE_VIEW_THIN = "IMG_LCL_CLOSE_VIEW_THIN"; //$NON-NLS-1$

    public static final String IMG_LCL_MIN_VIEW_THIN = "IMG_LCL_MIN_VIEW_THIN"; //$NON-NLS-1$
    
    public static final String IMG_LCL_MAX_VIEW_THIN = "IMG_LCL_MAX_VIEW_THIN"; //$NON-NLS-1$
    
    public static final String IMG_LCL_RESTORE_VIEW_THIN = "IMG_LCL_RESTORE_VIEW_THIN"; //$NON-NLS-1$
    
    public static final String IMG_LCL_SHOW_TOOLBAR_THIN = "IMG_LCL_SHOW_TOOLBAR_THIN"; //$NON-NLS-1$
    
    public static final String IMG_LCL_HIDE_TOOLBAR_THIN = "IMG_LCL_HIDE_TOOLBAR_THIN"; //$NON-NLS-1$
    
    public static final String IMG_LCL_VIEW_MENU_THIN = "IMG_LCL_VIEW_MENU_THIN"; //$NON-NLS-1$
    
    //wizard images
    public final static String IMG_WIZBAN_NEW_WIZ = "IMG_WIZBAN_NEW_WIZ"; //$NON-NLS-1$

    public final static String IMG_WIZBAN_EXPORT_WIZ = "IMG_WIZBAN_EXPORT_WIZ"; //$NON-NLS-1$

    public final static String IMG_WIZBAN_IMPORT_WIZ = "IMG_WIZBAN_IMPORT_WIZ"; //$NON-NLS-1$
    
    public final static String IMG_WIZBAN_EXPORT_PREF_WIZ = "IMG_WIZBAN_EXPORT_PREF_WIZ"; //$NON-NLS-1$

    public final static String IMG_WIZBAN_IMPORT_PREF_WIZ = "IMG_WIZBAN_IMPORT_PREF_WIZ"; //$NON-NLS-1$

    public final static String IMG_WIZBAN_WORKINGSET_WIZ = "IMG_WIZBAN_WORKINGSET_WIZ"; //$NON-NLS-1$

    public final static String IMG_VIEW_DEFAULTVIEW_MISC = "IMG_VIEW_DEFAULTVIEW_MISC"; //$NON-NLS-1$

    // part direct manipulation objects
    public final static String IMG_OBJS_DND_LEFT_SOURCE = "IMG_OBJS_DND_LEFT_SOURCE"; //$NON-NLS-1$

    public final static String IMG_OBJS_DND_LEFT_MASK = "IMG_OBJS_DND_LEFT_MASK"; //$NON-NLS-1$

    public final static String IMG_OBJS_DND_RIGHT_SOURCE = "IMG_OBJS_DND_RIGHT_SOURCE"; //$NON-NLS-1$

    public final static String IMG_OBJS_DND_RIGHT_MASK = "IMG_OBJS_DND_RIGHT_MASK"; //$NON-NLS-1$

    public final static String IMG_OBJS_DND_TOP_SOURCE = "IMG_OBJS_DND_TOP_SOURCE"; //$NON-NLS-1$

    public final static String IMG_OBJS_DND_TOP_MASK = "IMG_OBJS_DND_TOP_MASK"; //$NON-NLS-1$

    public final static String IMG_OBJS_DND_BOTTOM_SOURCE = "IMG_OBJS_DND_BOTTOM_SOURCE"; //$NON-NLS-1$

    public final static String IMG_OBJS_DND_BOTTOM_MASK = "IMG_OBJS_DND_BOTTOM_MASK"; //$NON-NLS-1$

    public final static String IMG_OBJS_DND_INVALID_SOURCE = "IMG_OBJS_DND_INVALID_SOURCE"; //$NON-NLS-1$

    public final static String IMG_OBJS_DND_INVALID_MASK = "IMG_OBJS_DND_INVALID_MASK"; //$NON-NLS-1$

    public final static String IMG_OBJS_DND_STACK_SOURCE = "IMG_OBJS_DND_STACK_SOURCE"; //$NON-NLS-1$

    public final static String IMG_OBJS_DND_STACK_MASK = "IMG_OBJS_DND_STACK_MASK"; //$NON-NLS-1$

    public final static String IMG_OBJS_DND_OFFSCREEN_SOURCE = "IMG_OBJS_DND_OFFSCREEN_SOURCE"; //$NON-NLS-1$

    public final static String IMG_OBJS_DND_OFFSCREEN_MASK = "IMG_OBJS_DND_OFFSCREEN_MASK"; //$NON-NLS-1$

    public static final String IMG_OBJS_DND_TOFASTVIEW_SOURCE = "IMG_OBJS_DND_TOFASTVIEW_SOURCE"; //$NON-NLS-1$

    public static final String IMG_OBJS_DND_TOFASTVIEW_MASK = "IMG_OBJS_DND_TOFASTVIEW_MASK"; //$NON-NLS-1$    
    
    /**
     * Identifies an activity category.
     * 
     * @since 3.0
     */
    public static final String IMG_OBJ_ACTIVITY_CATEGORY = "IMG_OBJ_ACTIVITY_CATEGORY"; //$NON-NLS-1$

    /**
     * Identifies an activity.
     * 
     * @since 3.0
     */
    public static final String IMG_OBJ_ACTIVITY = "IMG_OBJ_ACTIVITY"; //$NON-NLS-1$

    /**
     * Identifies a font.
     * 
     * @since 3.0
     */
    public static final String IMG_OBJ_FONT = "IMG_OBJ_FONT"; //$NON-NLS-1$

    /**
     * Identifies a theme category.
     * 
     * @since 3.0
     */
    public static final String IMG_OBJ_THEME_CATEGORY = "IMG_OBJ_THEME_CATEGORY"; //$NON-NLS-1$
    
    /**
     * Generic working set icon.
     * 
     * @since 3.2
     */
    public static final String IMG_OBJ_WORKING_SETS = "IMG_OBJ_WORKING_SETS"; //$NON-NLS-1$
    
    /**
     * Separator icon for selection dialogs.
     */
    public static final String IMG_OBJ_SEPARATOR = "IMG_OBJ_SEPARATOR"; //$NON-NLS-1$
    
    /** 
     * Default icon for Quick Access nodes.
     */
    public static final String IMG_OBJ_NODE = "IMG_OBJ_NODE"; //$NON-NLS-1$
    
    /** 
     * Default icon for Quick Access elements.
     */
    public static final String IMG_OBJ_ELEMENT = "IMG_OBJ_ELEMENT"; //$NON-NLS-1$

    /**
     * Icon for signed objects (such as bundles).
     * 
     * @since 3.3
     */
	public static final String IMG_OBJ_SIGNED_YES = "IMG_OBJ_SIGNED_YES"; //$NON-NLS-1$

	/**
     * Icon for unsigned objects (such as bundles).
     * 
     * @since 3.3
     */
	public static final String IMG_OBJ_SIGNED_NO = "IMG_OBJ_SIGNED_NO"; //$NON-NLS-1$

	/**
     * Icon for objects whos signing state is not known (such as bundles).
     * 
     * @since 3.3
     */
	public static final String IMG_OBJ_SIGNED_UNKNOWN = "IMG_OBJ_SIGNED_UNKNOWN"; //$NON-NLS-1$
}
