/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.application;

import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.example.client.Activator;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.swt.application.SwtApplication;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.workarea.WorkareaManager;
import org.osgi.framework.Bundle;

public class SwtExampleApplication
extends SwtApplication {
    public SwtExampleApplication() {
        String lnfClassName = System.getProperty("riena.lnf", "");
        if (!StringUtils.isEmpty((CharSequence)lnfClassName)) {
            try {
                Class lnfClass = this.getBundle().loadClass(lnfClassName);
                RienaDefaultLnf lnf = (RienaDefaultLnf)lnfClass.newInstance();
                LnfManager.setLnf((RienaDefaultLnf)lnf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected ApplicationController createApplicationController(IApplicationNode node) {
        ApplicationController controller = super.createApplicationController(node);
        controller.setMenubarVisible(true);
        return controller;
    }

    protected IApplicationNode createModel() {
        SubApplicationNode subApplication = null;
        ApplicationNode applicationNode = new ApplicationNode(new NavigationNodeId("application"), "Riena Navigation Example");
        applicationNode.setIcon(this.getIconPath("/icons/0457_a_a00.png"));
        applicationNode.create(new NavigationNodeId("org.eclipse.riena.example.navigation.subapplication"));
        applicationNode.create(new NavigationNodeId("org.eclipse.riena.example.navigate.form"));
        subApplication = new SubApplicationNode(new NavigationNodeId("playground"), "Playground");
        subApplication.setIcon(this.getIconPath("/icons/sample.gif"));
        WorkareaManager.getInstance().registerDefinition((INavigationNode)subApplication, (Object)"subapplication.2", false);
        applicationNode.addChild((INavigationNode)subApplication);
        applicationNode.create(new NavigationNodeId("org.eclipse.riena.example.sharedViews"));
        applicationNode.create(new NavigationNodeId("org.eclipse.riena.example.uiProcesses"));
        applicationNode.create(new NavigationNodeId("org.eclipse.riena.example.playground"));
        applicationNode.create(new NavigationNodeId("org.eclipse.riena.example.filters"));
        applicationNode.create(new NavigationNodeId("org.eclipse.riena.example.logcollector"));
        return applicationNode;
    }

    protected Bundle getBundle() {
        return Activator.getDefault().getBundle();
    }
}

